/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.jkube.kit.common.util.LazyBuilder;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.enricher.handler.ContainerHandler;
import org.eclipse.jkube.kit.enricher.handler.ControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.DaemonSetHandler;
import org.eclipse.jkube.kit.enricher.handler.DeploymentConfigHandler;
import org.eclipse.jkube.kit.enricher.handler.DeploymentHandler;
import org.eclipse.jkube.kit.enricher.handler.JobHandler;
import org.eclipse.jkube.kit.enricher.handler.NamespaceHandler;
import org.eclipse.jkube.kit.enricher.handler.PodTemplateHandler;
import org.eclipse.jkube.kit.enricher.handler.ProbeHandler;
import org.eclipse.jkube.kit.enricher.handler.ProjectHandler;
import org.eclipse.jkube.kit.enricher.handler.ReplicaSetHandler;
import org.eclipse.jkube.kit.enricher.handler.ReplicationControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.ServiceHandler;
import org.eclipse.jkube.kit.enricher.handler.StatefulSetHandler;

public class HandlerHub {
    private final PodTemplateHandler podTemplateHandler;
    private final LazyBuilder<DeploymentHandler> deploymentHandler;
    private final LazyBuilder<DeploymentConfigHandler> deploymentConfigHandler;
    private final LazyBuilder<ReplicaSetHandler> replicaSetHandler;
    private final LazyBuilder<ReplicationControllerHandler> replicationControllerHandler;
    private final LazyBuilder<StatefulSetHandler> statefulSetHandler;
    private final LazyBuilder<DaemonSetHandler> daemonSetHandler;
    private final LazyBuilder<JobHandler> jobHandler;
    private final LazyBuilder<NamespaceHandler> namespaceHandler;
    private final LazyBuilder<ProjectHandler> projectHandler;
    private final LazyBuilder<ServiceHandler> serviceHandler;

    public HandlerHub(GroupArtifactVersion groupArtifactVersion, Properties configuration) {
        ProbeHandler probeHandler = new ProbeHandler();
        ContainerHandler containerHandler = new ContainerHandler(configuration, groupArtifactVersion, probeHandler);
        this.podTemplateHandler = new PodTemplateHandler(containerHandler);
        this.deploymentHandler = new LazyBuilder(() -> new DeploymentHandler(this.podTemplateHandler));
        this.deploymentConfigHandler = new LazyBuilder(() -> new DeploymentConfigHandler(this.podTemplateHandler));
        this.replicaSetHandler = new LazyBuilder(() -> new ReplicaSetHandler(this.podTemplateHandler));
        this.replicationControllerHandler = new LazyBuilder(() -> new ReplicationControllerHandler(this.podTemplateHandler));
        this.statefulSetHandler = new LazyBuilder(() -> new StatefulSetHandler(this.podTemplateHandler));
        this.daemonSetHandler = new LazyBuilder(() -> new DaemonSetHandler(this.podTemplateHandler));
        this.jobHandler = new LazyBuilder(() -> new JobHandler(this.podTemplateHandler));
        this.namespaceHandler = new LazyBuilder(NamespaceHandler::new);
        this.projectHandler = new LazyBuilder(ProjectHandler::new);
        this.serviceHandler = new LazyBuilder(ServiceHandler::new);
    }

    public List<? extends ControllerHandler<?>> getControllerHandlers() {
        return Arrays.asList(this.getDaemonSetHandler(), this.getDeploymentConfigHandler(), this.getDeploymentHandler(), this.getJobHandler(), this.getReplicaSetHandler(), this.getReplicationControllerHandler(), this.getStatefulSetHandler());
    }

    public DeploymentHandler getDeploymentHandler() {
        return (DeploymentHandler)this.deploymentHandler.get();
    }

    public DeploymentConfigHandler getDeploymentConfigHandler() {
        return (DeploymentConfigHandler)this.deploymentConfigHandler.get();
    }

    public ReplicaSetHandler getReplicaSetHandler() {
        return (ReplicaSetHandler)this.replicaSetHandler.get();
    }

    public ReplicationControllerHandler getReplicationControllerHandler() {
        return (ReplicationControllerHandler)this.replicationControllerHandler.get();
    }

    public StatefulSetHandler getStatefulSetHandler() {
        return (StatefulSetHandler)this.statefulSetHandler.get();
    }

    public DaemonSetHandler getDaemonSetHandler() {
        return (DaemonSetHandler)this.daemonSetHandler.get();
    }

    public JobHandler getJobHandler() {
        return (JobHandler)this.jobHandler.get();
    }

    public NamespaceHandler getNamespaceHandler() {
        return (NamespaceHandler)this.namespaceHandler.get();
    }

    public ProjectHandler getProjectHandler() {
        return (ProjectHandler)this.projectHandler.get();
    }

    public ServiceHandler getServiceHandler() {
        return (ServiceHandler)this.serviceHandler.get();
    }
}

