/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.TCPSocketAction;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.util.CommandLine;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.resource.ProbeConfig;

public class ProbeHandler {
    public Probe getProbe(ProbeConfig probeConfig) {
        if (probeConfig == null) {
            return null;
        }
        Probe probe = new Probe();
        this.setTimeoutInProbeIfNotNull(probe, () -> ((ProbeConfig)probeConfig).getInitialDelaySeconds(), (i, p) -> p.setInitialDelaySeconds(i));
        this.setTimeoutInProbeIfNotNull(probe, () -> ((ProbeConfig)probeConfig).getTimeoutSeconds(), (i, p) -> p.setTimeoutSeconds(i));
        this.setTimeoutInProbeIfNotNull(probe, () -> ((ProbeConfig)probeConfig).getFailureThreshold(), (i, p) -> p.setFailureThreshold(i));
        this.setTimeoutInProbeIfNotNull(probe, () -> ((ProbeConfig)probeConfig).getSuccessThreshold(), (i, p) -> p.setSuccessThreshold(i));
        this.setTimeoutInProbeIfNotNull(probe, () -> ((ProbeConfig)probeConfig).getPeriodSeconds(), (i, p) -> p.setPeriodSeconds(i));
        HTTPGetAction getAction = this.getHTTPGetAction(probeConfig.getGetUrl(), probeConfig.getHttpHeaders());
        if (getAction != null) {
            probe.setHttpGet(getAction);
            return probe;
        }
        ExecAction execAction = this.getExecAction(probeConfig.getExec());
        if (execAction != null) {
            probe.setExec(execAction);
            return probe;
        }
        TCPSocketAction tcpSocketAction = this.getTCPSocketAction(probeConfig.getGetUrl(), probeConfig.getTcpPort());
        if (tcpSocketAction != null) {
            probe.setTcpSocket(tcpSocketAction);
            return probe;
        }
        return null;
    }

    private HTTPGetAction getHTTPGetAction(String getUrl, Map<String, String> headers) {
        if (getUrl == null || !getUrl.subSequence(0, 4).toString().equalsIgnoreCase("http")) {
            return null;
        }
        try {
            URL url = new URL(getUrl);
            List httpHeaders = KubernetesHelper.convertMapToHTTPHeaderList(headers);
            return new HTTPGetAction(url.getHost(), httpHeaders.isEmpty() ? null : httpHeaders, url.getPath(), new IntOrString(Integer.valueOf(url.getPort())), url.getProtocol().toUpperCase());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL " + getUrl + " given for HTTP GET readiness check");
        }
    }

    private void setTimeoutInProbeIfNotNull(Probe probe, Supplier<Integer> integerSupplier, BiConsumer<Integer, Probe> probeConsumer) {
        Integer i = integerSupplier.get();
        if (i != null) {
            probeConsumer.accept(i, probe);
        }
    }

    private TCPSocketAction getTCPSocketAction(String getUrl, String port) {
        if (port != null) {
            IntOrString portObj = new IntOrString(port);
            try {
                Integer portInt = Integer.parseInt(port);
                portObj.setIntVal(portInt);
            }
            catch (NumberFormatException e) {
                portObj.setStrVal(port);
            }
            if (getUrl == null) {
                return new TCPSocketAction(getUrl, portObj);
            }
            String validurl = getUrl.replaceFirst("(([a-zA-Z])+)://", "http://");
            try {
                URL url = new URL(validurl);
                return new TCPSocketAction(url.getHost(), portObj);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL " + getUrl + " given for TCP readiness check");
            }
        }
        return null;
    }

    private ExecAction getExecAction(String execCmd) {
        List splitCommandLine;
        if (StringUtils.isNotBlank((CharSequence)execCmd) && !(splitCommandLine = CommandLine.translateCommandline((String)execCmd)).isEmpty()) {
            return new ExecAction(splitCommandLine);
        }
        return null;
    }
}

