/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jkube.enricher.generic.ImageEnricher;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class ContainerEnvJavaOptionsMergeEnricher
extends BaseEnricher {
    public ContainerEnvJavaOptionsMergeEnricher(JKubeEnricherContext enricherContext) {
        super((EnricherContext)enricherContext, "jkube-container-env-java-options");
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (!Configs.asBoolean((String)this.getConfig(Config.DISABLE)) && this.hasImageConfiguration()) {
            builder.accept((Visitor)new ContainerEnvJavaOptionsMergeVisitor(this.getImages()));
        }
    }

    static final class ContainerEnvJavaOptionsMergeVisitor
    extends TypedVisitor<ContainerBuilder> {
        private static final String ENV_KEY = "JAVA_OPTIONS";
        private final List<ImageConfiguration> imageConfigurations;

        public ContainerEnvJavaOptionsMergeVisitor(List<ImageConfiguration> imageConfigurations) {
            this.imageConfigurations = imageConfigurations;
        }

        public void visit(ContainerBuilder containerBuilder) {
            this.imageConfigurations.stream().filter(ic -> ImageEnricher.containerImageName(ic).equals(containerBuilder.getImage())).filter(ic -> ic.getBuild().getEnv() != null).filter(ic -> !ic.getBuild().getEnv().isEmpty()).filter(ic -> ic.getBuild().getEnv().containsKey(ENV_KEY)).findFirst().ifPresent(ic -> {
                ContainerBuilder cfr_ignored_0 = (ContainerBuilder)containerBuilder.withEnv(this.mergeEnv(containerBuilder.buildEnv(), (ImageConfiguration)ic));
            });
        }

        private List<EnvVar> mergeEnv(List<EnvVar> envVars, ImageConfiguration imageConfiguration) {
            ArrayList<EnvVar> ret = new ArrayList<EnvVar>();
            for (EnvVar env : envVars) {
                if (env.getName().equalsIgnoreCase(ENV_KEY)) {
                    EnvVar merged = new EnvVar();
                    merged.setName(env.getName());
                    merged.setValueFrom(env.getValueFrom());
                    merged.setValue(String.format("%s %s", imageConfiguration.getBuild().getEnv().getOrDefault(ENV_KEY, ""), env.getValue()));
                    ret.add(merged);
                    continue;
                }
                ret.add(env);
            }
            return ret;
        }
    }

    private static enum Config implements Configs.Config
    {
        DISABLE("disable", "false");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

