/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.openshift.api.model.DeploymentConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.enricher.handler.DaemonSetHandler;
import org.eclipse.jkube.kit.enricher.handler.DeploymentConfigHandler;
import org.eclipse.jkube.kit.enricher.handler.DeploymentHandler;
import org.eclipse.jkube.kit.enricher.handler.HandlerHub;
import org.eclipse.jkube.kit.enricher.handler.JobHandler;
import org.eclipse.jkube.kit.enricher.handler.ReplicaSetHandler;
import org.eclipse.jkube.kit.enricher.handler.ReplicationControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.StatefulSetHandler;

public class DefaultControllerEnricher
extends BaseEnricher {
    protected static final String[] POD_CONTROLLER_KINDS = new String[]{"ReplicationController", "ReplicaSet", "Deployment", "DeploymentConfig", "StatefulSet", "DaemonSet", "Job"};
    private final DeploymentHandler deployHandler;
    private final DeploymentConfigHandler deployConfigHandler;
    private final ReplicationControllerHandler rcHandler;
    private final ReplicaSetHandler rsHandler;
    private final StatefulSetHandler statefulSetHandler;
    private final DaemonSetHandler daemonSetHandler;
    private final JobHandler jobHandler;

    public DefaultControllerEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-controller");
        HandlerHub handlers = new HandlerHub(this.getContext().getGav(), this.getContext().getProperties());
        this.rcHandler = handlers.getReplicationControllerHandler();
        this.rsHandler = handlers.getReplicaSetHandler();
        this.deployHandler = handlers.getDeploymentHandler();
        this.deployConfigHandler = handlers.getDeploymentConfigHandler();
        this.statefulSetHandler = handlers.getStatefulSetHandler();
        this.daemonSetHandler = handlers.getDaemonSetHandler();
        this.jobHandler = handlers.getJobHandler();
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        String name = this.getConfig(Config.NAME, JKubeProjectUtil.createDefaultResourceName((String)this.getContext().getGav().getSanitizedArtifactId(), (String[])new String[0]));
        ResourceConfig xmlResourceConfig = Optional.ofNullable(this.getConfiguration().getResource()).orElse(ResourceConfig.builder().build());
        ResourceConfig config = ResourceConfig.toBuilder((ResourceConfig)xmlResourceConfig).controllerName(this.getControllerName(xmlResourceConfig, name)).imagePullPolicy(DefaultControllerEnricher.getImagePullPolicy((ResourceConfig)xmlResourceConfig, (String)this.getConfig(Config.PULL_POLICY))).replicas(DefaultControllerEnricher.getReplicaCount((KubernetesListBuilder)builder, (ResourceConfig)xmlResourceConfig, (int)Configs.asInt((String)this.getConfig(Config.REPLICA_COUNT)))).build();
        List images = this.getImages();
        if (!KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])POD_CONTROLLER_KINDS) && !images.isEmpty()) {
            String type = this.getConfig(Config.TYPE);
            if ("deployment".equalsIgnoreCase(type) || "deploymentConfig".equalsIgnoreCase(type)) {
                if (platformMode == PlatformMode.kubernetes || platformMode == PlatformMode.openshift && this.useDeploymentForOpenShift()) {
                    this.log.info("Adding a default Deployment", new Object[0]);
                    Deployment deployment = this.deployHandler.getDeployment(config, images);
                    builder.addToItems(new HasMetadata[]{deployment});
                    this.setProcessingInstruction("FABRIC8_GENERATED_CONTAINERS", this.getContainersFromPodSpec(deployment.getSpec().getTemplate()));
                } else {
                    this.log.info("Adding a default DeploymentConfig", new Object[0]);
                    DeploymentConfig deploymentConfig = this.deployConfigHandler.getDeploymentConfig(config, images, this.getOpenshiftDeployTimeoutInSeconds(3600L), this.getValueFromConfig("jkube.openshift.imageChangeTriggers", true), this.getValueFromConfig("jkube.openshift.enableAutomaticTrigger", true), Boolean.valueOf(this.isOpenShiftMode()), this.getProcessingInstructionViaKey("FABRIC8_GENERATED_CONTAINERS"));
                    builder.addToItems(new HasMetadata[]{deploymentConfig});
                    this.setProcessingInstruction("FABRIC8_GENERATED_CONTAINERS", this.getContainersFromPodSpec(deploymentConfig.getSpec().getTemplate()));
                }
            } else if ("statefulSet".equalsIgnoreCase(type)) {
                this.log.info("Adding a default StatefulSet", new Object[0]);
                StatefulSet statefulSet = this.statefulSetHandler.getStatefulSet(config, images);
                builder.addToItems(new HasMetadata[]{statefulSet});
                this.setProcessingInstruction("FABRIC8_GENERATED_CONTAINERS", this.getContainersFromPodSpec(statefulSet.getSpec().getTemplate()));
            } else if ("daemonSet".equalsIgnoreCase(type)) {
                this.log.info("Adding a default DaemonSet", new Object[0]);
                DaemonSet daemonSet = this.daemonSetHandler.getDaemonSet(config, images);
                builder.addToItems(new HasMetadata[]{daemonSet});
                this.setProcessingInstruction("FABRIC8_GENERATED_CONTAINERS", this.getContainersFromPodSpec(daemonSet.getSpec().getTemplate()));
            } else if ("replicaSet".equalsIgnoreCase(type)) {
                this.log.info("Adding a default ReplicaSet", new Object[0]);
                ReplicaSet replicaSet = this.rsHandler.getReplicaSet(config, images);
                builder.addToItems(new HasMetadata[]{replicaSet});
                this.setProcessingInstruction("FABRIC8_GENERATED_CONTAINERS", this.getContainersFromPodSpec(replicaSet.getSpec().getTemplate()));
            } else if ("replicationController".equalsIgnoreCase(type)) {
                this.log.info("Adding a default ReplicationController", new Object[0]);
                ReplicationController replicationController = this.rcHandler.getReplicationController(config, images);
                builder.addToReplicationControllerItems(new ReplicationController[]{replicationController});
                this.setProcessingInstruction("FABRIC8_GENERATED_CONTAINERS", this.getContainersFromPodSpec(replicationController.getSpec().getTemplate()));
            } else if ("job".equalsIgnoreCase(type)) {
                this.log.info("Adding a default Job", new Object[0]);
                Job job = this.jobHandler.getJob(config, images);
                builder.addToItems(new HasMetadata[]{job});
                this.setProcessingInstruction("FABRIC8_GENERATED_CONTAINERS", this.getContainersFromPodSpec(job.getSpec().getTemplate()));
            }
        }
    }

    private List<String> getContainersFromPodSpec(PodTemplateSpec spec) {
        ArrayList<String> containerNames = new ArrayList<String>();
        spec.getSpec().getContainers().forEach(container -> containerNames.add(container.getName()));
        return containerNames;
    }

    private static enum Config implements Configs.Config
    {
        NAME("name", null),
        PULL_POLICY("pullPolicy", "IfNotPresent"),
        TYPE("type", "deployment"),
        REPLICA_COUNT("replicaCount", "1");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

