/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class RemoveBuildAnnotationsEnricher
extends BaseEnricher {
    public RemoveBuildAnnotationsEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-remove-build-annotations");
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        List items = builder.buildItems();
        for (HasMetadata item : items) {
            this.removeBuildAnnotations(item);
        }
    }

    private void removeBuildAnnotations(HasMetadata item) {
        Map annotations;
        ObjectMeta metadata;
        if (item != null && (metadata = item.getMetadata()) != null && (annotations = metadata.getAnnotations()) != null) {
            annotations.remove("maven.jkube.io/source-url");
        }
    }
}

