/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jkube.kit.common.util.GitUtil;
import org.eclipse.jkube.kit.config.resource.JKubeAnnotations;
import org.eclipse.jkube.kit.config.resource.OpenShiftAnnotations;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class GitEnricher
extends BaseEnricher {
    private static final String GIT_REMOTE = "jkube.remoteName";

    public GitEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-git");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getAnnotations(PlatformMode platformMode) {
        HashMap<String, String> annotations = new HashMap<String, String>();
        boolean useDeprecatedAnnotationPrefix = this.shouldUseLegacyJKubePrefix();
        if (GitUtil.findGitFolder((File)this.getContext().getProjectDirectory()) == null) return annotations;
        try (Repository repository = GitUtil.getGitRepository((File)this.getContext().getProjectDirectory());){
            if (repository != null) {
                String gitRemoteUrl = GitUtil.sanitizeRemoteUrl((String)this.getGitRemoteUrl(repository));
                if (gitRemoteUrl == null) {
                    this.log.warn("Could not detect any git remote", new Object[0]);
                }
                annotations.putAll(GitEnricher.getAnnotations(platformMode, gitRemoteUrl, repository.getBranch(), GitUtil.getGitCommitId((Repository)repository), useDeprecatedAnnotationPrefix));
            }
            HashMap<String, String> hashMap = annotations;
            return hashMap;
        }
        catch (IOException | GitAPIException e) {
            this.log.error("Cannot extract Git information for adding to annotations: " + e, new Object[]{e});
            return Collections.emptyMap();
        }
    }

    public void enrich(final PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<ObjectMetaBuilder>(){

            public void visit(ObjectMetaBuilder objectMetaBuilder) {
                objectMetaBuilder.addToAnnotations(GitEnricher.this.getAnnotations(platformMode));
            }
        }});
    }

    protected static Map<String, String> getAnnotations(PlatformMode platformMode, String gitRemoteUrl, String branch, String commitId, boolean useDeprecatedAnnotationPrefix) {
        HashMap<String, String> annotationsToBeAdded = new HashMap<String, String>();
        annotationsToBeAdded.putAll(GitEnricher.addAnnotation(JKubeAnnotations.GIT_BRANCH.value(useDeprecatedAnnotationPrefix), branch));
        annotationsToBeAdded.putAll(GitEnricher.addAnnotation(JKubeAnnotations.GIT_COMMIT.value(useDeprecatedAnnotationPrefix), commitId));
        annotationsToBeAdded.putAll(GitEnricher.addAnnotation(JKubeAnnotations.GIT_URL.value(useDeprecatedAnnotationPrefix), gitRemoteUrl));
        if (platformMode.equals((Object)PlatformMode.openshift)) {
            annotationsToBeAdded.putAll(GitEnricher.addAnnotation(OpenShiftAnnotations.VCS_URI.value(), gitRemoteUrl));
            annotationsToBeAdded.putAll(GitEnricher.addAnnotation(OpenShiftAnnotations.VCS_REF.value(), branch));
        }
        return annotationsToBeAdded;
    }

    private static Map<String, String> addAnnotation(String key, String value) {
        HashMap<String, String> newAnnotation = new HashMap<String, String>();
        if (value != null && key != null) {
            newAnnotation.put(key, value);
        }
        return newAnnotation;
    }

    private String getGitRemoteUrl(Repository repository) {
        String gitRemote = this.getContext().getProperty(GIT_REMOTE);
        gitRemote = gitRemote == null ? "origin" : gitRemote;
        return repository.getConfig().getString("remote", gitRemote, "url");
    }
}

