/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class PersistentVolumeClaimStorageClassEnricher
extends BaseEnricher {
    public static final String ENRICHER_NAME = "jkube-persistentvolumeclaim-storageclass";
    static final String VOLUME_STORAGE_CLASS_ANNOTATION = "volume.beta.kubernetes.io/storage-class";

    public PersistentVolumeClaimStorageClassEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, ENRICHER_NAME);
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<PersistentVolumeClaimBuilder>(){

            public void visit(PersistentVolumeClaimBuilder pvcBuilder) {
                String storageClass;
                if (pvcBuilder.buildMetadata() == null) {
                    pvcBuilder.withNewMetadata().endMetadata();
                }
                if (StringUtils.isNotBlank((CharSequence)(storageClass = PersistentVolumeClaimStorageClassEnricher.this.getStorageClass()))) {
                    if (PersistentVolumeClaimStorageClassEnricher.this.shouldUseAnnotation()) {
                        ((PersistentVolumeClaimFluent.MetadataNested)pvcBuilder.editMetadata().addToAnnotations(PersistentVolumeClaimStorageClassEnricher.VOLUME_STORAGE_CLASS_ANNOTATION, storageClass)).endMetadata();
                    } else {
                        ((PersistentVolumeClaimFluent.SpecNested)pvcBuilder.editSpec().withStorageClassName(storageClass)).endSpec();
                    }
                }
            }
        }});
    }

    private boolean shouldUseAnnotation() {
        return Boolean.parseBoolean(this.getConfig(Config.USE_ANNOTATION));
    }

    private String getStorageClass() {
        String storageClassConfig = this.getConfig(Config.DEFAULT_STORAGE_CLASS);
        if (StringUtils.isNotBlank((CharSequence)storageClassConfig)) {
            return storageClassConfig;
        }
        return null;
    }

    static enum Config implements Configs.Config
    {
        DEFAULT_STORAGE_CLASS("defaultStorageClass", null),
        USE_ANNOTATION("useStorageClassAnnotation", "false");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

