/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent;
import java.util.Collections;
import java.util.List;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.enricher.handler.DeploymentHandler;
import org.eclipse.jkube.kit.enricher.handler.HandlerHub;
import org.eclipse.jkube.kit.enricher.handler.StatefulSetHandler;

public class ControllerViaPluginConfigurationEnricher
extends BaseEnricher {
    protected static final String[] POD_CONTROLLER_KINDS = new String[]{"ReplicationController", "ReplicaSet", "Deployment", "DeploymentConfig", "StatefulSet", "DaemonSet", "Job"};
    private final DeploymentHandler deployHandler;
    private final StatefulSetHandler statefulSetHandler;

    public ControllerViaPluginConfigurationEnricher(JKubeEnricherContext context) {
        super((EnricherContext)context, "jkube-controller-from-configuration");
        HandlerHub handlers = new HandlerHub(this.getContext().getGav(), this.getContext().getProperties());
        this.deployHandler = handlers.getDeploymentHandler();
        this.statefulSetHandler = handlers.getStatefulSetHandler();
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        final String name = this.getConfig(Config.NAME, JKubeProjectUtil.createDefaultResourceName((String)this.getContext().getGav().getSanitizedArtifactId(), (String[])new String[0]));
        ResourceConfig xmlResourceConfig = this.getConfiguration().getResource();
        ResourceConfig config = ResourceConfig.builder().controllerName(name).imagePullPolicy(ControllerViaPluginConfigurationEnricher.getImagePullPolicy((ResourceConfig)xmlResourceConfig, (String)this.getConfig(Config.PULL_POLICY))).replicas(Integer.valueOf(ControllerViaPluginConfigurationEnricher.getReplicaCount((KubernetesListBuilder)builder, (ResourceConfig)xmlResourceConfig, (int)Configs.asInt((String)this.getConfig(Config.REPLICA_COUNT))))).build();
        List images = this.getImages();
        if (KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])POD_CONTROLLER_KINDS)) {
            if (KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])new String[]{"StatefulSet"})) {
                final StatefulSetSpec spec = this.statefulSetHandler.get(config, images).getSpec();
                if (spec != null) {
                    builder.accept(new Visitor[]{new TypedVisitor<StatefulSetBuilder>(){

                        public void visit(StatefulSetBuilder statefulSetBuilder) {
                            ((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)statefulSetBuilder.editOrNewSpec().editOrNewTemplate().editOrNewSpec().endSpec()).endTemplate()).endSpec();
                            ControllerViaPluginConfigurationEnricher.this.mergeStatefulSetSpec(statefulSetBuilder, spec);
                        }
                    }});
                    if (spec.getTemplate() != null && spec.getTemplate().getSpec() != null) {
                        final PodSpec podSpec = spec.getTemplate().getSpec();
                        builder.accept(new Visitor[]{new TypedVisitor<PodSpecBuilder>(){

                            public void visit(PodSpecBuilder builder) {
                                String defaultApplicationContainerName = KubernetesResourceUtil.mergePodSpec((PodSpecBuilder)builder, (PodSpec)podSpec, (String)name, (boolean)ControllerViaPluginConfigurationEnricher.this.getValueFromConfig("jkube.sidecar", false));
                                if (defaultApplicationContainerName != null) {
                                    ControllerViaPluginConfigurationEnricher.this.setProcessingInstruction("IMAGECHANGE_TRIGGER", Collections.singletonList(defaultApplicationContainerName));
                                }
                            }
                        }});
                    }
                }
            } else {
                final DeploymentSpec spec = this.deployHandler.get(config, images).getSpec();
                if (spec != null) {
                    builder.accept(new Visitor[]{new TypedVisitor<DeploymentBuilder>(){

                        public void visit(DeploymentBuilder deploymentBuilder) {
                            ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)deploymentBuilder.editOrNewSpec().editOrNewTemplate().editOrNewSpec().endSpec()).endTemplate()).endSpec();
                            ControllerViaPluginConfigurationEnricher.this.mergeDeploymentSpec(deploymentBuilder, spec);
                        }
                    }});
                    if (spec.getTemplate() != null && spec.getTemplate().getSpec() != null) {
                        final PodSpec podSpec = spec.getTemplate().getSpec();
                        builder.accept(new Visitor[]{new TypedVisitor<PodSpecBuilder>(){

                            public void visit(PodSpecBuilder builder) {
                                String defaultApplicationContainerName = KubernetesResourceUtil.mergePodSpec((PodSpecBuilder)builder, (PodSpec)podSpec, (String)name, (boolean)ControllerViaPluginConfigurationEnricher.this.getValueFromConfig("jkube.sidecar", false));
                                if (defaultApplicationContainerName != null) {
                                    ControllerViaPluginConfigurationEnricher.this.setProcessingInstruction("IMAGECHANGE_TRIGGER", Collections.singletonList(defaultApplicationContainerName));
                                }
                            }
                        }});
                    }
                }
            }
        }
    }

    private void mergeDeploymentSpec(DeploymentBuilder builder, DeploymentSpec spec) {
        DeploymentFluent.SpecNested specBuilder = builder.editSpec();
        KubernetesResourceUtil.mergeSimpleFields((Object)specBuilder, (Object)spec);
        specBuilder.endSpec();
    }

    private void mergeStatefulSetSpec(StatefulSetBuilder builder, StatefulSetSpec spec) {
        StatefulSetFluent.SpecNested specBuilder = builder.editSpec();
        KubernetesResourceUtil.mergeSimpleFields((Object)specBuilder, (Object)spec);
        specBuilder.endSpec();
    }

    private static enum Config implements Configs.Config
    {
        NAME("name", null),
        PULL_POLICY("pullPolicy", "IfNotPresent"),
        REPLICA_COUNT("replicaCount", "1");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

