/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressRuleValueBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackend;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRule;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpec;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLS;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLSBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPortBuilder;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.enricher.generic.IngressEnricher;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.config.resource.IngressRuleConfig;
import org.eclipse.jkube.kit.config.resource.IngressRulePathConfig;
import org.eclipse.jkube.kit.config.resource.IngressRulePathResourceConfig;
import org.eclipse.jkube.kit.config.resource.IngressTlsConfig;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class NetworkingV1IngressGenerator {
    private NetworkingV1IngressGenerator() {
    }

    protected static Ingress generate(KubernetesListBuilder listBuilder, ServiceBuilder serviceBuilder, String routeDomainPostfix, String host, List<IngressRuleConfig> ingressRuleConfigs, List<IngressTlsConfig> ingressTlsConfigs, KitLogger log) {
        ObjectMeta serviceMetadata = serviceBuilder.buildMetadata();
        if (serviceMetadata == null) {
            log.info("No Metadata for service! ", new Object[0]);
        }
        if (KubernetesResourceUtil.isExposedService((ObjectMeta)serviceMetadata) && IngressEnricher.shouldCreateExternalURLForService(serviceBuilder, log)) {
            Integer servicePort;
            Objects.requireNonNull(serviceMetadata);
            String serviceName = serviceMetadata.getName();
            if (!IngressEnricher.hasIngress(listBuilder, serviceName) && (servicePort = IngressEnricher.getServicePort(serviceBuilder)) != null) {
                return ((IngressBuilder)((IngressBuilder)new IngressBuilder().withMetadata(IngressEnricher.getIngressMetadata(serviceMetadata))).withSpec(NetworkingV1IngressGenerator.getIngressSpec(routeDomainPostfix, host, serviceName, servicePort, ingressRuleConfigs, ingressTlsConfigs))).build();
            }
        }
        return null;
    }

    private static IngressSpec getIngressSpec(String routeDomainPostfix, String host, String serviceName, Integer servicePort, List<IngressRuleConfig> ingressRuleConfig, List<IngressTlsConfig> ingressTlsConfigs) {
        if (ingressRuleConfig == null || ingressRuleConfig.isEmpty()) {
            return NetworkingV1IngressGenerator.getOpinionatedIngressSpec(routeDomainPostfix, host, serviceName, servicePort);
        }
        return NetworkingV1IngressGenerator.getXmlConfiguredIngressSpec(ingressRuleConfig, ingressTlsConfigs);
    }

    private static IngressSpec getXmlConfiguredIngressSpec(List<IngressRuleConfig> ingressRuleConfigs, List<IngressTlsConfig> ingressTlsConfigs) {
        IngressSpecBuilder ingressSpecBuilder = new IngressSpecBuilder();
        for (IngressRuleConfig ingressRuleConfig : ingressRuleConfigs) {
            IngressRule ingressRule = NetworkingV1IngressGenerator.getIngressRuleFromXmlConfig(ingressRuleConfig);
            ingressSpecBuilder.addToRules(new IngressRule[]{ingressRule});
        }
        for (IngressTlsConfig ingressTlsConfig : ingressTlsConfigs) {
            IngressTLS ingressTLS = NetworkingV1IngressGenerator.getIngressTlsFromXMLConfig(ingressTlsConfig);
            ingressSpecBuilder.addToTls(new IngressTLS[]{ingressTLS});
        }
        return ingressSpecBuilder.build();
    }

    private static IngressTLS getIngressTlsFromXMLConfig(IngressTlsConfig ingressTlsConfig) {
        IngressTLSBuilder ingressTLSBuilder = new IngressTLSBuilder();
        if (ingressTlsConfig.getHosts() != null && !ingressTlsConfig.getHosts().isEmpty()) {
            ingressTLSBuilder.withHosts(ingressTlsConfig.getHosts());
        }
        if (ingressTlsConfig.getSecretName() != null) {
            ingressTLSBuilder.withSecretName(ingressTlsConfig.getSecretName());
        }
        return ingressTLSBuilder.build();
    }

    private static IngressSpec getOpinionatedIngressSpec(String routeDomainPostfix, String host, String serviceName, Integer servicePort) {
        IngressSpecBuilder ingressSpecBuilder = new IngressSpecBuilder();
        if (StringUtils.isNotBlank((CharSequence)routeDomainPostfix) || StringUtils.isNotBlank((CharSequence)host)) {
            ((IngressSpecBuilder)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((IngressSpecFluent.RulesNested)ingressSpecBuilder.addNewRule().withHost(IngressEnricher.resolveIngressHost(serviceName, routeDomainPostfix, host))).withNewHttp().withPaths(new HTTPIngressPath[]{((HTTPIngressPathBuilder)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathBuilder)((HTTPIngressPathBuilder)new HTTPIngressPathBuilder().withPathType("Exact")).withPath("/")).withNewBackend().withService(NetworkingV1IngressGenerator.getIngressServiceBackend(serviceName, servicePort))).endBackend()).build()})).endHttp()).endRule()).build();
        } else {
            ingressSpecBuilder.withDefaultBackend(((IngressBackendBuilder)new IngressBackendBuilder().withService(NetworkingV1IngressGenerator.getIngressServiceBackend(serviceName, servicePort))).build());
        }
        return ingressSpecBuilder.build();
    }

    private static IngressRule getIngressRuleFromXmlConfig(IngressRuleConfig ingressRuleConfig) {
        IngressRuleBuilder ingressRuleBuilder = new IngressRuleBuilder();
        if (ingressRuleConfig.getHost() != null) {
            ingressRuleBuilder.withHost(ingressRuleConfig.getHost());
        }
        if (ingressRuleConfig.getPaths() != null && !ingressRuleConfig.getPaths().isEmpty()) {
            HTTPIngressRuleValueBuilder httpIngressPathBuilder = new HTTPIngressRuleValueBuilder();
            for (IngressRulePathConfig ingressRulePathConfig : ingressRuleConfig.getPaths()) {
                httpIngressPathBuilder.addToPaths(new HTTPIngressPath[]{NetworkingV1IngressGenerator.getHTTPIngressPath(ingressRulePathConfig)});
            }
            ingressRuleBuilder.withHttp(httpIngressPathBuilder.build());
        }
        return ingressRuleBuilder.build();
    }

    private static HTTPIngressPath getHTTPIngressPath(IngressRulePathConfig ingressRulePathConfig) {
        HTTPIngressPathBuilder httpIngressPathBuilder = new HTTPIngressPathBuilder();
        if (ingressRulePathConfig.getPath() != null) {
            httpIngressPathBuilder.withPath(ingressRulePathConfig.getPath());
        }
        if (ingressRulePathConfig.getPathType() != null) {
            httpIngressPathBuilder.withPathType(ingressRulePathConfig.getPathType());
        }
        return ((HTTPIngressPathBuilder)httpIngressPathBuilder.withBackend(NetworkingV1IngressGenerator.getIngressBackend(ingressRulePathConfig))).build();
    }

    private static IngressBackend getIngressBackend(IngressRulePathConfig ingressRulePathConfig) {
        IngressBackendBuilder ingressBackendBuilder = new IngressBackendBuilder();
        if (ingressRulePathConfig.getResource() != null) {
            IngressRulePathResourceConfig resource = ingressRulePathConfig.getResource();
            ingressBackendBuilder.withNewResource(resource.getApiGroup(), resource.getKind(), resource.getName());
        }
        ingressBackendBuilder.withService(NetworkingV1IngressGenerator.getIngressServiceBackend(ingressRulePathConfig.getServiceName(), ingressRulePathConfig.getServicePort()));
        return ingressBackendBuilder.build();
    }

    private static IngressServiceBackend getIngressServiceBackend(String serviceName, int servicePort) {
        IngressServiceBackendBuilder ingressServiceBackendBuilder = new IngressServiceBackendBuilder();
        if (serviceName != null) {
            ingressServiceBackendBuilder.withName(serviceName);
        }
        if (servicePort > 0) {
            ingressServiceBackendBuilder.withPort(((ServiceBackendPortBuilder)new ServiceBackendPortBuilder().withNumber(Integer.valueOf(servicePort))).build());
        }
        return ingressServiceBackendBuilder.build();
    }
}

