/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic.openshift;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class ExposeEnricher
extends BaseEnricher {
    public static final String EXPOSE_LABEL = "expose";
    private static final Set<Integer> WEB_PORTS = new HashSet<Integer>(Arrays.asList(80, 443, 8080, 9080, 9090, 9443));

    public ExposeEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-openshift-service-expose");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder serviceBuilder) {
                ExposeEnricher.this.enrichService(serviceBuilder);
            }
        }});
    }

    private void enrichService(ServiceBuilder serviceBuilder) {
        ObjectMeta serviceMetadata;
        if (this.hasWebPort(serviceBuilder) && !KubernetesResourceUtil.containsLabelInMetadata((ObjectMeta)(serviceMetadata = serviceBuilder.buildMetadata()), (String)EXPOSE_LABEL, (String)"false")) {
            this.log.verbose("Adding Service label '%s:true' on service %s so that it is exposed by the exposecontroller microservice. To disable use the maven argument: '-Dfabric8.profile=internal-microservice'", new Object[]{EXPOSE_LABEL, KubernetesHelper.getName((ObjectMeta)serviceMetadata)});
            ((ServiceFluent.MetadataNested)serviceBuilder.editOrNewMetadata().addToLabels(EXPOSE_LABEL, "true")).endMetadata();
        }
    }

    private boolean hasWebPort(ServiceBuilder serviceBuilder) {
        List ports;
        ServiceSpec spec = serviceBuilder.buildSpec();
        if (spec != null && (ports = spec.getPorts()) != null) {
            for (ServicePort port : ports) {
                Integer portNumber = port.getPort();
                if (portNumber == null || !WEB_PORTS.contains(portNumber)) continue;
                return true;
            }
        }
        return false;
    }
}

