/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.helidon;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;
import org.eclipse.jkube.kit.common.util.YamlUtil;

public class HelidonUtils {
    private static final String HELIDON_HTTP_PORT = "server.port";

    private HelidonUtils() {
    }

    public static boolean hasHelidonDependencies(JavaProject javaProject) {
        return JKubeProjectUtil.hasTransitiveDependency((JavaProject)javaProject, (String)"io.helidon.webserver", (String)"helidon-webserver");
    }

    public static boolean hasHelidonGraalNativeImageExtension(JavaProject javaProject) {
        return JKubeProjectUtil.hasDependency((JavaProject)javaProject, (String)"io.helidon.integrations.graal", (String)"helidon-graal-native-image-extension") || JKubeProjectUtil.hasDependency((JavaProject)javaProject, (String)"io.helidon.integrations.graal", (String)"helidon-mp-graal-native-image-extension");
    }

    public static boolean hasHelidonHealthDependency(JavaProject javaProject) {
        return JKubeProjectUtil.hasTransitiveDependency((JavaProject)javaProject, (String)"io.helidon.health", (String)"helidon-health");
    }

    public static Properties getHelidonConfiguration(JavaProject javaProject) {
        URLClassLoader urlClassLoader = JKubeProjectUtil.getClassLoader((JavaProject)javaProject);
        List<Supplier> sources = Arrays.asList(() -> PropertiesUtil.getPropertiesFromResource((URL)urlClassLoader.findResource("META-INF/microprofile-config.properties")), () -> YamlUtil.getPropertiesFromYamlResource((URL)urlClassLoader.findResource("application.yaml")), () -> YamlUtil.getPropertiesFromYamlResource((URL)urlClassLoader.findResource("application.yml")));
        for (Supplier source : sources) {
            Properties props = (Properties)source.get();
            if (props.isEmpty()) continue;
            props.putAll((Map<?, ?>)PropertiesUtil.toMap((Properties)javaProject.getProperties()));
            return props;
        }
        return javaProject.getProperties();
    }

    public static String extractPort(Properties properties, String defaultValue) {
        return properties.getProperty(HELIDON_HTTP_PORT, defaultValue);
    }
}

