/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.micronaut.generator;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jkube.generator.api.GeneratorConfig;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.SpringBootUtil;
import org.eclipse.jkube.micronaut.MicronautUtils;
import org.eclipse.jkube.micronaut.generator.FatJarGenerator;
import org.eclipse.jkube.micronaut.generator.NativeGenerator;

public interface MicronautNestedGenerator {
    public JavaProject getProject();

    default public AssemblyConfiguration createAssemblyConfiguration(List<AssemblyFileSet> defaultFileSets) {
        return null;
    }

    default public String getFrom() {
        return null;
    }

    default public String getDefaultJolokiaPort() {
        return "8778";
    }

    default public String getDefaultPrometheusPort() {
        return "9779";
    }

    default public Arguments getBuildEntryPoint() {
        return null;
    }

    public String getBuildWorkdir();

    public String getTargetDir();

    public Map<String, String> getEnv(Function<Boolean, Map<String, String>> var1, boolean var2);

    public static MicronautNestedGenerator from(GeneratorContext generatorContext, GeneratorConfig generatorConfig) {
        File nativeBinary;
        if (MicronautUtils.hasNativeImagePackaging(generatorContext.getProject()) && (nativeBinary = SpringBootUtil.findNativeArtifactFile((JavaProject)generatorContext.getProject())) != null) {
            return new NativeGenerator(generatorContext, generatorConfig, nativeBinary);
        }
        return new FatJarGenerator(generatorContext, generatorConfig);
    }
}

