/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;
import org.eclipse.jkube.kit.common.util.YamlUtil;

public class QuarkusUtils {
    public static final String QUARKUS_GROUP_ID = "io.quarkus";
    private static final String QUARKUS_HTTP_PORT = "quarkus.http.port";
    private static final String QUARKUS_PACKAGE_RUNNER_SUFFIX = "quarkus.package.runner-suffix";
    private static final String QUARKUS_HTTP_ROOT_PATH = "quarkus.http.root-path";
    private static final String QUARKUS_HTTP_NON_APPLICATION_ROOT_PATH = "quarkus.http.non-application-root-path";
    private static final String QUARKUS_SMALLRYE_HEALTH_ROOT_PATH = "quarkus.smallrye-health.root-path";
    private static final String QUARKUS_SMALLRYE_HEALTH_READINESS_PATH = "quarkus.smallrye-health.readiness-path";
    private static final String QUARKUS_SMALLRYE_HEALTH_LIVENESS_PATH = "quarkus.smallrye-health.liveness-path";
    private static final int QUARKUS_MAJOR_VERSION_SINCE_PATH_RESOLUTION_CHANGE = 1;
    private static final int QUARKUS_MINOR_VERSION_SINCE_PATH_RESOLUTION_CHANGE = 11;
    private static final int QUARKUS2_MAJOR_VERSION = 2;
    private static final int QUARKUS2_MINOR_VERSION = 0;
    private static final String DEFAULT_ROOT_PATH = "/";
    private static final String DEFAULT_NON_APPLICATION_ROOT_BEFORE_2_0 = "";
    private static final String DEFAULT_NON_APPLICATION_ROOT_AFTER_2_0 = "q";
    private static final String DEFAULT_HEALTH_ROOT_PATH = "health";
    private static final String DEFAULT_READINESS_SUBPATH = "ready";
    private static final String DEFAULT_LIVENESS_SUBPATH = "live";

    private QuarkusUtils() {
    }

    public static String extractPort(JavaProject javaProject, Properties properties, String defaultValue) {
        String profilePort;
        Optional<String> activeProfile = QuarkusUtils.getActiveProfile(javaProject);
        if (activeProfile.isPresent() && StringUtils.isNotBlank((CharSequence)(profilePort = properties.getProperty(String.format("%%%s.%s", activeProfile.get(), QUARKUS_HTTP_PORT))))) {
            return profilePort;
        }
        return properties.getProperty(QUARKUS_HTTP_PORT, defaultValue);
    }

    public static String runnerSuffix(Properties properties) {
        return properties.getProperty(QUARKUS_PACKAGE_RUNNER_SUFFIX, "-runner");
    }

    public static String findSingleFileThatEndsWith(JavaProject project, String suffix) {
        File buildDir = project.getBuildDirectory();
        String[] file = buildDir.list((dir, name) -> name.endsWith(suffix));
        if (file == null || file.length != 1) {
            throw new IllegalStateException("Can't find single file with suffix '" + suffix + "' in " + buildDir + " (zero or more than one files found ending with '" + suffix + "')");
        }
        return file[0];
    }

    public static Properties getQuarkusConfiguration(JavaProject project) {
        Supplier[] sources;
        URLClassLoader urlClassLoader = JKubeProjectUtil.getClassLoader((JavaProject)project);
        for (Supplier source : sources = new Supplier[]{() -> PropertiesUtil.getPropertiesFromResource((URL)urlClassLoader.findResource("application.properties")), () -> YamlUtil.getPropertiesFromYamlResource((URL)urlClassLoader.findResource("application.yaml")), () -> YamlUtil.getPropertiesFromYamlResource((URL)urlClassLoader.findResource("application.yml"))}) {
            Properties props = (Properties)source.get();
            if (props.isEmpty()) continue;
            props.putAll((Map<?, ?>)PropertiesUtil.toMap((Properties)project.getProperties()));
            return props;
        }
        return project.getProperties();
    }

    private static Optional<String> getActiveProfile(JavaProject project) {
        return Optional.ofNullable(project).map(JavaProject::getProperties).map(properties -> properties.get("quarkus.profile")).map(Object::toString);
    }

    public static String resolveQuarkusReadinessPath(JavaProject javaProject) {
        return QuarkusUtils.getQuarkusConfiguration(javaProject).getProperty(QUARKUS_SMALLRYE_HEALTH_READINESS_PATH, DEFAULT_READINESS_SUBPATH);
    }

    public static String resolveQuarkusLivenessPath(JavaProject javaProject) {
        return QuarkusUtils.getQuarkusConfiguration(javaProject).getProperty(QUARKUS_SMALLRYE_HEALTH_LIVENESS_PATH, DEFAULT_LIVENESS_SUBPATH);
    }

    static boolean shouldUseAbsoluteHealthPaths(String quarkusVersion, String healthPath) {
        return QuarkusUtils.isVersionAtLeast(1, 11, quarkusVersion) && QuarkusUtils.isAbsolutePath(healthPath);
    }

    public static String resolveCompleteQuarkusHealthRootPath(JavaProject javaProject, String subPath) {
        String quarkusVersion = QuarkusUtils.findQuarkusVersion(javaProject);
        Properties quarkusProperties = QuarkusUtils.getQuarkusConfiguration(javaProject);
        String healthRootPath = quarkusProperties.getProperty(QUARKUS_SMALLRYE_HEALTH_ROOT_PATH, DEFAULT_HEALTH_ROOT_PATH);
        String nonApplicationRootPath = QuarkusUtils.resolveQuarkusNonApplicationRootPath(quarkusVersion, quarkusProperties);
        String rootPath = quarkusProperties.getProperty(QUARKUS_HTTP_ROOT_PATH, DEFAULT_ROOT_PATH);
        String ret = DEFAULT_NON_APPLICATION_ROOT_BEFORE_2_0;
        for (String component : new String[]{subPath, healthRootPath, nonApplicationRootPath, rootPath}) {
            ret = QuarkusUtils.concatPath(component, ret);
            if (!QuarkusUtils.shouldUseAbsoluteHealthPaths(quarkusVersion, component)) continue;
            return ret;
        }
        return ret;
    }

    private static String resolveQuarkusNonApplicationRootPath(String quarkusVersion, Properties quarkusProperties) {
        String defaultValue = QuarkusUtils.isVersionAtLeast(2, 0, quarkusVersion) ? DEFAULT_NON_APPLICATION_ROOT_AFTER_2_0 : DEFAULT_NON_APPLICATION_ROOT_BEFORE_2_0;
        return quarkusProperties.getProperty(QUARKUS_HTTP_NON_APPLICATION_ROOT_PATH, defaultValue);
    }

    public static String concatPath(String ... paths) {
        return DEFAULT_ROOT_PATH + Stream.of(paths).filter(StringUtils::isNotBlank).filter(path -> !DEFAULT_ROOT_PATH.equals(path)).map(path -> FileUtil.stripPrefix((String)path, (String)DEFAULT_ROOT_PATH)).collect(Collectors.joining(DEFAULT_ROOT_PATH));
    }

    static String findQuarkusVersion(JavaProject javaProject) {
        return Optional.ofNullable(JKubeProjectUtil.getAnyDependencyVersionWithGroupId((JavaProject)javaProject, (String)QUARKUS_GROUP_ID)).orElse(null);
    }

    static boolean isVersionAtLeast(int majorVersion, int minorVersion, String version) {
        if (StringUtils.isNotBlank((CharSequence)version) && version.contains(".")) {
            String[] versionParts = version.split("\\.");
            int parsedMajorVersion = QuarkusUtils.parseInt(versionParts[0]);
            if (parsedMajorVersion > majorVersion) {
                return true;
            }
            if (parsedMajorVersion == majorVersion) {
                return QuarkusUtils.parseInt(versionParts[1]) >= minorVersion;
            }
        }
        return false;
    }

    private static int parseInt(String toParse) {
        try {
            return Integer.parseInt(toParse);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private static boolean isAbsolutePath(String path) {
        return path != null && path.startsWith(DEFAULT_ROOT_PATH);
    }
}

