/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot.watcher;

import com.google.common.io.Closeables;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.PrefixedLogger;
import org.eclipse.jkube.kit.common.util.ClassUtil;
import org.eclipse.jkube.kit.common.util.IoUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.SpringBootConfigurationHelper;
import org.eclipse.jkube.kit.common.util.SpringBootUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.JKubeAnnotations;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.service.JKubeServiceException;
import org.eclipse.jkube.kit.config.service.PodLogService;
import org.eclipse.jkube.kit.config.service.PortForwardService;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.watcher.api.BaseWatcher;
import org.eclipse.jkube.watcher.api.WatcherContext;

public class SpringBootWatcher
extends BaseWatcher {
    private final PortForwardService portForwardService;

    public SpringBootWatcher(WatcherContext watcherContext) {
        super(watcherContext, "spring-boot");
        this.portForwardService = new PortForwardService(watcherContext.getJKubeServiceHub().getClient(), watcherContext.getLogger());
    }

    public boolean isApplicable(List<ImageConfiguration> configs, Set<HasMetadata> resources, PlatformMode mode) {
        return JKubeProjectUtil.hasPluginOfAnyArtifactId((JavaProject)this.getContext().getBuildContext().getProject(), (String)"spring-boot-maven-plugin");
    }

    public void watch(List<ImageConfiguration> configs, Set<HasMetadata> resources, PlatformMode mode) throws Exception {
        KubernetesClient kubernetes = this.getContext().getJKubeServiceHub().getClient();
        PodLogService.PodLogServiceContext logContext = PodLogService.PodLogServiceContext.builder().log((KitLogger)this.log).newPodLog(this.getContext().getNewPodLogger()).oldPodLog(this.getContext().getOldPodLogger()).build();
        new PodLogService(logContext).tailAppPodsLogs(kubernetes, this.getContext().getJKubeServiceHub().getClusterAccess().getNamespace(), resources, false, null, true, null, false);
        String url = this.getServiceExposeUrl(kubernetes, resources);
        if (url == null) {
            url = this.getPortForwardUrl(resources);
        }
        if (url == null) {
            throw new IllegalStateException("Unable to open a channel to the remote pod.");
        }
        this.runRemoteSpringApplication(url);
    }

    private String getPortForwardUrl(Set<HasMetadata> resources) throws JKubeServiceException {
        LabelSelector selector = KubernetesResourceUtil.getPodLabelSelector(resources);
        if (selector == null) {
            this.log.warn("Unable to determine a selector for application pods", new Object[0]);
            return null;
        }
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((URLClassLoader)JKubeProjectUtil.getClassLoader((JavaProject)this.getContext().getBuildContext().getProject()));
        SpringBootConfigurationHelper propertyHelper = new SpringBootConfigurationHelper(SpringBootUtil.getSpringBootVersion((JavaProject)this.getContext().getBuildContext().getProject()));
        int port = IoUtil.getFreeRandomPort();
        int containerPort = propertyHelper.getServerPort(properties);
        this.portForwardService.forwardPortAsync(this.getContext().getLogger(), selector, containerPort, port);
        return this.createForwardUrl(propertyHelper, properties, port);
    }

    private String createForwardUrl(SpringBootConfigurationHelper propertyHelper, Properties properties, int localPort) {
        String scheme = StringUtils.isNotBlank((CharSequence)properties.getProperty(propertyHelper.getServerKeystorePropertyKey())) ? "https://" : "http://";
        String contextPath = properties.getProperty(propertyHelper.getServerContextPathPropertyKey(), "");
        return scheme + "localhost:" + localPort + contextPath;
    }

    private String getServiceExposeUrl(KubernetesClient kubernetes, Set<HasMetadata> resources) throws InterruptedException {
        long serviceUrlWaitTimeSeconds = Configs.asInt((String)this.getConfig(Config.SERVICE_URL_WAIT_TIME_SECONDS));
        for (HasMetadata entity : resources) {
            if (!(entity instanceof Service)) continue;
            Service service = (Service)entity;
            String name = KubernetesHelper.getName((HasMetadata)service);
            Resource serviceResource = (Resource)((NonNamespaceOperation)kubernetes.services().inNamespace(this.getContext().getJKubeServiceHub().getClusterAccess().getNamespace())).withName(name);
            String url = null;
            int i = 0;
            while ((long)i < serviceUrlWaitTimeSeconds) {
                Service s;
                if (i > 0) {
                    Thread.sleep(1000L);
                }
                if ((s = (Service)serviceResource.get()) != null && StringUtils.isNotBlank((CharSequence)(url = (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)s).get(JKubeAnnotations.SERVICE_EXPOSE_URL.value()))) || !this.isExposeService(service)) break;
                ++i;
            }
            serviceUrlWaitTimeSeconds = 1L;
            if (!StringUtils.isNotBlank(url) || !url.startsWith("http")) continue;
            return url;
        }
        this.log.info("No exposed service found for connecting the dev tools", new Object[0]);
        return null;
    }

    private boolean isExposeService(Service service) {
        String expose = (String)KubernetesHelper.getLabels((HasMetadata)service).get("expose");
        return expose != null && expose.equalsIgnoreCase("true");
    }

    private void runRemoteSpringApplication(String url) {
        this.log.info("Running RemoteSpringApplication against endpoint: " + url, new Object[0]);
        String remoteSecret = this.validateSpringBootDevtoolsSettings();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader pluginClassLoader = (URLClassLoader)classLoader;
            try (URLClassLoader projectClassLoader = ClassUtil.createProjectClassLoader((List)this.getContext().getBuildContext().getProject().getCompileClassPathElements(), (KitLogger)this.log);){
                URLClassLoader[] classLoaders = new URLClassLoader[]{projectClassLoader, pluginClassLoader};
                StringBuilder buffer = new StringBuilder("java -cp ");
                int count = 0;
                for (URLClassLoader urlClassLoader : classLoaders) {
                    URL[] urLs;
                    for (URL u : urLs = urlClassLoader.getURLs()) {
                        if (count++ > 0) {
                            buffer.append(File.pathSeparator);
                        }
                        try {
                            URI uri = u.toURI();
                            File file = new File(uri);
                            buffer.append(file.getCanonicalPath());
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Failed to create classpath: " + e, e);
                        }
                    }
                }
                try {
                    File devtools = this.getSpringBootDevToolsJar(this.getContext().getBuildContext().getProject());
                    buffer.append(File.pathSeparator);
                    buffer.append(devtools.getCanonicalPath());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to include devtools in the classpath: " + e, e);
                }
                buffer.append(" -Dspring.devtools.remote.secret=");
                buffer.append(remoteSecret);
                buffer.append(" org.springframework.boot.devtools.RemoteSpringApplication ");
                buffer.append(url);
                try {
                    String command = buffer.toString();
                    this.log.debug("Running: " + command, new Object[0]);
                    final Process process = Runtime.getRuntime().exec(command);
                    final AtomicBoolean outputEnabled = new AtomicBoolean(true);
                    Runtime.getRuntime().addShutdownHook(new Thread("jkube:watch [spring-boot] shutdown hook"){

                        @Override
                        public void run() {
                            SpringBootWatcher.this.log.info("Terminating the Spring remote client...", new Object[0]);
                            outputEnabled.set(false);
                            process.destroy();
                        }
                    });
                    PrefixedLogger logger = new PrefixedLogger("Spring-Remote", (KitLogger)this.log);
                    Thread stdOutPrinter = this.startOutputProcessor((KitLogger)logger, process.getInputStream(), false, outputEnabled);
                    Thread stdErrPrinter = this.startOutputProcessor((KitLogger)logger, process.getErrorStream(), true, outputEnabled);
                    int status = process.waitFor();
                    stdOutPrinter.join();
                    stdErrPrinter.join();
                    if (status != 0) {
                        this.log.warn("Process returned status: %s", new Object[]{status});
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to run RemoteSpringApplication: " + e, e);
                }
            }
            catch (IOException e) {
                this.log.warn("Instructed to use project classpath, but cannot. Continuing build if we can: ", new Object[]{e});
            }
        } else {
            throw new IllegalStateException("ClassLoader must be a URLClassLoader but it is: " + classLoader.getClass().getName());
        }
    }

    protected Thread startOutputProcessor(final KitLogger logger, final InputStream inputStream, final boolean error, final AtomicBoolean outputEnabled) throws IOException {
        Thread printer = new Thread(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!outputEnabled.get()) continue;
                        if (error) {
                            logger.error("%s", new Object[]{line});
                            continue;
                        }
                        logger.info("%s", new Object[]{line});
                    }
                }
                catch (Exception e) {
                    if (outputEnabled.get()) {
                        logger.error("Failed to process " + (error ? "stderr" : "stdout") + " from spring-remote process: " + e, new Object[0]);
                    }
                }
                finally {
                    Closeables.closeQuietly((Reader)reader);
                }
            }
        };
        printer.start();
        return printer;
    }

    private File getSpringBootDevToolsJar(JavaProject project) {
        String version = (String)SpringBootUtil.getSpringBootDevToolsVersion((JavaProject)project).orElseThrow(() -> new IllegalStateException("Unable to find the spring-boot version"));
        return this.getContext().getJKubeServiceHub().getArtifactResolverService().resolveArtifact("org.springframework.boot", "spring-boot-devtools", version, "jar");
    }

    private String validateSpringBootDevtoolsSettings() {
        Map configuration = JKubeProjectUtil.getPlugin((JavaProject)this.getContext().getBuildContext().getProject(), (String)"spring-boot-maven-plugin").getConfiguration();
        if (!configuration.containsKey("excludeDevtools") || !configuration.get("excludeDevtools").equals("false")) {
            this.log.warn("devtools need to be included in repacked archive, please set <excludeDevtools> to false in plugin configuration", new Object[0]);
            throw new IllegalStateException("devtools needs to be included in fat jar");
        }
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((URLClassLoader)JKubeProjectUtil.getClassLoader((JavaProject)this.getContext().getBuildContext().getProject()));
        String remoteSecret = properties.getProperty("spring.devtools.remote.secret", System.getProperty("spring.devtools.remote.secret"));
        if (StringUtils.isBlank((CharSequence)remoteSecret)) {
            this.log.warn("There is no `%s` property defined in your src/main/resources/application.properties. Please add one!", new Object[]{"spring.devtools.remote.secret"});
            throw new IllegalStateException("No spring.devtools.remote.secret property defined in application.properties or system properties");
        }
        return properties.getProperty("spring.devtools.remote.secret");
    }

    private static enum Config implements Configs.Config
    {
        SERVICE_URL_WAIT_TIME_SECONDS("serviceUrlWaitTimeSeconds", "5");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

