/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot.generator;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jkube.generator.api.GeneratorConfig;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.javaexec.FatJarDetector;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.SpringBootUtil;
import org.eclipse.jkube.springboot.SpringBootLayeredJar;
import org.eclipse.jkube.springboot.generator.FatJarGenerator;
import org.eclipse.jkube.springboot.generator.LayeredJarGenerator;
import org.eclipse.jkube.springboot.generator.NativeGenerator;

public interface SpringBootNestedGenerator {
    public JavaProject getProject();

    default public AssemblyConfiguration createAssemblyConfiguration(List<AssemblyFileSet> defaultFileSets) {
        return null;
    }

    default public String getFrom() {
        return null;
    }

    default public String getDefaultJolokiaPort() {
        return "8778";
    }

    default public String getDefaultPrometheusPort() {
        return "9779";
    }

    default public Arguments getBuildEntryPoint() {
        return null;
    }

    public String getBuildWorkdir();

    public String getTargetDir();

    public Map<String, String> getEnv(Function<Boolean, Map<String, String>> var1, boolean var2);

    public static SpringBootNestedGenerator from(GeneratorContext generatorContext, GeneratorConfig generatorConfig, FatJarDetector.Result fatJarDetectorResult) {
        File nativeBinary;
        if (SpringBootUtil.getNativePlugin((JavaProject)generatorContext.getProject()) != null && (nativeBinary = SpringBootUtil.findNativeArtifactFile((JavaProject)generatorContext.getProject())) != null) {
            return new NativeGenerator(generatorContext, generatorConfig, nativeBinary);
        }
        if (fatJarDetectorResult != null && fatJarDetectorResult.getArchiveFile() != null && new SpringBootLayeredJar(fatJarDetectorResult.getArchiveFile(), generatorContext.getLogger()).isLayeredJar()) {
            return new LayeredJarGenerator(generatorContext, generatorConfig, fatJarDetectorResult.getArchiveFile());
        }
        return new FatJarGenerator(generatorContext, generatorConfig);
    }
}

