/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot.watcher;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.JKubeException;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.ClassUtil;
import org.eclipse.jkube.kit.common.util.IoUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.SpringBootConfiguration;
import org.eclipse.jkube.kit.common.util.SpringBootUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.service.PodLogService;
import org.eclipse.jkube.kit.config.service.PortForwardService;
import org.eclipse.jkube.springboot.RemoteSpringBootDevtoolsCommand;
import org.eclipse.jkube.springboot.SpringBootDevtoolsUtils;
import org.eclipse.jkube.watcher.api.BaseWatcher;
import org.eclipse.jkube.watcher.api.WatcherContext;

public class SpringBootWatcher
extends BaseWatcher {
    private final PortForwardService portForwardService;

    public SpringBootWatcher(WatcherContext watcherContext) {
        super(watcherContext, "spring-boot");
        this.portForwardService = new PortForwardService(watcherContext.getLogger());
    }

    public boolean isApplicable(List<ImageConfiguration> configs, Collection<HasMetadata> resources, PlatformMode mode) {
        return JKubeProjectUtil.hasPluginOfAnyArtifactId((JavaProject)this.getContext().getBuildContext().getProject(), (String)"spring-boot-maven-plugin") || JKubeProjectUtil.hasPluginOfAnyArtifactId((JavaProject)this.getContext().getBuildContext().getProject(), (String)"org.springframework.boot.gradle.plugin");
    }

    public void watch(List<ImageConfiguration> configs, String namespace, Collection<HasMetadata> resources, PlatformMode mode) {
        NamespacedKubernetesClient kubernetes = namespace != null ? ((NamespacedKubernetesClient)this.getContext().getJKubeServiceHub().getClient().adapt(NamespacedKubernetesClient.class)).inNamespace(namespace) : (NamespacedKubernetesClient)this.getContext().getJKubeServiceHub().getClient().adapt(NamespacedKubernetesClient.class);
        PodLogService.PodLogServiceContext logContext = PodLogService.PodLogServiceContext.builder().log((KitLogger)this.log).newPodLog(this.getContext().getNewPodLogger()).oldPodLog(this.getContext().getOldPodLogger()).build();
        new PodLogService(logContext).tailAppPodsLogs((KubernetesClient)kubernetes, namespace, resources, false, null, true, null, false);
        String url = this.getPortForwardUrl(kubernetes, resources);
        if (url == null) {
            throw new IllegalStateException("Unable to open a channel to the remote pod.");
        }
        this.runRemoteSpringApplication(url);
    }

    String getPortForwardUrl(NamespacedKubernetesClient kubernetes, Collection<HasMetadata> resources) {
        LabelSelector selector = KubernetesHelper.extractPodLabelSelector(resources);
        if (selector == null) {
            this.log.warn("Unable to determine a selector for application pods", new Object[0]);
            return null;
        }
        SpringBootConfiguration springBootConfiguration = SpringBootConfiguration.from((JavaProject)this.getContext().getBuildContext().getProject());
        int localPort = IoUtil.getFreeRandomPort();
        int containerPort = springBootConfiguration.getServerPort();
        this.portForwardService.forwardPortAsync(kubernetes, selector, containerPort, localPort);
        String scheme = StringUtils.isNotBlank((CharSequence)springBootConfiguration.getServerKeystore()) ? "https://" : "http://";
        String contextPath = StringUtils.isNotBlank((CharSequence)springBootConfiguration.getServerContextPath()) ? springBootConfiguration.getServerContextPath() : "";
        return scheme + "localhost:" + localPort + contextPath;
    }

    private void runRemoteSpringApplication(String url) {
        this.log.info("Running RemoteSpringApplication against endpoint: " + url, new Object[0]);
        String remoteSecret = this.validateSpringBootDevtoolsSettings();
        ArrayList<URLClassLoader> classLoaders = new ArrayList<URLClassLoader>();
        ClassLoader pluginClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (pluginClassLoader instanceof URLClassLoader) {
            classLoaders.add((URLClassLoader)pluginClassLoader);
        }
        try (URLClassLoader projectClassLoader = ClassUtil.createProjectClassLoader((List)this.getContext().getBuildContext().getProject().getCompileClassPathElements(), (KitLogger)this.log);){
            classLoaders.add(projectClassLoader);
            String devToolsPath = SpringBootDevtoolsUtils.getSpringBootDevToolsJar(this.getContext().getBuildContext().getProject()).getCanonicalPath();
            String classPath = classLoaders.stream().flatMap(cl -> Stream.of(cl.getURLs())).map(u -> {
                try {
                    URI uri = u.toURI();
                    File file = new File(uri);
                    return file.getCanonicalPath();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to create classpath: " + e, e);
                }
            }).collect(Collectors.joining(File.pathSeparator, "", File.pathSeparator)).concat(devToolsPath);
            RemoteSpringBootDevtoolsCommand command = new RemoteSpringBootDevtoolsCommand(classPath, remoteSecret, url, (KitLogger)this.log);
            try {
                command.execute();
            }
            catch (Exception e) {
                throw new JKubeException("Failed to run RemoteSpringApplication: " + e, (Throwable)e);
            }
        }
        catch (IOException e) {
            this.log.warn("Instructed to use project classpath, but cannot. Continuing build if we can: ", new Object[]{e});
        }
    }

    private String validateSpringBootDevtoolsSettings() {
        Map configuration = SpringBootUtil.getSpringBootPluginConfiguration((JavaProject)this.getContext().getBuildContext().getProject());
        if (!(configuration == null || configuration.containsKey("excludeDevtools") && configuration.get("excludeDevtools").equals("false"))) {
            this.log.warn("devtools need to be included in repacked archive, please set <excludeDevtools> to false in plugin configuration", new Object[0]);
            throw new IllegalStateException("devtools needs to be included in fat jar");
        }
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((URLClassLoader)JKubeProjectUtil.getClassLoader((JavaProject)this.getContext().getBuildContext().getProject()));
        String remoteSecret = properties.getProperty("spring.devtools.remote.secret", System.getProperty("spring.devtools.remote.secret"));
        if (StringUtils.isBlank((CharSequence)remoteSecret)) {
            this.log.warn("There is no `%s` property defined in your src/main/resources/application.properties. Please add one!", new Object[]{"spring.devtools.remote.secret"});
            throw new IllegalStateException("No spring.devtools.remote.secret property defined in application.properties or system properties");
        }
        return properties.getProperty("spring.devtools.remote.secret");
    }
}

