/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.develop;

import java.util.concurrent.ExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jkube.kit.common.util.AnsiLogger;
import org.eclipse.jkube.kit.remotedev.RemoteDevelopmentConfig;
import org.eclipse.jkube.kit.remotedev.RemoteDevelopmentService;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractJKubeMojo;
import org.fusesource.jansi.AnsiConsole;

@Mojo(name="remote-dev", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.VALIDATE)
public class RemoteDevMojo
extends AbstractJKubeMojo {
    @Parameter
    protected RemoteDevelopmentConfig remoteDevelopment;

    @Override
    public void executeInternal() {
        RemoteDevelopmentService remoteDevelopmentService = new RemoteDevelopmentService(this.jkubeServiceHub.getLog(), this.jkubeServiceHub.getClient(), this.remoteDevelopment);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.jkubeServiceHub.getLog() instanceof AnsiLogger) {
                AnsiConsole.systemUninstall();
            }
            remoteDevelopmentService.stop();
        }));
        try {
            remoteDevelopmentService.start().get();
        }
        catch (ExecutionException e) {
            remoteDevelopmentService.stop();
        }
        catch (InterruptedException e) {
            remoteDevelopmentService.stop();
            Thread.currentThread().interrupt();
        }
    }
}

