/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.watcher;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Collection;
import java.util.List;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.ClassUtil;
import org.eclipse.jkube.kit.common.util.PluginServiceFactory;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.watcher.api.Watcher;
import org.eclipse.jkube.watcher.api.WatcherContext;

public class WatcherManager {
    private WatcherManager() {
    }

    public static void watch(List<ImageConfiguration> ret, Collection<HasMetadata> resources, WatcherContext watcherCtx) throws Exception {
        PluginServiceFactory pluginFactory = watcherCtx.isUseProjectClasspath() ? new PluginServiceFactory((Object)watcherCtx, new ClassLoader[]{ClassUtil.createProjectClassLoader((List)watcherCtx.getBuildContext().getProject().getCompileClassPathElements(), (KitLogger)watcherCtx.getLogger())}) : new PluginServiceFactory((Object)watcherCtx, new ClassLoader[0]);
        boolean isOpenshift = watcherCtx.getJKubeServiceHub().getClusterAccess().isOpenShift();
        PlatformMode mode = isOpenshift ? PlatformMode.openshift : PlatformMode.kubernetes;
        List watchers = pluginFactory.createServiceObjects(new String[]{"META-INF/jkube/watcher-default", "META-INF/jkube/jkube-watcher-default", "META-INF/jkube/watcher", "META-INF/jkube-watcher"});
        ProcessorConfig config = watcherCtx.getConfig();
        KitLogger log = watcherCtx.getLogger();
        List usableWatchers = config.prepareProcessors(watchers, "watcher");
        log.verbose("Watchers:", new Object[0]);
        Watcher chosen = null;
        for (Watcher watcher : usableWatchers) {
            if (watcher.isApplicable(ret, resources, mode)) {
                if (chosen == null) {
                    log.verbose(" - %s [selected]", new Object[]{watcher.getName()});
                    chosen = watcher;
                    continue;
                }
                log.verbose(" - %s", new Object[]{watcher.getName()});
                continue;
            }
            log.verbose(" - %s [not applicable]", new Object[]{watcher.getName()});
        }
        if (chosen == null) {
            throw new IllegalStateException("No watchers can be used for the current project");
        }
        log.info("Running watcher %s", new Object[]{chosen.getName()});
        chosen.watch(ret, resources, mode);
    }
}

