/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.archive.operations;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.archive.ComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class WebComponentArchiveLoadAdapter
extends ComponentArchiveLoadAdapter {
    public WebComponentArchiveLoadAdapter(IVirtualComponent vComponent) {
        super(vComponent);
    }

    public WebComponentArchiveLoadAdapter(IVirtualComponent vComponent, boolean includeClasspathComponents) {
        super(vComponent, includeClasspathComponents);
    }

    public List getFiles() {
        this.addLooseLibJARsToFiles();
        return this.filesHolder.getFiles();
    }

    public IVirtualReference[] getLibModules() {
        WebArtifactEdit webArtifactEdit = null;
        try {
            webArtifactEdit = (WebArtifactEdit)ComponentUtilities.getArtifactEditForRead((IVirtualComponent)this.getComponent());
            if (webArtifactEdit != null) {
                IVirtualReference[] iVirtualReferenceArray = webArtifactEdit.getLibModules();
                return iVirtualReferenceArray;
            }
        }
        finally {
            if (webArtifactEdit != null) {
                webArtifactEdit.dispose();
            }
        }
        return null;
    }

    public void addLooseLibJARsToFiles() {
        IVirtualReference[] libModules = this.getLibModules();
        int i = 0;
        while (i < libModules.length) {
            IVirtualReference iLibModule = libModules[i];
            IVirtualComponent looseComponent = iLibModule.getReferencedComponent();
            if (looseComponent.isBinary()) {
                VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)looseComponent;
                File diskFile = archiveComp.getUnderlyingDiskFile();
                if (!diskFile.exists()) {
                    IFile wbFile = archiveComp.getUnderlyingWorkbenchFile();
                    diskFile = new File(wbFile.getLocation().toOSString());
                }
                String cfr_ignored_0 = String.valueOf(iLibModule.getRuntimePath().makeRelative().toString()) + "/" + diskFile.getName();
            } else {
                String name = null;
                String archiveName = iLibModule.getArchiveName();
                name = archiveName != null && archiveName.length() > 0 ? archiveName : String.valueOf(looseComponent.getName()) + ".jar";
                String prefix = iLibModule.getRuntimePath().makeRelative().toString();
                if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) != '/') {
                    prefix = String.valueOf(prefix) + "/";
                }
                this.addClasspathComponentDependencies(looseComponent);
                String uri = String.valueOf(prefix) + name;
                try {
                    Archive utilJAR = J2EEProjectUtilities.asArchive((String)uri, (IProject)looseComponent.getProject(), (boolean)this.isExportSource());
                    if (utilJAR == null) {
                        // empty if block
                    }
                }
                catch (OpenFailureException oe) {
                    String message = ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.UNABLE_TO_LOAD_MODULE_ERROR_, (Object[])new Object[]{uri, this.getComponent().getProject().getName(), oe.getConcatenatedMessages()});
                    Logger.getLogger().logTrace(message);
                }
            }
            ++i;
        }
    }

    private void addClasspathComponentDependencies(IVirtualComponent referencedComponent) {
        if (this.includeClasspathComponents && referencedComponent instanceof J2EEModuleVirtualComponent) {
            IVirtualReference[] cpRefs = ((J2EEModuleVirtualComponent)referencedComponent).getJavaClasspathReferences();
            int j = 0;
            while (j < cpRefs.length) {
                VirtualArchiveComponent comp;
                File cpEntryFile;
                IVirtualReference ref = cpRefs[j];
                IPath runtimePath = ref.getRuntimePath();
                if (ref.getReferencedComponent() instanceof VirtualArchiveComponent && runtimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH) && !(cpEntryFile = (comp = (VirtualArchiveComponent)ref.getReferencedComponent()).getUnderlyingDiskFile()).exists()) {
                    IFile wbFile = comp.getUnderlyingWorkbenchFile();
                    cpEntryFile = new File(wbFile.getLocation().toOSString());
                }
                ++j;
            }
        }
    }
}

