/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;

public class RuntimeClasspathContainer
implements IClasspathContainer {
    public static final String SERVER_CONTAINER = "org.eclipse.jst.server.core.container";
    private IPath path;
    private RuntimeClasspathProviderWrapper delegate;
    private IRuntime runtime;
    private String runtimeId;
    private IProject project;

    public RuntimeClasspathContainer(IPath path, RuntimeClasspathProviderWrapper delegate, IRuntime runtime) {
        this.path = path;
        this.delegate = delegate;
        this.runtime = runtime;
    }

    public RuntimeClasspathContainer(IProject project, IPath path, RuntimeClasspathProviderWrapper delegate, IRuntime runtime, String runtimeId) {
        this.project = project;
        this.path = path;
        this.delegate = delegate;
        this.runtime = runtime;
        this.runtimeId = runtimeId;
    }

    public IClasspathEntry[] getClasspathEntries() {
        IClasspathEntry[] entries = null;
        if (this.delegate != null && this.runtime != null) {
            entries = this.delegate.resolveClasspathContainerImpl(this.project, this.runtime);
        }
        if (entries == null) {
            return new IClasspathEntry[0];
        }
        return entries;
    }

    public String getDescription() {
        IRuntimeType runtimeType;
        if (this.runtime != null && (runtimeType = this.runtime.getRuntimeType()) != null) {
            return NLS.bind((String)Messages.classpathContainer, (Object)runtimeType.getName(), (Object)this.runtime.getName());
        }
        return NLS.bind((String)Messages.classpathContainerUnbound, (Object)Messages.classpathContainerDescription, (Object)this.runtimeId);
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RuntimeClasspathContainer)) {
            return false;
        }
        RuntimeClasspathContainer rcc = (RuntimeClasspathContainer)obj;
        if (this.delegate != null && !this.delegate.equals(rcc.delegate)) {
            return false;
        }
        if (this.runtime == null && rcc.runtime != null) {
            return false;
        }
        if (this.runtime != null && !this.runtime.equals(rcc.runtime)) {
            return false;
        }
        if (this.runtimeId != null && !this.runtimeId.equals(rcc.runtimeId)) {
            return false;
        }
        if (this.project == null && rcc.project != null) {
            return false;
        }
        if (this.project != null && !this.project.equals((Object)rcc.project)) {
            return false;
        }
        return this.path == null || this.path.equals((Object)rcc.path);
    }
}

