/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.core.ServerProfilerDelegate;
import org.eclipse.jst.server.core.internal.Trace;

public class ServerProfiler {
    private IConfigurationElement element;
    private ServerProfilerDelegate delegate;

    public ServerProfiler(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    protected ServerProfilerDelegate getDelegate() {
        if (this.delegate == null) {
            if (this.element.getAttribute("class") == null) {
                return null;
            }
            try {
                this.delegate = (ServerProfilerDelegate)this.element.createExecutableExtension("class");
            }
            catch (Throwable t) {
                Trace.trace((byte)2, "Could not create delegate " + this.toString() + ": " + t.getMessage());
            }
        }
        return this.delegate;
    }

    public String getVMArgs() {
        return null;
    }

    public void process(ILaunch launch, IVMInstall vmInstall, VMRunnerConfiguration vmConfig, IProgressMonitor monitor) {
        try {
            ServerProfilerDelegate del = this.getDelegate();
            if (del != null) {
                del.process(launch, vmInstall, vmConfig, monitor);
            }
        }
        catch (Throwable t) {
            Trace.trace((byte)2, "Could not create delegate " + this.toString() + ": " + t.getMessage());
        }
    }

    public String toString() {
        return "ServerProfiler[" + this.getId() + "]";
    }
}

