/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deploy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.deploy.DeployerRegistryReader;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IRuntime;

public class DeployerRegistry {
    private static DeployerRegistry INSTANCE;
    private HashMap deployModuleExtensions = new HashMap();

    public void register(IConfigurationElement deployer, List serverTargets, List natures) {
        for (String natureID : natures) {
            for (String runtimeID : serverTargets) {
                HashMap targetDeployers = this.getDeployModuleExtensions(natureID);
                this.getTargetDeployers(targetDeployers, runtimeID).add(deployer);
            }
        }
    }

    private List getDeployers(String natureID, String serverTarget) {
        HashMap targetDeployers = this.getDeployModuleExtensions(natureID);
        return this.getTargetDeployers(targetDeployers, serverTarget);
    }

    public static DeployerRegistry instance() {
        if (INSTANCE == null) {
            INSTANCE = new DeployerRegistry();
            DeployerRegistry.readRegistry();
        }
        return INSTANCE;
    }

    private static void readRegistry() {
        DeployerRegistryReader reader = new DeployerRegistryReader();
        reader.readRegistry();
    }

    public static List getSelectedModules(Object[] mySelections) {
        ArrayList<IVirtualComponent> modules = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < mySelections.length) {
            Object object = mySelections[i];
            if (object instanceof EObject) {
                object = ProjectUtilities.getProject((Object)object);
            }
            if (object instanceof IProject) {
                EObject root;
                IVirtualComponent component = ComponentCore.createComponent((IProject)((IProject)object));
                IModelProvider modelProvider = null;
                modelProvider = ModelProviderManager.getModelProvider(component.getProject());
                if (modelProvider != null && (root = (EObject)modelProvider.getModelObject()) != null && !modules.contains(component)) {
                    if (J2EEProjectUtilities.isEARProject(component.getProject())) {
                        modules.add(0, component);
                    } else {
                        modules.add(component);
                    }
                }
            }
            ++i;
        }
        return modules;
    }

    private List getTargetDeployers(HashMap targetDeployers, String serverTarget) {
        if (targetDeployers.get(serverTarget) == null) {
            targetDeployers.put(serverTarget, new ArrayList());
        }
        return (List)targetDeployers.get(serverTarget);
    }

    private HashMap getDeployModuleExtensions(String natureID) {
        if (this.getDeployModuleExtensions().get(natureID) == null) {
            this.getDeployModuleExtensions().put(natureID, new HashMap());
        }
        return (HashMap)this.getDeployModuleExtensions().get(natureID);
    }

    public HashMap getDeployModuleExtensions() {
        return this.deployModuleExtensions;
    }

    public void setDeployModuleExtensions(HashMap deployExtensions) {
        this.deployModuleExtensions = deployExtensions;
    }

    public List getDeployModuleExtensions(EObject module, IRuntime runtime) {
        IVirtualComponent comp = ComponentUtilities.findComponent((EObject)module);
        return this.getDeployModuleExtensions(comp.getProject(), runtime);
    }

    public List getDeployModuleExtensions(IProject project, IRuntime runtime) {
        String typeID = "";
        if (J2EEProjectUtilities.isEARProject(project)) {
            typeID = "jst.ear";
        } else if (J2EEProjectUtilities.isApplicationClientProject(project)) {
            typeID = "jst.appclient";
        } else if (J2EEProjectUtilities.isDynamicWebProject(project)) {
            typeID = "jst.web";
        } else if (J2EEProjectUtilities.isStaticWebProject(project)) {
            typeID = "wst.web";
        } else if (J2EEProjectUtilities.isEJBProject(project)) {
            typeID = "jst.ejb";
        } else if (J2EEProjectUtilities.isJCAProject(project)) {
            typeID = "jst.connector";
        } else if (J2EEProjectUtilities.isUtilityProject(project)) {
            typeID = "jst.utility";
        }
        String runtimeID = runtime.getRuntimeType().getId();
        return this.getDeployers(typeID, runtimeID);
    }
}

