/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.lyo.client.oslc.resources.QmResource;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.model.Link;

@Deprecated
@OslcResourceShape(title="Quality Management Resource Shape", describes={"http://open-services.net/ns/qm#TestExecutionRecord"})
@OslcNamespace(value="http://open-services.net/ns/qm#")
public class TestExecutionRecord
extends QmResource {
    private final Set<Link> blockedByChangeRequests = new HashSet<Link>();
    private final Set<URI> contributors = new TreeSet<URI>();
    private final Set<URI> creators = new TreeSet<URI>();
    private final Set<Link> relatedChangeRequests = new HashSet<Link>();
    private Link reportsOnTestPlan;
    private URI runsOnTestEnvironment;
    private Link runsTestCase;

    @Override
    protected URI getRdfType() {
        return URI.create("http://open-services.net/ns/qm#TestExecutionRecord");
    }

    public void addBlockedByChangeRequest(Link blockingChangeRequest) {
        this.blockedByChangeRequests.add(blockingChangeRequest);
    }

    public void addContributor(URI contributor) {
        this.contributors.add(contributor);
    }

    public void addCreator(URI creator) {
        this.creators.add(creator);
    }

    public void addRelatedChangeRequest(Link relatedChangeRequest) {
        this.relatedChangeRequests.add(relatedChangeRequest);
    }

    @OslcDescription(value="The person(s) who are responsible for the work needed to complete the change request.")
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Contributors")
    public URI[] getContributors() {
        return this.contributors.toArray(new URI[this.contributors.size()]);
    }

    @OslcDescription(value="Creator or creators of resource.")
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Creators")
    public URI[] getCreators() {
        return this.creators.toArray(new URI[this.creators.size()]);
    }

    @OslcDescription(value="Change Request that prevents execution of the Test Execution Record.")
    @OslcName(value="blockedByChangeRequest")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#blockedByChangeRequest")
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Blocked By Change Request")
    public Link[] getBlockedByChangeRequests() {
        return this.blockedByChangeRequests.toArray(new Link[this.blockedByChangeRequests.size()]);
    }

    @OslcDescription(value="This relationship is loosely coupled and has no specific meaning.")
    @OslcName(value="relatedChangeRequest")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#relatedChangeRequest")
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Related Change Requests")
    public Link[] getRelatedChangeRequests() {
        return this.relatedChangeRequests.toArray(new Link[this.relatedChangeRequests.size()]);
    }

    @OslcDescription(value="Test Plan that the Test Execution Record reports on.")
    @OslcName(value="reportsOnTestPlan")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#reportsOnTestPlan")
    @OslcRange(value={"http://open-services.net/ns/qm#TestPlan"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Reports On Test Plan")
    public Link getReportsOnTestPlan() {
        return this.reportsOnTestPlan;
    }

    @OslcDescription(value="Indicates the environment details of the test case for this execution record.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#runsOnTestEnvironment")
    @OslcTitle(value="Runs On Test Environment")
    public URI getRunsOnTestEnvironment() {
        return this.runsOnTestEnvironment;
    }

    @OslcDescription(value="Test Case run by the Test Execution Record.")
    @OslcName(value="runsTestCase")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#runsTestCase")
    @OslcRange(value={"http://open-services.net/ns/qm#TestCase"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Runs Test Case")
    public Link getRunsTestCase() {
        return this.runsTestCase;
    }

    public void setBlockedByChangeRequests(Link[] blockedByChangeRequests) {
        this.blockedByChangeRequests.clear();
        if (blockedByChangeRequests != null) {
            this.blockedByChangeRequests.addAll(Arrays.asList(blockedByChangeRequests));
        }
    }

    public void setContributors(URI[] contributors) {
        this.contributors.clear();
        if (contributors != null) {
            this.contributors.addAll(Arrays.asList(contributors));
        }
    }

    public void setCreators(URI[] creators) {
        this.creators.clear();
        if (creators != null) {
            this.creators.addAll(Arrays.asList(creators));
        }
    }

    public void setRelatedChangeRequests(Link[] relatedChangeRequests) {
        this.relatedChangeRequests.clear();
        if (relatedChangeRequests != null) {
            this.relatedChangeRequests.addAll(Arrays.asList(relatedChangeRequests));
        }
    }

    public void setReportsOnTestPlan(Link reportsOnTestPlan) {
        this.reportsOnTestPlan = reportsOnTestPlan;
    }

    public void setRunsOnTestEnvironment(URI runsOnTestEnvironment) {
        this.runsOnTestEnvironment = runsOnTestEnvironment;
    }

    public void setRunsTestCase(Link runsTestCase) {
        this.runsTestCase = runsTestCase;
    }
}

