/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.lyo.client.oslc.resources.QmResource;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@Deprecated
@OslcResourceShape(title="Quality Management Resource Shape", describes={"http://open-services.net/ns/qm#TestScript"})
@OslcNamespace(value="http://open-services.net/ns/qm#")
public class TestScript
extends QmResource {
    private final Set<URI> contributors = new TreeSet<URI>();
    private final Set<URI> creators = new TreeSet<URI>();
    private final Set<Link> relatedChangeRequests = new HashSet<Link>();
    private final Set<Link> validatesRequirements = new HashSet<Link>();
    private URI executionInstructions;
    private String description;

    @Override
    protected URI getRdfType() {
        return URI.create("http://open-services.net/ns/qm#TestScript");
    }

    public void addContributor(URI contributor) {
        this.contributors.add(contributor);
    }

    public void addCreator(URI creator) {
        this.creators.add(creator);
    }

    public void addRelatedChangeRequest(Link relatedChangeRequest) {
        this.relatedChangeRequests.add(relatedChangeRequest);
    }

    public void addValidatesRequirement(Link requirement) {
        this.validatesRequirements.add(requirement);
    }

    @OslcDescription(value="The person(s) who are responsible for the work needed to complete the change request.")
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Contributors")
    public URI[] getContributors() {
        return this.contributors.toArray(new URI[this.contributors.size()]);
    }

    @OslcDescription(value="Creator or creators of resource.")
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Creators")
    public URI[] getCreators() {
        return this.creators.toArray(new URI[this.creators.size()]);
    }

    @OslcDescription(value="Descriptive text (reference: Dublin Core) about resource represented as rich text in XHTML content.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcTitle(value="Description")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getDescription() {
        return this.description;
    }

    @OslcDescription(value="Instructions for executing the test script.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#executionInstructions")
    @OslcTitle(value="Execution Instructions")
    public URI getExecutionInstructions() {
        return this.executionInstructions;
    }

    @OslcDescription(value="A related change request.")
    @OslcName(value="relatedChangeRequest")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#relatedChangeRequest")
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Related Change Requests")
    public Link[] getRelatedChangeRequests() {
        return this.relatedChangeRequests.toArray(new Link[this.relatedChangeRequests.size()]);
    }

    @OslcDescription(value="Requirement that is validated by the Test Case.")
    @OslcName(value="validatesRequirement")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#validatesRequirement")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Validates Requirement")
    public Link[] getValidatesRequirements() {
        return this.validatesRequirements.toArray(new Link[this.validatesRequirements.size()]);
    }

    public void setContributors(URI[] contributors) {
        this.contributors.clear();
        if (contributors != null) {
            this.contributors.addAll(Arrays.asList(contributors));
        }
    }

    public void setCreators(URI[] creators) {
        this.creators.clear();
        if (creators != null) {
            this.creators.addAll(Arrays.asList(creators));
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExecutionInstructions(URI executionInstructions) {
        this.executionInstructions = executionInstructions;
    }

    public void setRelatedChangeRequests(Link[] relatedChangeRequests) {
        this.relatedChangeRequests.clear();
        if (relatedChangeRequests != null) {
            this.relatedChangeRequests.addAll(Arrays.asList(relatedChangeRequests));
        }
    }

    public void setValidatesRequirements(Link[] validatesRequirements) {
        this.validatesRequirements.clear();
        if (validatesRequirements != null) {
            this.validatesRequirements.addAll(Arrays.asList(validatesRequirements));
        }
    }
}

