/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.protocol.HttpContext;

public class AuthInterceptor
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (authState == null || authState.getAuthScheme() != null) {
            return;
        }
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        if (targetHost == null) {
            return;
        }
        AuthCache cache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        AuthScheme authScheme = cache.get(targetHost);
        if (authScheme == null) {
            return;
        }
        CredentialsProvider provider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
        if (provider == null) {
            return;
        }
        Credentials creds = provider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
        if (creds == null) {
            return;
        }
        authState.setAuthScheme(authScheme);
        authState.setCredentials(creds);
    }
}

