/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.ProxySelector;
import java.net.URL;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.egit.github.core.RequestError;
import org.eclipse.egit.github.core.client.AuthInterceptor;
import org.eclipse.egit.github.core.client.EntityDeleteMethod;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.GitHubResponse;
import org.eclipse.egit.github.core.client.GsonUtils;
import org.eclipse.egit.github.core.client.OAuth2Scheme;
import org.eclipse.egit.github.core.client.RequestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitHubClient {
    private static final Header USER_AGENT = new BasicHeader("User-Agent", "GitHubJava/1.2.0");
    private final HttpHost httpHost;
    private final HttpContext httpContext;
    private final DefaultHttpClient client = new DefaultHttpClient();
    private Header userAgent = USER_AGENT;
    private final Header accept = new BasicHeader("Accept", "application/vnd.github.beta+json");
    private final String prefix;
    private Gson gson = GsonUtils.getGson();

    public static GitHubClient createClient(String url) {
        try {
            String host = new URL(url).getHost();
            if ("github.com".equals(host) || "gist.github.com".equals(host)) {
                host = "api.github.com";
            }
            return new GitHubClient(host);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public GitHubClient() {
        this("api.github.com");
    }

    public GitHubClient(String hostname) {
        this(hostname, -1, "https");
    }

    public GitHubClient(String hostname, int port, String scheme) {
        this(new HttpHost(hostname, port, scheme));
    }

    public GitHubClient(HttpHost httpHost) {
        if (httpHost == null) {
            throw new IllegalArgumentException("Http host cannot be null");
        }
        this.httpHost = httpHost;
        String host = httpHost.getHostName();
        this.prefix = "api.github.com".equals(host) || "github.com".equals(host) ? null : "/api/v3";
        this.client.setRoutePlanner((HttpRoutePlanner)new ProxySelectorRoutePlanner(this.client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault()));
        this.httpContext = new BasicHttpContext();
        BasicAuthCache authCache = new BasicAuthCache();
        this.httpContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        this.client.addRequestInterceptor((HttpRequestInterceptor)new AuthInterceptor(), 0);
    }

    public GitHubClient setSerializeNulls(boolean serializeNulls) {
        this.gson = GsonUtils.getGson(serializeNulls);
        return this;
    }

    public GitHubClient setUserAgent(String agent) {
        this.userAgent = agent != null && agent.length() > 0 ? new BasicHeader("User-Agent", agent) : USER_AGENT;
        return this;
    }

    protected <V extends HttpMessage> V configureRequest(V request) {
        request.addHeader(this.userAgent);
        request.addHeader(this.accept);
        return request;
    }

    protected String configureUri(String uri) {
        if (this.prefix == null || uri.startsWith("/api/v2/json") || uri.startsWith(this.prefix)) {
            return uri;
        }
        return this.prefix + uri;
    }

    protected HttpPost createPost(String uri) {
        return this.configureRequest(new HttpPost(this.configureUri(uri)));
    }

    protected HttpPut createPut(String uri) {
        return this.configureRequest(new HttpPut(this.configureUri(uri)));
    }

    protected HttpGet createGet(String uri) {
        return this.configureRequest(new HttpGet(this.configureUri(uri)));
    }

    protected HttpDelete createDelete(String uri) {
        return this.configureRequest(new HttpDelete(this.configureUri(uri)));
    }

    protected GitHubClient updateCredentials(String user, String password) {
        if (user != null && password != null) {
            this.client.getCredentialsProvider().setCredentials(new AuthScope(this.httpHost.getHostName(), this.httpHost.getPort()), (Credentials)new UsernamePasswordCredentials(user, password));
        } else {
            this.client.getCredentialsProvider().clear();
        }
        return this;
    }

    public GitHubClient setCredentials(String user, String password) {
        this.updateCredentials(user, password);
        AuthCache authCache = (AuthCache)this.httpContext.getAttribute("http.auth.auth-cache");
        authCache.put(this.httpHost, (AuthScheme)new BasicScheme());
        return this;
    }

    public GitHubClient setOAuth2Token(String token) {
        this.updateCredentials("token", token);
        AuthCache authCache = (AuthCache)this.httpContext.getAttribute("http.auth.auth-cache");
        authCache.put(this.httpHost, (AuthScheme)new OAuth2Scheme());
        return this;
    }

    public String getUser() {
        Credentials credentials = this.client.getCredentialsProvider().getCredentials(new AuthScope(this.httpHost.getHostName(), this.httpHost.getPort()));
        return credentials != null ? credentials.getUserPrincipal().getName() : null;
    }

    protected <V> V parseJson(HttpResponse response, Type type) throws IOException {
        Object object;
        InputStreamReader reader = new InputStreamReader(this.getStream(response), "UTF-8");
        try {
            object = this.gson.fromJson((Reader)reader, type);
        }
        catch (JsonParseException jpe) {
            throw new IOException(jpe.getMessage());
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ignored) {}
        }
        return (V)object;
    }

    private String toJson(Object object) throws IOException {
        try {
            return this.gson.toJson(object);
        }
        catch (JsonParseException jpe) {
            throw new IOException(jpe.getMessage());
        }
    }

    protected HttpEntity getEntity(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new IOException("Response has no entity");
        }
        return entity;
    }

    protected InputStream getStream(HttpResponse response) throws IOException {
        InputStream stream = this.getEntity(response).getContent();
        if (stream == null) {
            throw new IOException("Empty body");
        }
        return stream;
    }

    protected RequestError parseError(HttpResponse response) throws IOException {
        return (RequestError)this.parseJson(response, (Type)((Object)RequestError.class));
    }

    protected IOException createException(HttpResponse response, StatusLine status) {
        int code = status.getStatusCode();
        switch (code) {
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 422: 
            case 500: {
                RequestError error;
                try {
                    error = this.parseError(response);
                }
                catch (IOException e) {
                    return e;
                }
                return new RequestException(error, code);
            }
        }
        return new IOException(status.getReasonPhrase());
    }

    protected boolean isOk(HttpResponse response, StatusLine status) {
        switch (status.getStatusCode()) {
            case 200: 
            case 201: {
                return true;
            }
        }
        return false;
    }

    protected boolean isEmpty(HttpResponse response, StatusLine status) {
        return 204 == status.getStatusCode();
    }

    protected StatusLine getStatus(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine == null) {
            throw new IOException("Empty HTTP response status line");
        }
        return statusLine;
    }

    public InputStream getStream(GitHubRequest request) throws IOException {
        StatusLine status;
        HttpGet method = this.createGet(request.generateUri());
        HttpResponse response = this.client.execute(this.httpHost, (HttpRequest)method, this.httpContext);
        if (this.isOk(response, status = this.getStatus(response))) {
            return this.getStream(response);
        }
        throw this.createException(response, status);
    }

    public GitHubResponse get(GitHubRequest request) throws IOException {
        StatusLine status;
        HttpGet method = this.createGet(request.generateUri());
        HttpResponse response = this.client.execute(this.httpHost, (HttpRequest)method, this.httpContext);
        if (this.isOk(response, status = this.getStatus(response))) {
            Object body = null;
            Type type = request.getType();
            if (type != null) {
                body = this.parseJson(response, type);
            } else {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            return new GitHubResponse(response, body);
        }
        if (this.isEmpty(response, status)) {
            return new GitHubResponse(response, null);
        }
        throw this.createException(response, status);
    }

    protected <V> V sendJson(HttpEntityEnclosingRequestBase method, Object params, Type type) throws IOException {
        StatusLine status;
        HttpResponse response;
        if (params != null) {
            method.setEntity((HttpEntity)new StringEntity(this.toJson(params), "application/json", "UTF-8"));
        }
        if (this.isOk(response = this.client.execute(this.httpHost, (HttpRequest)method, this.httpContext), status = this.getStatus(response))) {
            if (type != null) {
                return this.parseJson(response, type);
            }
            EntityUtils.consume((HttpEntity)response.getEntity());
            return null;
        }
        if (this.isEmpty(response, status)) {
            return null;
        }
        throw this.createException(response, status);
    }

    public <V> V post(String uri, Object params, Type type) throws IOException {
        return this.sendJson((HttpEntityEnclosingRequestBase)this.createPost(uri), params, type);
    }

    public void post(String uri) throws IOException {
        this.post(uri, null, null);
    }

    public <V> V put(String uri, Object params, Type type) throws IOException {
        return this.sendJson((HttpEntityEnclosingRequestBase)this.createPut(uri), params, type);
    }

    public void put(String uri) throws IOException {
        this.put(uri, null, null);
    }

    public void delete(String uri, Object params) throws IOException {
        Object method;
        if (params == null) {
            method = this.createDelete(uri);
        } else {
            EntityDeleteMethod delete = this.configureRequest(new EntityDeleteMethod(uri));
            delete.setEntity((HttpEntity)new StringEntity(this.toJson(params), "application/json", "UTF-8"));
            method = delete;
        }
        HttpResponse response = this.client.execute(this.httpHost, (HttpRequest)method, this.httpContext);
        StatusLine status = this.getStatus(response);
        if (!this.isEmpty(response, status)) {
            throw new RequestException(this.parseError(response), status.getStatusCode());
        }
    }

    public void delete(String uri) throws IOException {
        this.delete(uri, null);
    }
}

