/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitHubRequest {
    private String uri;
    private Map<String, String> params;
    private Type type;

    public String getUri() {
        return this.uri;
    }

    protected List<NameValuePair> getPairs(Map<String, String> data) {
        LinkedList<NameValuePair> pairs = new LinkedList<NameValuePair>();
        if (data != null && !data.isEmpty()) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                pairs.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        return pairs;
    }

    public String generateUri() {
        String baseUri = this.uri;
        if (baseUri == null) {
            return null;
        }
        if (baseUri.indexOf(63) != -1) {
            return baseUri;
        }
        String params = URLEncodedUtils.format(this.getPairs(this.getParams()), null);
        if (params != null && params.length() > 0) {
            return baseUri + '?' + params;
        }
        return baseUri;
    }

    public GitHubRequest setUri(StringBuilder uri) {
        return this.setUri(uri != null ? uri.toString() : null);
    }

    public GitHubRequest setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public GitHubRequest setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public GitHubRequest setType(Type type) {
        this.type = type;
        return this;
    }

    public int hashCode() {
        String fullUri = this.generateUri();
        return fullUri != null ? fullUri.hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GitHubRequest)) {
            return false;
        }
        String fullUri = this.generateUri();
        String objUri = ((GitHubRequest)obj).generateUri();
        return fullUri != null && objUri != null && fullUri.equals(objUri);
    }

    public String toString() {
        String fullUri = this.generateUri();
        return fullUri != null ? fullUri : super.toString();
    }
}

