/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BasicHeader;

public class OAuth2Scheme
extends RFC2617Scheme {
    private boolean complete = false;

    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    public String getSchemeName() {
        return "oauth2";
    }

    public boolean isConnectionBased() {
        return false;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials cannot be null");
        }
        return new BasicHeader("Authorization", credentials.getUserPrincipal().getName() + ' ' + credentials.getPassword());
    }
}

