/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.egit.github.core.client.GitHubRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedRequest<V>
extends GitHubRequest {
    public static final int PAGE_FIRST = 1;
    public static final int PAGE_SIZE = 100;
    private final int pageSize;
    private final int page;

    public PagedRequest() {
        this(1, 100);
    }

    public PagedRequest(int start, int size) {
        this.page = start;
        this.pageSize = size;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    protected List<NameValuePair> getPairs(Map<String, String> data) {
        int number;
        List<NameValuePair> pairs = super.getPairs(data);
        int size = this.getPageSize();
        if (size > 0) {
            pairs.add((NameValuePair)new BasicNameValuePair("per_page", Integer.toString(size)));
        }
        if ((number = this.getPage()) > 0) {
            pairs.add((NameValuePair)new BasicNameValuePair("page", Integer.toString(number)));
        }
        return pairs;
    }

    public int getPage() {
        return this.page;
    }
}

