/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MilestoneService
extends GitHubService {
    public MilestoneService() {
    }

    public MilestoneService(GitHubClient client) {
        super(client);
    }

    public List<Milestone> getMilestones(String user, String repository, String state) throws IOException {
        this.verifyRepository(user, repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(user).append('/').append(repository);
        uri.append("/milestones");
        PagedRequest request = this.createPagedRequest();
        if (state != null) {
            request.setParams(Collections.singletonMap("state", state));
        }
        request.setUri(uri).setType(new TypeToken<List<Milestone>>(){}.getType());
        return this.getAll(request);
    }

    public Milestone createMilestone(String user, String repository, Milestone milestone) throws IOException {
        this.verifyRepository(user, repository);
        if (milestone == null) {
            throw new IllegalArgumentException("Milestone cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(user).append('/').append(repository);
        uri.append("/milestones");
        return (Milestone)this.client.post(uri.toString(), milestone, (Type)((Object)Milestone.class));
    }

    public Milestone getMilestone(String user, String repository, int number) throws IOException {
        return this.getMilestone(user, repository, Integer.toString(number));
    }

    public Milestone getMilestone(String user, String repository, String number) throws IOException {
        this.verifyRepository(user, repository);
        if (number == null) {
            throw new IllegalArgumentException("Milestone cannot be null");
        }
        if (number.length() == 0) {
            throw new IllegalArgumentException("Milestone cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(user).append('/').append(repository);
        uri.append("/milestones");
        uri.append('/').append(number);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)Milestone.class));
        return (Milestone)this.client.get(request).getBody();
    }

    public void deleteMilestone(String user, String repository, int milestone) throws IOException {
        this.deleteMilestone(user, repository, Integer.toString(milestone));
    }

    public void deleteMilestone(String user, String repository, String milestone) throws IOException {
        this.verifyRepository(user, repository);
        if (milestone == null) {
            throw new IllegalArgumentException("Milestone cannot be null");
        }
        if (milestone.length() == 0) {
            throw new IllegalArgumentException("Milestone cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(user).append('/').append(repository);
        uri.append("/milestones");
        uri.append('/').append(milestone);
        this.client.delete(uri.toString());
    }
}

