/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.github.core.Contributor;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.IResourceProvider;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryBranch;
import org.eclipse.egit.github.core.RepositoryHook;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.RepositoryTag;
import org.eclipse.egit.github.core.SearchRepository;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryService
extends GitHubService {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_HOMEPAGE = "homepage";
    public static final String FIELD_PUBLIC = "public";
    public static final String FILTER_TYPE = "type";
    public static final String TYPE_PUBLIC = "public";
    public static final String TYPE_PRIVATE = "private";
    public static final String TYPE_MEMBER = "member";
    public static final String TYPE_ALL = "all";

    public RepositoryService() {
    }

    public RepositoryService(GitHubClient client) {
        super(client);
    }

    public List<Repository> getRepositories() throws IOException {
        return this.getRepositories((Map<String, String>)null);
    }

    public List<Repository> getRepositories(Map<String, String> filterData) throws IOException {
        return this.getAll(this.pageRepositories(filterData));
    }

    public PageIterator<Repository> pageRepositories() throws IOException {
        return this.pageRepositories(100);
    }

    public PageIterator<Repository> pageRepositories(int size) throws IOException {
        return this.pageRepositories(1, size);
    }

    public PageIterator<Repository> pageRepositories(int start, int size) throws IOException {
        return this.pageRepositories((Map<String, String>)null, start, size);
    }

    public PageIterator<Repository> pageRepositories(Map<String, String> filterData) throws IOException {
        return this.pageRepositories(filterData, 100);
    }

    public PageIterator<Repository> pageRepositories(Map<String, String> filterData, int size) throws IOException {
        return this.pageRepositories(filterData, 1, size);
    }

    public PageIterator<Repository> pageRepositories(Map<String, String> filterData, int start, int size) throws IOException {
        PagedRequest request = this.createPagedRequest(start, size);
        request.setUri("/user/repos");
        request.setParams(filterData);
        request.setType(new TypeToken<List<Repository>>(){}.getType());
        return this.createPageIterator(request);
    }

    public List<Repository> getRepositories(String user) throws IOException {
        return this.getAll(this.pageRepositories(user));
    }

    public PageIterator<Repository> pageRepositories(String user) throws IOException {
        return this.pageRepositories(user, 100);
    }

    public PageIterator<Repository> pageRepositories(String user, int size) throws IOException {
        return this.pageRepositories(user, 1, size);
    }

    public PageIterator<Repository> pageRepositories(String user, int start, int size) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user);
        uri.append("/repos");
        PagedRequest request = this.createPagedRequest(start, size);
        request.setUri(uri);
        request.setType(new TypeToken<List<Repository>>(){}.getType());
        return this.createPageIterator(request);
    }

    public List<Repository> getOrgRepositories(String organization) throws IOException {
        return this.getOrgRepositories(organization, null);
    }

    public PageIterator<Repository> pageOrgRepositories(String organization) {
        return this.pageOrgRepositories(organization, 100);
    }

    public PageIterator<Repository> pageOrgRepositories(String organization, int size) {
        return this.pageOrgRepositories(organization, 1, size);
    }

    public PageIterator<Repository> pageOrgRepositories(String organization, int start, int size) {
        return this.pageOrgRepositories(organization, null, start, size);
    }

    public List<Repository> getOrgRepositories(String organization, Map<String, String> filterData) throws IOException {
        return this.getAll(this.pageOrgRepositories(organization, filterData));
    }

    public PageIterator<Repository> pageOrgRepositories(String organization, Map<String, String> filterData) {
        return this.pageOrgRepositories(organization, filterData, 100);
    }

    public PageIterator<Repository> pageOrgRepositories(String organization, Map<String, String> filterData, int size) {
        return this.pageOrgRepositories(organization, filterData, 1, size);
    }

    public PageIterator<Repository> pageOrgRepositories(String organization, Map<String, String> filterData, int start, int size) {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/repos");
        PagedRequest request = this.createPagedRequest(start, size);
        request.setParams(filterData);
        request.setUri(uri);
        request.setType(new TypeToken<List<Repository>>(){}.getType());
        return this.createPageIterator(request);
    }

    public List<SearchRepository> searchRepositories(String query) throws IOException {
        return this.searchRepositories(query, -1);
    }

    public List<SearchRepository> searchRepositories(String query, int startPage) throws IOException {
        return this.searchRepositories(query, null, startPage);
    }

    public List<SearchRepository> searchRepositories(String query, String language) throws IOException {
        return this.searchRepositories(query, language, -1);
    }

    public List<SearchRepository> searchRepositories(String query, String language, int startPage) throws IOException {
        if (query == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("Query cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/api/v2/json");
        uri.append("/repos");
        uri.append("/search");
        String encodedQuery = URLEncoder.encode(query, "UTF-8").replace("+", "%20").replace(".", "%2E");
        uri.append('/').append(encodedQuery);
        PagedRequest request = this.createPagedRequest();
        HashMap<String, String> params = new HashMap<String, String>(2, 1.0f);
        if (language != null && language.length() > 0) {
            params.put("language", language);
        }
        if (startPage > 0) {
            params.put("start_page", Integer.toString(startPage));
        }
        if (!params.isEmpty()) {
            request.setParams(params);
        }
        request.setUri(uri);
        request.setType((Type)((Object)RepositoryContainer.class));
        return this.getAll(request);
    }

    public List<SearchRepository> searchRepositories(Map<String, String> params) throws IOException {
        return this.searchRepositories(params, -1);
    }

    public List<SearchRepository> searchRepositories(Map<String, String> queryParams, int startPage) throws IOException {
        if (queryParams == null) {
            throw new IllegalArgumentException("Params cannot be null");
        }
        if (queryParams.isEmpty()) {
            throw new IllegalArgumentException("Params cannot be empty");
        }
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> param : queryParams.entrySet()) {
            query.append(param.getKey()).append(':').append(param.getValue()).append(' ');
        }
        return this.searchRepositories(query.toString(), startPage);
    }

    public Repository createRepository(Repository repository) throws IOException {
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        return (Repository)this.client.post("/user/repos", repository, (Type)((Object)Repository.class));
    }

    public Repository createRepository(String organization, Repository repository) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/repos");
        return (Repository)this.client.post(uri.toString(), repository, (Type)((Object)Repository.class));
    }

    public Repository getRepository(String owner, String name) throws IOException {
        return this.getRepository(RepositoryId.create(owner, name));
    }

    public Repository getRepository(IRepositoryIdProvider provider) throws IOException {
        String id = this.getId(provider);
        GitHubRequest request = this.createRequest();
        request.setUri("/repos/" + id);
        request.setType((Type)((Object)Repository.class));
        return (Repository)this.client.get(request).getBody();
    }

    protected PagedRequest<Repository> createPagedForkRequest(IRepositoryIdProvider repository, int start, int size) {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/forks");
        PagedRequest<Repository> request = this.createPagedRequest(start, size);
        request.setUri(uri);
        request.setType(new TypeToken<List<Repository>>(){}.getType());
        return request;
    }

    public List<Repository> getForks(IRepositoryIdProvider repository) throws IOException {
        return this.getAll(this.pageForks(repository));
    }

    public PageIterator<Repository> pageForks(IRepositoryIdProvider repository) {
        return this.pageForks(repository, 100);
    }

    public PageIterator<Repository> pageForks(IRepositoryIdProvider repository, int size) {
        return this.pageForks(repository, 1, size);
    }

    public PageIterator<Repository> pageForks(IRepositoryIdProvider repository, int start, int size) {
        PagedRequest<Repository> request = this.createPagedForkRequest(repository, start, size);
        return this.createPageIterator(request);
    }

    public Repository editRepository(Repository repository) throws IOException {
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        return (Repository)this.client.post(uri.toString(), repository, (Type)((Object)Repository.class));
    }

    public Repository forkRepository(IRepositoryIdProvider repository) throws IOException {
        return this.forkRepository(repository, null);
    }

    public Repository forkRepository(IRepositoryIdProvider repository, String organization) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/forks");
        Map<String, String> params = null;
        if (organization != null) {
            params = Collections.singletonMap("org", organization);
        }
        return (Repository)this.client.post(uri.toString(), params, (Type)((Object)Repository.class));
    }

    public Map<String, Long> getLanguages(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/languages");
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType(new TypeToken<Map<String, Long>>(){}.getType());
        return (Map)this.client.get(request).getBody();
    }

    public List<RepositoryBranch> getBranches(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/branches");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<RepositoryBranch>>(){}.getType());
        return this.getAll(request);
    }

    public List<RepositoryTag> getTags(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/tags");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<RepositoryTag>>(){}.getType());
        return this.getAll(request);
    }

    public List<Contributor> getContributors(IRepositoryIdProvider repository, boolean includeAnonymous) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/contributors");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        if (includeAnonymous) {
            request.setParams(Collections.singletonMap("anon", "1"));
        }
        request.setType(new TypeToken<List<Contributor>>(){}.getType());
        return this.getAll(request);
    }

    public List<RepositoryHook> getHooks(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/hooks");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<RepositoryHook>>(){}.getType());
        return this.getAll(request);
    }

    public RepositoryHook getHook(IRepositoryIdProvider repository, int hookId) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/hooks");
        uri.append('/').append(hookId);
        GitHubRequest request = this.createRequest();
        request.setType((Type)((Object)RepositoryHook.class));
        request.setUri(uri);
        return (RepositoryHook)this.client.get(request).getBody();
    }

    public RepositoryHook createHook(IRepositoryIdProvider repository, RepositoryHook hook) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/hooks");
        return (RepositoryHook)this.client.post(uri.toString(), hook, (Type)((Object)RepositoryHook.class));
    }

    public RepositoryHook editHook(IRepositoryIdProvider repository, RepositoryHook hook) throws IOException {
        String id = this.getId(repository);
        if (hook == null) {
            throw new IllegalArgumentException("Hook cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/hooks");
        uri.append('/').append(hook.getId());
        return (RepositoryHook)this.client.put(uri.toString(), hook, (Type)((Object)RepositoryHook.class));
    }

    public void deleteHook(IRepositoryIdProvider repository, int hookId) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/hooks");
        uri.append('/').append(hookId);
        this.client.delete(uri.toString());
    }

    public void testHook(IRepositoryIdProvider repository, int hookId) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/hooks");
        uri.append('/').append(hookId);
        uri.append("/test");
        this.client.post(uri.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RepositoryContainer
    implements IResourceProvider<SearchRepository> {
        private List<SearchRepository> repositories;

        private RepositoryContainer() {
        }

        @Override
        public List<SearchRepository> getResources() {
            return this.repositories;
        }
    }
}

