/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.egit.github.core.IRepositoryIdProvider;

public abstract class UrlUtils {
    public static String encode(String url) {
        try {
            return URLEncoder.encode(url, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String createRemoteSshUrl(IRepositoryIdProvider repository) {
        return UrlUtils.createRemoteSshUrl(repository, "github.com");
    }

    public static String createRemoteSshUrl(IRepositoryIdProvider repository, String host) {
        return "git@" + host + ":" + repository.generateId() + ".git";
    }

    public static String createRemoteHttpsUrl(IRepositoryIdProvider repository, String user) {
        return UrlUtils.createRemoteHttpsUrl(repository, "github.com", user);
    }

    public static String createRemoteHttpsUrl(IRepositoryIdProvider repository, String host, String user) {
        return "https://" + user + "@" + host + "/" + repository.generateId() + ".git";
    }

    public static String createRemoteReadOnlyUrl(IRepositoryIdProvider repository) {
        return UrlUtils.createRemoteReadOnlyUrl(repository, "github.com");
    }

    public static String createRemoteReadOnlyUrl(IRepositoryIdProvider repository, String host) {
        return "git://" + host + "/" + repository.generateId() + ".git";
    }
}

