/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Date;
import org.eclipse.egit.github.core.client.DateFormatter;
import org.eclipse.egit.github.core.event.CommitCommentPayload;
import org.eclipse.egit.github.core.event.CreatePayload;
import org.eclipse.egit.github.core.event.DeletePayload;
import org.eclipse.egit.github.core.event.DownloadPayload;
import org.eclipse.egit.github.core.event.Event;
import org.eclipse.egit.github.core.event.EventPayload;
import org.eclipse.egit.github.core.event.FollowPayload;
import org.eclipse.egit.github.core.event.ForkApplyPayload;
import org.eclipse.egit.github.core.event.ForkPayload;
import org.eclipse.egit.github.core.event.GistPayload;
import org.eclipse.egit.github.core.event.GollumPayload;
import org.eclipse.egit.github.core.event.IssueCommentPayload;
import org.eclipse.egit.github.core.event.IssuesPayload;
import org.eclipse.egit.github.core.event.MemberPayload;
import org.eclipse.egit.github.core.event.PublicPayload;
import org.eclipse.egit.github.core.event.PullRequestPayload;
import org.eclipse.egit.github.core.event.PullRequestReviewCommentPayload;
import org.eclipse.egit.github.core.event.PushPayload;
import org.eclipse.egit.github.core.event.TeamAddPayload;
import org.eclipse.egit.github.core.event.WatchPayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventFormatter
implements JsonDeserializer<Event> {
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateFormatter()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public Event deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Class payloadClass;
        Event event = (Event)this.gson.fromJson(json, Event.class);
        if (event == null || !json.isJsonObject()) {
            return event;
        }
        JsonElement rawPayload = json.getAsJsonObject().get("payload");
        if (rawPayload == null || !rawPayload.isJsonObject()) {
            return event;
        }
        String type = event.getType();
        if (type == null || type.length() == 0) {
            return event;
        }
        if ("CommitCommentEvent".equals(type)) {
            payloadClass = CommitCommentPayload.class;
        } else if ("CreateEvent".equals(type)) {
            payloadClass = CreatePayload.class;
        } else if ("DeleteEvent".equals(type)) {
            payloadClass = DeletePayload.class;
        } else if ("DownloadEvent".equals(type)) {
            payloadClass = DownloadPayload.class;
        } else if ("FollowEvent".equals(type)) {
            payloadClass = FollowPayload.class;
        } else if ("ForkEvent".equals(type)) {
            payloadClass = ForkPayload.class;
        } else if ("ForkApplyEvent".equals(type)) {
            payloadClass = ForkApplyPayload.class;
        } else if ("GistEvent".equals(type)) {
            payloadClass = GistPayload.class;
        } else if ("GollumEvent".equals(type)) {
            payloadClass = GollumPayload.class;
        } else if ("IssueCommentEvent".equals(type)) {
            payloadClass = IssueCommentPayload.class;
        } else if ("IssuesEvent".equals(type)) {
            payloadClass = IssuesPayload.class;
        } else if ("MemberEvent".equals(type)) {
            payloadClass = MemberPayload.class;
        } else if ("PublicEvent".equals(type)) {
            payloadClass = PublicPayload.class;
        } else if ("PullRequestEvent".equals(type)) {
            payloadClass = PullRequestPayload.class;
        } else if ("PullRequestReviewCommentEvent".equals(type)) {
            payloadClass = PullRequestReviewCommentPayload.class;
        } else if ("PushEvent".equals(type)) {
            payloadClass = PushPayload.class;
        } else if ("TeamAddEvent".equals(type)) {
            payloadClass = TeamAddPayload.class;
        } else if ("WatchEvent".equals(type)) {
            payloadClass = WatchPayload.class;
        } else {
            return event;
        }
        EventPayload typedPayload = (EventPayload)context.deserialize(rawPayload, payloadClass);
        return event.setPayload(typedPayload);
    }
}

