/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.egit.github.core.RequestError;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.GitHubResponse;
import org.eclipse.egit.github.core.client.GsonUtils;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.util.EncodingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitHubClient {
    protected static final String HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String HEADER_ACCEPT = "Accept";
    protected static final String HEADER_AUTHORIZATION = "Authorization";
    protected static final String HEADER_USER_AGENT = "User-Agent";
    protected static final String METHOD_GET = "GET";
    protected static final String METHOD_PUT = "PUT";
    protected static final String METHOD_POST = "POST";
    protected static final String METHOD_DELETE = "DELETE";
    protected static final String USER_AGENT = "GitHubJava/1.3.6";
    protected static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    protected final String baseUri;
    protected final String prefix;
    protected Gson gson = GsonUtils.getGson();
    private String user;
    private String credentials;
    private String userAgent;
    private int bufferSize = 8192;
    private int requestLimit = -1;
    private int remainingRequests = -1;

    public static GitHubClient createClient(String url) {
        try {
            String host = new URL(url).getHost();
            if ("github.com".equals(host) || "gist.github.com".equals(host)) {
                host = "api.github.com";
            }
            return new GitHubClient(host);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public GitHubClient() {
        this("api.github.com");
    }

    public GitHubClient(String hostname) {
        this(hostname, -1, "https");
    }

    public GitHubClient(String hostname, int port, String scheme) {
        StringBuilder uri = new StringBuilder(scheme);
        uri.append("://");
        uri.append(hostname);
        if (port > 0) {
            uri.append(port);
        }
        this.baseUri = uri.toString();
        this.prefix = "api.github.com".equals(hostname) || "github.com".equals(hostname) ? null : "/api/v3";
    }

    public GitHubClient setSerializeNulls(boolean serializeNulls) {
        this.gson = GsonUtils.getGson(serializeNulls);
        return this;
    }

    public GitHubClient setUserAgent(String agent) {
        this.userAgent = agent != null && agent.length() > 0 ? agent : USER_AGENT;
        return this;
    }

    protected HttpURLConnection configureRequest(HttpURLConnection request) {
        if (this.credentials != null) {
            request.setRequestProperty(HEADER_AUTHORIZATION, this.credentials);
        }
        request.setRequestProperty(HEADER_USER_AGENT, this.userAgent);
        request.setRequestProperty(HEADER_ACCEPT, "application/vnd.github.beta+json");
        return request;
    }

    protected String configureUri(String uri) {
        if (this.prefix == null || uri.startsWith("/api/v2/json") || uri.startsWith(this.prefix)) {
            return uri;
        }
        return this.prefix + uri;
    }

    protected HttpURLConnection createConnection(String uri) throws IOException {
        URL url = new URL(this.createUri(uri));
        return (HttpURLConnection)url.openConnection();
    }

    protected HttpURLConnection createConnection(String uri, String method) throws IOException {
        HttpURLConnection connection = this.createConnection(uri);
        connection.setRequestMethod(method);
        return this.configureRequest(connection);
    }

    protected HttpURLConnection createGet(String uri) throws IOException {
        return this.createConnection(uri, METHOD_GET);
    }

    protected HttpURLConnection createPost(String uri) throws IOException {
        return this.createConnection(uri, METHOD_POST);
    }

    protected HttpURLConnection createPut(String uri) throws IOException {
        return this.createConnection(uri, METHOD_PUT);
    }

    protected HttpURLConnection createDelete(String uri) throws IOException {
        return this.createConnection(uri, METHOD_DELETE);
    }

    public GitHubClient setCredentials(String user, String password) {
        this.user = user;
        this.credentials = user != null && user.length() > 0 && password != null && password.length() > 0 ? "Basic " + EncodingUtils.toBase64(user + ':' + password) : null;
        return this;
    }

    public GitHubClient setOAuth2Token(String token) {
        this.credentials = token != null && token.length() > 0 ? "token " + token : null;
        return this;
    }

    public GitHubClient setBufferSize(int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be greater than zero");
        }
        this.bufferSize = bufferSize;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    protected String toJson(Object object) throws IOException {
        try {
            return this.gson.toJson(object);
        }
        catch (JsonParseException jpe) {
            IOException ioe = new IOException("Parse exception converting object to JSON");
            ioe.initCause(jpe);
            throw ioe;
        }
    }

    protected <V> V parseJson(InputStream stream, Type type) throws IOException {
        Object object;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"), this.bufferSize);
        try {
            object = this.gson.fromJson((Reader)reader, type);
        }
        catch (JsonParseException jpe) {
            IOException ioe = new IOException("Parse exception converting JSON to object");
            ioe.initCause(jpe);
            throw ioe;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ignored) {}
        }
        return (V)object;
    }

    protected boolean isError(int code) {
        switch (code) {
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 409: 
            case 410: 
            case 422: 
            case 500: {
                return true;
            }
        }
        return false;
    }

    protected boolean isOk(int code) {
        switch (code) {
            case 200: 
            case 201: 
            case 202: {
                return true;
            }
        }
        return false;
    }

    protected boolean isEmpty(int code) {
        return 204 == code;
    }

    protected RequestError parseError(InputStream response) throws IOException {
        return (RequestError)this.parseJson(response, (Type)((Object)RequestError.class));
    }

    protected Object getBody(GitHubRequest request, InputStream stream) throws IOException {
        Type type = request.getType();
        if (type != null) {
            return this.parseJson(stream, type);
        }
        return null;
    }

    protected IOException createException(InputStream response, int code, String status) {
        if (this.isError(code)) {
            RequestError error;
            try {
                error = this.parseError(response);
            }
            catch (IOException e) {
                return e;
            }
            if (error != null) {
                return new RequestException(error, code);
            }
        }
        String message = status != null && status.length() > 0 ? status + " (" + code + ")" : "Unknown error occurred (" + code + ")";
        return new IOException(message);
    }

    public void post(String uri) throws IOException {
        this.post(uri, null, null);
    }

    public void put(String uri) throws IOException {
        this.put(uri, null, null);
    }

    public void delete(String uri) throws IOException {
        this.delete(uri, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendParams(HttpURLConnection request, Object params) throws IOException {
        request.setDoOutput(true);
        if (params != null) {
            request.setRequestProperty(HEADER_CONTENT_TYPE, "application/json; charset=UTF-8");
            byte[] data = this.toJson(params).getBytes("UTF-8");
            request.setFixedLengthStreamingMode(data.length);
            BufferedOutputStream output = new BufferedOutputStream(request.getOutputStream(), this.bufferSize);
            try {
                output.write(data);
                output.flush();
            }
            finally {
                try {
                    output.close();
                }
                catch (IOException ignored) {}
            }
        }
        request.setFixedLengthStreamingMode(0);
    }

    private <V> V sendJson(HttpURLConnection request, Object params, Type type) throws IOException {
        this.sendParams(request, params);
        int code = request.getResponseCode();
        this.updateRateLimits(request);
        if (this.isOk(code)) {
            if (type != null) {
                return this.parseJson(this.getStream(request), type);
            }
            return null;
        }
        if (this.isEmpty(code)) {
            return null;
        }
        throw this.createException(this.getStream(request), code, request.getResponseMessage());
    }

    protected String createUri(String path) {
        return this.baseUri + this.configureUri(path);
    }

    public InputStream getStream(GitHubRequest request) throws IOException {
        return this.getStream(this.createGet(request.generateUri()));
    }

    protected InputStream getStream(HttpURLConnection request) throws IOException {
        if (request.getResponseCode() < 400) {
            return request.getInputStream();
        }
        InputStream stream = request.getErrorStream();
        return stream != null ? stream : request.getInputStream();
    }

    public GitHubResponse get(GitHubRequest request) throws IOException {
        HttpURLConnection httpRequest = this.createGet(request.generateUri());
        String accept = request.getResponseContentType();
        if (accept != null) {
            httpRequest.setRequestProperty(HEADER_ACCEPT, accept);
        }
        int code = httpRequest.getResponseCode();
        this.updateRateLimits(httpRequest);
        if (this.isOk(code)) {
            return new GitHubResponse(httpRequest, this.getBody(request, this.getStream(httpRequest)));
        }
        if (this.isEmpty(code)) {
            return new GitHubResponse(httpRequest, null);
        }
        throw this.createException(this.getStream(httpRequest), code, httpRequest.getResponseMessage());
    }

    public <V> V post(String uri, Object params, Type type) throws IOException {
        HttpURLConnection request = this.createPost(uri);
        return this.sendJson(request, params, type);
    }

    public <V> V put(String uri, Object params, Type type) throws IOException {
        HttpURLConnection request = this.createPut(uri);
        return this.sendJson(request, params, type);
    }

    public void delete(String uri, Object params) throws IOException {
        HttpURLConnection request = this.createDelete(uri);
        this.sendParams(request, params);
        int code = request.getResponseCode();
        this.updateRateLimits(request);
        if (!this.isEmpty(code)) {
            throw new RequestException(this.parseError(this.getStream(request)), code);
        }
    }

    protected GitHubClient updateRateLimits(HttpURLConnection request) {
        String remaining;
        String limit = request.getHeaderField("X-RateLimit-Limit");
        if (limit != null && limit.length() > 0) {
            try {
                this.requestLimit = Integer.parseInt(limit);
            }
            catch (NumberFormatException nfe) {
                this.requestLimit = -1;
            }
        } else {
            this.requestLimit = -1;
        }
        if ((remaining = request.getHeaderField("X-RateLimit-Remaining")) != null && remaining.length() > 0) {
            try {
                this.remainingRequests = Integer.parseInt(remaining);
            }
            catch (NumberFormatException nfe) {
                this.remainingRequests = -1;
            }
        } else {
            this.remainingRequests = -1;
        }
        return this;
    }

    public int getRemainingRequests() {
        return this.remainingRequests;
    }

    public int getRequestLimit() {
        return this.requestLimit;
    }
}

