/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import org.eclipse.egit.github.core.IRepositoryIdProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UrlUtils {
    public static String createRemoteSshUrl(IRepositoryIdProvider repository) {
        return UrlUtils.createRemoteSshUrl(repository, "github.com");
    }

    public static String createRemoteSshUrl(IRepositoryIdProvider repository, String host) {
        return "git@" + host + ":" + repository.generateId() + ".git";
    }

    public static String createRemoteHttpsUrl(IRepositoryIdProvider repository, String user) {
        return UrlUtils.createRemoteHttpsUrl(repository, "github.com", user);
    }

    public static String createRemoteHttpsUrl(IRepositoryIdProvider repository, String host, String user) {
        return "https://" + user + "@" + host + "/" + repository.generateId() + ".git";
    }

    public static String createRemoteReadOnlyUrl(IRepositoryIdProvider repository) {
        return UrlUtils.createRemoteReadOnlyUrl(repository, "github.com");
    }

    public static String createRemoteReadOnlyUrl(IRepositoryIdProvider repository, String host) {
        return "git://" + host + "/" + repository.generateId() + ".git";
    }

    public static String encode(String value) {
        try {
            return URLEncoder.encode(value, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String decode(String value) {
        try {
            return URLDecoder.decode(value, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void addParam(String name, String value, StringBuilder uri) {
        if (uri.length() > 0) {
            uri.append('&');
        }
        uri.append(UrlUtils.encode(name)).append('=');
        if (value != null) {
            uri.append(UrlUtils.encode(value));
        }
    }

    public static void addParams(Map<String, String> params, StringBuilder uri) {
        if (params == null || params.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> param : params.entrySet()) {
            UrlUtils.addParam(param.getKey(), param.getValue(), uri);
        }
    }

    public static String getParam(URI uri, String name) {
        String[] params;
        String query = uri.getRawQuery();
        if (query == null || query.length() == 0) {
            return null;
        }
        for (String param : params = query.split("&")) {
            String[] parts = param.split("=");
            if (parts.length != 2 || !name.equals(parts[0])) continue;
            return UrlUtils.decode(parts[1]);
        }
        return null;
    }
}

