/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.signature;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.bc.BcPGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.eclipse.packager.rpm.HashAlgorithm;
import org.eclipse.packager.rpm.RpmSignatureTag;
import org.eclipse.packager.rpm.Rpms;
import org.eclipse.packager.rpm.header.Header;
import org.eclipse.packager.rpm.header.Headers;
import org.eclipse.packager.rpm.info.RpmInformation;
import org.eclipse.packager.rpm.info.RpmInformations;
import org.eclipse.packager.rpm.parse.RpmInputStream;
import org.eclipse.packager.rpm.signature.RsaSignatureProcessor;
import org.eclipse.packager.rpm.signature.SignatureProcessor;
import org.eclipse.packager.rpm.signature.SignatureProcessors;

public class RpmFileSignatureProcessor {
    private RpmFileSignatureProcessor() {
    }

    public static void perform(File rpm, InputStream privateKeyIn, String passphrase, OutputStream out, HashAlgorithm hashAlgorithm) throws IOException, PGPException {
        byte[] signatureHeader;
        long leadLength = 96L;
        long signatureHeaderStart = 0L;
        long signatureHeaderLength = 0L;
        long payloadHeaderStart = 0L;
        long payloadHeaderLength = 0L;
        long payloadStart = 0L;
        long archiveSize = 0L;
        long payloadSize = 0L;
        if (!rpm.exists()) {
            throw new IOException("The file " + rpm.getName() + " does not exist");
        }
        PGPPrivateKey privateKey = RpmFileSignatureProcessor.getPrivateKey(privateKeyIn, passphrase);
        try (RpmInputStream rpmIn = new RpmInputStream(new FileInputStream(rpm));){
            signatureHeaderStart = rpmIn.getSignatureHeader().getStart();
            signatureHeaderLength = rpmIn.getSignatureHeader().getLength();
            payloadHeaderStart = rpmIn.getPayloadHeader().getStart();
            payloadHeaderLength = rpmIn.getPayloadHeader().getLength();
            RpmInformation info = RpmInformations.makeInformation(rpmIn);
            payloadStart = info.getHeaderEnd();
            archiveSize = info.getArchiveSize();
        }
        if (signatureHeaderStart == 0L || signatureHeaderLength == 0L || payloadHeaderStart == 0L || payloadHeaderLength == 0L || payloadStart == 0L || archiveSize == 0L) {
            throw new IOException("Unable to read " + rpm.getName() + " informations.");
        }
        try (FileInputStream in = new FileInputStream(rpm);){
            FileChannel channelIn = in.getChannel();
            payloadSize = channelIn.size() - payloadStart;
            channelIn.position(96L + signatureHeaderLength);
            ByteBuffer payloadHeaderBuff = ByteBuffer.allocate((int)payloadHeaderLength);
            IOUtils.readFully((ReadableByteChannel)channelIn, (ByteBuffer)payloadHeaderBuff);
            ByteBuffer payloadBuff = ByteBuffer.allocate((int)payloadSize);
            IOUtils.readFully((ReadableByteChannel)channelIn, (ByteBuffer)payloadBuff);
            signatureHeader = RpmFileSignatureProcessor.getSignature(privateKey, payloadHeaderBuff, payloadBuff, archiveSize, hashAlgorithm);
        }
        in = new FileInputStream(rpm);
        try {
            IOUtils.copyLarge((InputStream)in, (OutputStream)out, (long)0L, (long)96L);
            IOUtils.skip((InputStream)in, (long)signatureHeaderLength);
            out.write(signatureHeader);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            in.close();
        }
    }

    private static byte[] getSignature(PGPPrivateKey privateKey, ByteBuffer payloadHeader, ByteBuffer payload, long archiveSize, HashAlgorithm hashAlgorithm) throws IOException {
        Header<RpmSignatureTag> signatureHeader = new Header<RpmSignatureTag>();
        List<SignatureProcessor> signatureProcessors = RpmFileSignatureProcessor.getSignatureProcessors(privateKey, hashAlgorithm);
        payloadHeader.flip();
        payload.flip();
        for (SignatureProcessor processor : signatureProcessors) {
            processor.init(archiveSize);
            processor.feedHeader(payloadHeader.slice());
            processor.feedPayloadData(payload.slice());
            processor.finish(signatureHeader);
        }
        ByteBuffer signatureBuf = Headers.render(signatureHeader.makeEntries(), true, 62);
        int payloadSize = signatureBuf.remaining();
        int padding = Rpms.padding(payloadSize);
        byte[] signature = RpmFileSignatureProcessor.safeReadBuffer(signatureBuf);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(signature);
        if (padding > 0) {
            result.write(RpmFileSignatureProcessor.safeReadBuffer(ByteBuffer.wrap(Rpms.EMPTY_128, 0, padding)));
        }
        return result.toByteArray();
    }

    private static byte[] safeReadBuffer(ByteBuffer buf) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        while (buf.hasRemaining()) {
            result.write(buf.get());
        }
        return result.toByteArray();
    }

    private static List<SignatureProcessor> getSignatureProcessors(PGPPrivateKey privateKey, HashAlgorithm hashAlgorithm) {
        ArrayList<SignatureProcessor> signatureProcessors = new ArrayList<SignatureProcessor>();
        signatureProcessors.add(SignatureProcessors.size());
        signatureProcessors.add(SignatureProcessors.sha256Header());
        signatureProcessors.add(SignatureProcessors.sha1Header());
        signatureProcessors.add(SignatureProcessors.md5());
        signatureProcessors.add(SignatureProcessors.payloadSize());
        signatureProcessors.add(new RsaSignatureProcessor(privateKey, hashAlgorithm));
        return signatureProcessors;
    }

    private static PGPPrivateKey getPrivateKey(InputStream privateKeyIn, String passphrase) throws PGPException, IOException {
        ArmoredInputStream armor = new ArmoredInputStream(privateKeyIn);
        BcPGPSecretKeyRing secretKeyRing = new BcPGPSecretKeyRing((InputStream)armor);
        PGPSecretKey secretKey = secretKeyRing.getSecretKey();
        return secretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(passphrase.toCharArray()));
    }
}

