/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.common.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.packet.MqttAck;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.util.CountingInputStream;

public class MqttPubAck
extends MqttAck {
    private static final int[] validReturnCodes;
    private static final Byte[] validProperties;
    private MqttProperties properties;

    static {
        int[] nArray = new int[8];
        nArray[1] = 16;
        nArray[2] = 128;
        nArray[3] = 131;
        nArray[4] = 135;
        nArray[5] = 144;
        nArray[6] = 151;
        nArray[7] = 153;
        validReturnCodes = nArray;
        validProperties = new Byte[]{(byte)31, (byte)38};
    }

    public MqttPubAck(byte[] data) throws IOException, MqttException {
        super((byte)4);
        this.properties = new MqttProperties(validProperties);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        CountingInputStream counter = new CountingInputStream(bais);
        DataInputStream dis = new DataInputStream(counter);
        this.msgId = dis.readUnsignedShort();
        long remainder = (long)data.length - (long)counter.getCounter();
        if (remainder >= 1L) {
            this.reasonCode = dis.readUnsignedByte();
            this.validateReturnCode(this.reasonCode, validReturnCodes);
        } else {
            this.reasonCode = 0;
        }
        if (remainder >= 4L) {
            this.properties.decodeProperties(dis);
        }
        dis.close();
    }

    public MqttPubAck(int returnCode, int msgId, MqttProperties properties) throws MqttException {
        super((byte)4);
        this.reasonCode = returnCode;
        this.msgId = msgId;
        this.properties = properties != null ? properties : new MqttProperties();
        this.properties.setValidProperties(validProperties);
        this.validateReturnCode(returnCode, validReturnCodes);
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            outputStream.writeShort(this.msgId);
            byte[] identifierValueFieldsByteArray = this.properties.encodeProperties();
            if (this.reasonCode != 0 && identifierValueFieldsByteArray.length == 1) {
                outputStream.write((byte)this.reasonCode);
            } else if (this.reasonCode != 0 || identifierValueFieldsByteArray.length > 1) {
                outputStream.write((byte)this.reasonCode);
                outputStream.write(identifierValueFieldsByteArray);
            }
            outputStream.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    public int getReturnCode() {
        return this.reasonCode;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "MqttPubAck [returnCode=" + this.reasonCode + ", properties=" + this.properties + "]";
    }
}

