/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionMemberExpression
extends AbstractExpression {
    private AbstractExpression collectionValuedPathExpression;
    private AbstractExpression entityExpression;
    private boolean hasSpaceAfterMember;
    private boolean hasSpaceAfterOf;
    private String memberIdentifier;
    private String notIdentifier;
    private String ofIdentifier;

    public CollectionMemberExpression(AbstractExpression parent, AbstractExpression expression) {
        super(parent);
        if (expression != null) {
            this.entityExpression = expression;
            this.entityExpression.setParent(this);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getEntityExpression().accept(visitor);
        this.getCollectionValuedPathExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getEntityExpression());
        children.add(this.getCollectionValuedPathExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.entityExpression != null) {
            children.add(this.entityExpression);
        }
        if (this.notIdentifier != null) {
            if (this.hasEntityExpression()) {
                children.add(this.buildStringExpression(' '));
            }
            children.add(this.buildStringExpression("NOT"));
        }
        if (this.notIdentifier != null || this.hasEntityExpression()) {
            children.add(this.buildStringExpression(' '));
        }
        children.add(this.buildStringExpression("MEMBER"));
        if (this.hasSpaceAfterMember) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.ofIdentifier != null) {
            children.add(this.buildStringExpression("OF"));
        }
        if (this.hasSpaceAfterOf) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.collectionValuedPathExpression != null) {
            children.add(this.collectionValuedPathExpression);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.entityExpression != null && this.entityExpression.isAncestor(expression)) {
            return this.getQueryBNF("entity_expression");
        }
        if (this.collectionValuedPathExpression != null && this.collectionValuedPathExpression.isAncestor(expression)) {
            return this.getQueryBNF("collection_valued_path_expression");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualMemberIdentifier() {
        return this.memberIdentifier;
    }

    public String getActualNotIdentifier() {
        return this.notIdentifier != null ? this.notIdentifier : "";
    }

    public String getActualOfIdentifier() {
        return this.ofIdentifier != null ? this.ofIdentifier : "";
    }

    public Expression getCollectionValuedPathExpression() {
        if (this.collectionValuedPathExpression == null) {
            this.collectionValuedPathExpression = this.buildNullExpression();
        }
        return this.collectionValuedPathExpression;
    }

    public Expression getEntityExpression() {
        if (this.entityExpression == null) {
            this.entityExpression = this.buildNullExpression();
        }
        return this.entityExpression;
    }

    public String getIdentifier() {
        if (this.notIdentifier != null && this.ofIdentifier != null) {
            return "NOT MEMBER OF";
        }
        if (this.notIdentifier != null) {
            return "NOT MEMBER";
        }
        if (this.ofIdentifier != null) {
            return "MEMBER OF";
        }
        return "MEMBER";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("collection_member_expression");
    }

    public boolean hasCollectionValuedPathExpression() {
        return this.collectionValuedPathExpression != null && !this.collectionValuedPathExpression.isNull();
    }

    public boolean hasEntityExpression() {
        return this.entityExpression != null && !this.entityExpression.isNull();
    }

    public boolean hasNot() {
        return this.notIdentifier != null;
    }

    public boolean hasOf() {
        return this.ofIdentifier != null;
    }

    public boolean hasSpaceAfterMember() {
        return this.hasSpaceAfterMember;
    }

    public boolean hasSpaceAfterOf() {
        return this.hasSpaceAfterOf;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        if (wordParser.startsWithIgnoreCase('N')) {
            this.notIdentifier = wordParser.moveForward("NOT");
            wordParser.skipLeadingWhitespace();
        }
        this.memberIdentifier = wordParser.moveForward("MEMBER");
        boolean bl = this.hasSpaceAfterMember = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("OF")) {
            this.ofIdentifier = wordParser.moveForward("OF");
            this.hasSpaceAfterOf = wordParser.skipLeadingWhitespace() > 0;
        }
        this.collectionValuedPathExpression = this.parse(wordParser, "collection_valued_path_expression", tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.entityExpression != null) {
            this.entityExpression.toParsedText(writer, actual);
        }
        if (this.notIdentifier != null) {
            if (this.hasEntityExpression()) {
                writer.append(' ');
            }
            writer.append(actual ? this.notIdentifier : "NOT");
        }
        if (this.notIdentifier != null || this.hasEntityExpression()) {
            writer.append(' ');
        }
        writer.append(actual ? this.memberIdentifier : "MEMBER");
        if (this.hasSpaceAfterMember) {
            writer.append(' ');
        }
        if (this.ofIdentifier != null) {
            writer.append(actual ? this.ofIdentifier : "OF");
        }
        if (this.hasSpaceAfterOf) {
            writer.append(' ');
        }
        if (this.collectionValuedPathExpression != null) {
            this.collectionValuedPathExpression.toParsedText(writer, actual);
        }
    }
}

