/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.exceptions;

import javax.ws.rs.core.Response;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class JPARSException
extends EclipseLinkException {
    private Response.Status httpStatusCode;

    public JPARSException() {
    }

    @Override
    public String getMessage() {
        return super.getUnformattedMessage();
    }

    public Response.Status getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(Response.Status httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public JPARSException(String message) {
        super(message);
    }

    private JPARSException(String msg, Throwable internalException) {
        super(msg, internalException);
    }

    public static JPARSException entityNotFound(String entityType, String entityId, String persistenceUnit) {
        Object[] args = new Object[]{entityType, entityId, persistenceUnit};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61000, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61000);
        exception.setHttpStatusCode(Response.Status.NOT_FOUND);
        return exception;
    }

    public static JPARSException classOrClassDescriptorCouldNotBeFoundForEntity(String entityType, String persistenceUnit) {
        Object[] args = new Object[]{entityType, persistenceUnit};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61005, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61005);
        exception.setHttpStatusCode(Response.Status.NOT_FOUND);
        return exception;
    }

    public static JPARSException attributeCouldNotBeFoundForEntity(String attributeName, String entityType, String entityId, String persistenceUnit) {
        Object[] args = new Object[]{attributeName, entityType, entityId, persistenceUnit};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61007, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61007);
        exception.setHttpStatusCode(Response.Status.NOT_FOUND);
        return exception;
    }

    public static JPARSException selectionQueryForAttributeCouldNotBeFoundForEntity(String attributeName, String entityType, String entityId, String persistenceUnit) {
        Object[] args = new Object[]{attributeName, entityType, entityId, persistenceUnit};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61008, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61008);
        exception.setHttpStatusCode(Response.Status.NOT_FOUND);
        return exception;
    }

    public static JPARSException invalidPagingRequest() {
        Object[] args = new Object[]{};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61009, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61009);
        exception.setHttpStatusCode(Response.Status.BAD_REQUEST);
        return exception;
    }

    public static JPARSException invalidParameter(String parameterName, String invalidValue) {
        Object[] args = new Object[]{parameterName, invalidValue};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61018, args);
        AbstractSessionLog.getLog().info(msg);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61018);
        exception.setHttpStatusCode(Response.Status.BAD_REQUEST);
        return exception;
    }

    public static JPARSException paginationParameterForNotPageableResource() {
        Object[] args = new Object[]{};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61016, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61016);
        exception.setHttpStatusCode(Response.Status.BAD_REQUEST);
        return exception;
    }

    public static JPARSException fieldsFilteringBothParametersPresent() {
        Object[] args = new Object[]{};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61017, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61017);
        exception.setHttpStatusCode(Response.Status.BAD_REQUEST);
        return exception;
    }

    public static JPARSException databaseMappingCouldNotBeFoundForEntityAttribute(String attributeName, String entityType, String entityId, String persistenceUnit) {
        Object[] args = new Object[]{attributeName, entityType, entityId, persistenceUnit};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61006, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61006);
        exception.setHttpStatusCode(Response.Status.NOT_FOUND);
        return exception;
    }

    public static JPARSException attributeCouldNotBeUpdated(String attributeName, String entityType, String entityId, String persistenceUnit) {
        Object[] args = new Object[]{attributeName, entityType, entityId, persistenceUnit};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61010, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61010);
        exception.setHttpStatusCode(Response.Status.INTERNAL_SERVER_ERROR);
        return exception;
    }

    public static JPARSException invalidServiceVersion(String serviceVersion) {
        Object[] args = new Object[]{serviceVersion};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61015, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61015);
        exception.setHttpStatusCode(Response.Status.BAD_REQUEST);
        return exception;
    }

    public static JPARSException invalidRemoveAttributeRequest(String attributeName, String entityType, String entityId, String persistenceUnit) {
        Object[] args = new Object[]{entityType, entityId, persistenceUnit};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61011, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61011);
        exception.setHttpStatusCode(Response.Status.BAD_REQUEST);
        return exception;
    }

    public static JPARSException responseCouldNotBeBuiltForFindAttributeRequest(String attributeName, String entityType, String entityId, String persistenceUnit) {
        Object[] args = new Object[]{entityType, entityId, persistenceUnit};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61012, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61012);
        exception.setHttpStatusCode(Response.Status.INTERNAL_SERVER_ERROR);
        return exception;
    }

    public static JPARSException responseCouldNotBeBuiltForNamedQueryRequest(String query, String persistenceUnit) {
        Object[] args = new Object[]{query, persistenceUnit};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61014, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61014);
        exception.setHttpStatusCode(Response.Status.INTERNAL_SERVER_ERROR);
        return exception;
    }

    public static JPARSException objectReferredByLinkDoesNotExist(String entityType, Object entityId) {
        Object[] args = new Object[]{entityType, entityId};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61001, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61001);
        exception.setHttpStatusCode(Response.Status.NOT_FOUND);
        return exception;
    }

    public static JPARSException sessionBeanCouldNotBeFound(String jndiName) {
        Object[] args = new Object[]{jndiName};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61013, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61013);
        exception.setHttpStatusCode(Response.Status.NOT_FOUND);
        return exception;
    }

    public static JPARSException invalidConfiguration() {
        Object[] args = new Object[]{};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61002, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61002);
        exception.setHttpStatusCode(Response.Status.INTERNAL_SERVER_ERROR);
        return exception;
    }

    public static JPARSException entityIsNotIdempotent(String entityType, String persistenceUnit) {
        Object[] args = new Object[]{entityType, persistenceUnit};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61003, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61003);
        exception.setHttpStatusCode(Response.Status.BAD_REQUEST);
        return exception;
    }

    public static JPARSException persistenceContextCouldNotBeBootstrapped(String persistenceUnit) {
        Object[] args = new Object[]{persistenceUnit, persistenceUnit};
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, 61004, args);
        JPARSException exception = new JPARSException(msg);
        exception.setErrorCode(61004);
        exception.setHttpStatusCode(Response.Status.INTERNAL_SERVER_ERROR);
        return exception;
    }

    public static JPARSException exceptionOccurred(Exception exception) {
        if (exception instanceof JPARSException) {
            return (JPARSException)exception;
        }
        int errorCode = 61999;
        String msg = ExceptionMessageGenerator.buildMessage(JPARSException.class, errorCode, new Object[]{exception.getClass().getSimpleName()}).trim();
        if (exception instanceof EclipseLinkException) {
            errorCode = ((EclipseLinkException)exception).getErrorCode();
            msg = ((EclipseLinkException)exception).getClass().getName().trim();
        } else if (exception.getCause() instanceof EclipseLinkException) {
            errorCode = ((EclipseLinkException)exception.getCause()).getErrorCode();
            msg = ((EclipseLinkException)exception.getCause()).getClass().getName().trim();
        }
        JPARSException jparsException = new JPARSException(msg, exception);
        jparsException.setErrorCode(errorCode);
        jparsException.setInternalException(exception);
        return jparsException;
    }
}

