/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateCollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.structures.ArrayCollectionMapping;
import org.eclipse.persistence.mappings.structures.ArrayCollectionMappingHelper;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public abstract class AbstractCompositeCollectionMapping
extends AggregateMapping
implements ContainerMapping,
ArrayCollectionMapping {
    protected DatabaseField field;
    private ContainerPolicy containerPolicy = ContainerPolicy.buildDefaultPolicy();
    protected Converter converter;

    @Override
    public Object buildAddedElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        return this.buildElementFromChangeSet(changeSet, mergeManager, targetSession);
    }

    @Override
    protected Object buildBackupClonePart(Object attributeValue, UnitOfWorkImpl unitOfWork) {
        ContainerPolicy cp = this.getContainerPolicy();
        if (attributeValue == null) {
            return cp.containerInstance();
        }
        Object backupAttributeValue = cp.containerInstance(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            Object backupElement = super.buildBackupClonePart(cp.next(iter, unitOfWork), unitOfWork);
            cp.addInto(backupElement, backupAttributeValue, unitOfWork);
        }
        return backupAttributeValue;
    }

    @Override
    public Object buildChangeSet(Object element, ObjectChangeSet owner, AbstractSession session) {
        ObjectBuilder objectBuilder = this.getObjectBuilder(element, session);
        return objectBuilder.compareForChange(element, null, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
    }

    @Override
    protected Object buildClonePart(Object original, Object clone, CacheKey cacheKey, Object attributeValue, Integer refreshCascade, AbstractSession clonningSession) {
        ContainerPolicy cp = this.getContainerPolicy();
        if (attributeValue == null) {
            return cp.containerInstance();
        }
        Object clonedAttributeValue = cp.containerInstance(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            Object cloneElement = super.buildClonePart(original, clone, cacheKey, cp.next(iter, clonningSession), refreshCascade, clonningSession);
            cp.addInto(cloneElement, clonedAttributeValue, clonningSession);
        }
        return clonedAttributeValue;
    }

    @Override
    protected Object buildCopyOfAttributeValue(Object attributeValue, CopyGroup group) {
        ContainerPolicy cp = this.getContainerPolicy();
        if (attributeValue == null) {
            return cp.containerInstance();
        }
        Object attributeValueCopy = cp.containerInstance(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            Object copyElement = super.buildCopyOfAttributeValue(cp.next(iter, group.getSession()), group);
            cp.addInto(copyElement, attributeValueCopy, group.getSession());
        }
        return attributeValueCopy;
    }

    protected Object buildElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)changeSet;
        ObjectBuilder objectBuilder = this.getObjectBuilderForClass(objectChangeSet.getClassType(mergeManager.getSession()), mergeManager.getSession());
        Object result = objectBuilder.buildNewInstance();
        objectBuilder.mergeChangesIntoObject(result, objectChangeSet, null, mergeManager, targetSession);
        return result;
    }

    @Override
    public Object buildElementFromElement(Object element, MergeManager mergeManager, AbstractSession targetSession) {
        ObjectBuilder objectBuilder = this.getObjectBuilder(element, mergeManager.getSession());
        Object result = objectBuilder.buildNewInstance();
        objectBuilder.mergeIntoObject(result, true, element, mergeManager, targetSession);
        return result;
    }

    @Override
    public Expression buildExpression(Object queryObject, QueryByExamplePolicy policy, Expression expressionBuilder, Map processedObjects, AbstractSession session) {
        if (policy.shouldValidateExample()) {
            throw QueryException.unsupportedMappingQueryByExample(queryObject.getClass().getName(), this);
        }
        return null;
    }

    @Override
    public Object buildRemovedElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        return this.buildElementFromChangeSet(changeSet, mergeManager, targetSession);
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object objectToCascadeOn = cp.next(cloneIter, uow);
            if (objectToCascadeOn == null || visitedObjects.containsKey(objectToCascadeOn)) continue;
            visitedObjects.put(objectToCascadeOn, objectToCascadeOn);
            ObjectBuilder builder = this.getReferenceDescriptor(objectToCascadeOn.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadePerformRemove(objectToCascadeOn, uow, visitedObjects);
        }
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow, Set cascadeErrors) {
        Object cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object iterator = containerPolicy.iteratorFor(cloneObjectCollection);
        while (containerPolicy.hasNext(iterator)) {
            Object nextObject = containerPolicy.next(iterator, uow);
            if (nextObject == null) continue;
            ObjectBuilder builder = this.getReferenceDescriptor(nextObject.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadeDiscoverAndPersistUnregisteredNewObjects(nextObject, newObjects, unregisteredExistingObjects, visitedObjects, uow, cascadeErrors);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null) {
            return;
        }
        ObjectBuilder builder = null;
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object nextObject = cp.next(cloneIter, uow);
            if (nextObject == null || visitedObjects.containsKey(nextObject)) continue;
            visitedObjects.put(nextObject, nextObject);
            builder = this.getReferenceDescriptor(nextObject.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadeRegisterNewForCreate(nextObject, uow, visitedObjects);
        }
    }

    protected Vector collectFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(1);
        fields.addElement(this.getField());
        return fields;
    }

    @Override
    public boolean compareElements(Object element1, Object element2, AbstractSession session) {
        if (element1.getClass() != element2.getClass()) {
            return false;
        }
        return this.getObjectBuilder(element1, session).compareObjects(element1, element2, session);
    }

    @Override
    public boolean compareElementsForChange(Object element1, Object element2, AbstractSession session) {
        return this.compareElements(element1, element2, session);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        this.containerPolicy.convertClassNamesToClasses(classLoader);
    }

    protected ChangeRecord convertToChangeRecord(Object cloneCollection, ObjectChangeSet owner, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneIter = cp.iteratorFor(cloneCollection);
        Vector<ObjectChangeSet> collectionChanges = new Vector<ObjectChangeSet>(2);
        while (cp.hasNext(cloneIter)) {
            Object aggregateObject = cp.next(cloneIter, session);
            if (aggregateObject == null) continue;
            ObjectChangeSet changes = this.getReferenceDescriptor(aggregateObject.getClass(), session).getObjectBuilder().compareForChange(aggregateObject, null, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
            collectionChanges.addElement(changes);
        }
        AggregateCollectionChangeRecord changeRecord = new AggregateCollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.setChangedValues(collectionChanges);
        return changeRecord;
    }

    @Override
    protected void fixAttributeValue(Object attributeValue, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, DistributedSession session) {
        if (attributeValue == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            super.fixAttributeValue(cp.next(iter, session), objectDescriptors, processedObjects, query, session);
        }
    }

    @Override
    protected Object getAttributeValueFromBackupClone(Object backupClone) {
        return null;
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public Converter getConverter() {
        return this.converter;
    }

    @Override
    public DatabaseField getField() {
        return this.field;
    }

    @Override
    public Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession session) throws DescriptorException {
        Object value = this.getRealAttributeValueFromObject(object, session);
        if (value == null) {
            value = this.getContainerPolicy().containerInstance(1);
        }
        return value;
    }

    protected String getStructureName() {
        return "";
    }

    public boolean hasConverter() {
        return this.getConverter() != null;
    }

    @Override
    public boolean isAbstractCompositeCollectionMapping() {
        return true;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getField() == null) {
            throw DescriptorException.fieldNameNotSetInMapping(this);
        }
        this.setField(this.getDescriptor().buildField(this.getField()));
        this.setFields(this.collectFields());
        if (this.hasConverter()) {
            this.getConverter().initialize(this, session);
        }
    }

    @Override
    protected void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object attributeValue) {
        if (attributeValue == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            super.iterateOnAttributeValue(descriptorIterator, cp.next(iter, descriptorIterator.getSession()));
        }
    }

    @Override
    public boolean mapKeyHasChanged(Object element, AbstractSession session) {
        return false;
    }

    @Override
    public void postDeleteAttributeValue(DeleteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            super.postDeleteAttributeValue(query, cp.next(iter, query.getSession()));
        }
    }

    @Override
    public void postInsertAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            super.postInsertAttributeValue(query, cp.next(iter, query.getSession()));
        }
    }

    @Override
    public void postUpdateAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            super.postUpdateAttributeValue(query, cp.next(iter, query.getSession()));
        }
    }

    @Override
    public void preDeleteAttributeValue(DeleteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            super.preDeleteAttributeValue(query, cp.next(iter, query.getSession()));
        }
    }

    @Override
    public void preInsertAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            super.preInsertAttributeValue(query, cp.next(iter, query.getSession()));
        }
    }

    @Override
    public void preUpdateAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            super.preUpdateAttributeValue(query, cp.next(iter, query.getSession()));
        }
    }

    @Override
    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setField(DatabaseField field) {
        this.field = field;
    }

    @Override
    public void useCollectionClass(Class concreteContainerClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteContainerClass));
    }

    @Override
    public void useCollectionClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteContainerClassName));
    }

    @Override
    public void useListClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new ListContainerPolicy(concreteContainerClassName));
    }

    @Override
    public void useMapClass(Class concreteContainerClass, String methodName) {
        if (this.getReferenceClassName() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteContainerClass);
        policy.setKeyName(methodName, this.getReferenceClass());
        this.setContainerPolicy(policy);
    }

    @Override
    public void useMapClassName(String concreteContainerClassName, String methodName) {
        if (this.getReferenceClassName() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        MapContainerPolicy policy = new MapContainerPolicy(concreteContainerClassName);
        policy.setKeyName(methodName, this.getReferenceClass().getName());
        this.setContainerPolicy(policy);
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        if (this.descriptor.getCachePolicy().isProtectedIsolation()) {
            if (this.isCacheable && isTargetProtected && cacheKey != null) {
                Object result = null;
                Object cached = cacheKey.getObject();
                if (cached != null) {
                    if (wasCacheUsed != null) {
                        wasCacheUsed[0] = Boolean.TRUE;
                    }
                    Object attributeValue = this.getAttributeValueFromObject(cached);
                    Integer refreshCascade = null;
                    if (sourceQuery != null && sourceQuery.isObjectBuildingQuery() && sourceQuery.shouldRefreshIdentityMapResult()) {
                        refreshCascade = sourceQuery.getCascadePolicy();
                    }
                    return this.buildClonePart(cached, null, cacheKey, attributeValue, refreshCascade, executionSession);
                }
                return result;
            }
            if (!this.isCacheable && !isTargetProtected && cacheKey != null) {
                return null;
            }
        }
        if (row.hasSopObject()) {
            return this.getAttributeValueFromObject(row.getSopObject());
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object fieldValue = row.getValues(this.getField());
        if (fieldValue == null || fieldValue instanceof String) {
            return cp.containerInstance();
        }
        Vector nestedRows = this.getReferenceDescriptor().buildNestedRowsFromFieldValue(fieldValue, executionSession);
        if (nestedRows == null) {
            return cp.containerInstance();
        }
        Object result = cp.containerInstance(nestedRows.size());
        Enumeration stream = nestedRows.elements();
        while (stream.hasMoreElements()) {
            AbstractRecord nestedRow = (AbstractRecord)stream.nextElement();
            ClassDescriptor descriptor = this.getReferenceDescriptor();
            if (descriptor.hasInheritance()) {
                Class newElementClass = descriptor.getInheritancePolicy().classFromRow(nestedRow, executionSession);
                descriptor = this.getReferenceDescriptor(newElementClass, executionSession);
            }
            Object element = this.buildCompositeObject(descriptor, nestedRow, sourceQuery, cacheKey, joinManager, executionSession);
            if (this.hasConverter()) {
                element = this.getConverter().convertDataValueToObjectValue(element, executionSession);
            }
            cp.addInto(element, result, sourceQuery.getSession());
        }
        return result;
    }

    protected abstract Object buildCompositeObject(ClassDescriptor var1, AbstractRecord var2, ObjectBuildingQuery var3, CacheKey var4, JoinedAttributeManager var5, AbstractSession var6);

    @Override
    protected boolean verifyDeleteOfAttributeValue(Object attributeValue, AbstractSession session) throws DatabaseException {
        if (attributeValue == null) {
            return true;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            if (super.verifyDeleteOfAttributeValue(cp.next(iter, session), session)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Vector<AbstractRecord> nestedRows = new Vector<AbstractRecord>(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            Object element = cp.next(iter, session);
            if (this.hasConverter()) {
                element = this.getConverter().convertObjectValueToDataValue(element, session);
            }
            nestedRows.addElement(this.buildCompositeRow(element, session, row, writeType));
        }
        Object fieldValue = null;
        if (!nestedRows.isEmpty()) {
            fieldValue = this.getReferenceDescriptor().buildFieldValueFromNestedRows(nestedRows, this.getStructureName(), session);
        }
        row.put(this.getField(), fieldValue);
    }

    protected abstract AbstractRecord buildCompositeRow(Object var1, AbstractSession var2, AbstractRecord var3, DatabaseMapping.WriteType var4);

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeQuery, AbstractRecord row) throws DescriptorException {
        AbstractSession session = writeQuery.getSession();
        if (session.isClassReadOnly(this.getReferenceClass())) {
            return;
        }
        if (session.isUnitOfWork() && this.compareObjects(writeQuery.getObject(), writeQuery.getBackupClone(), session)) {
            return;
        }
        this.writeFromObjectIntoRow(writeQuery.getObject(), row, session, DatabaseMapping.WriteType.UPDATE);
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        this.writeFromObjectIntoRow(object, row, session, writeType);
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        record.put(this.getField(), (Object)null);
    }

    @Override
    public boolean isCollectionMapping() {
        return true;
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        return new ArrayCollectionMappingHelper(this).compareForChange(clone, backup, owner, session);
    }

    @Override
    public boolean compareObjects(Object object1, Object object2, AbstractSession session) {
        return new ArrayCollectionMappingHelper(this).compareObjects(object1, object2, session);
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        new ArrayCollectionMappingHelper(this).mergeChangesIntoObject(target, changeRecord, source, mergeManager, targetSession);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        new ArrayCollectionMappingHelper(this).mergeIntoObject(target, isTargetUnInitialized, source, mergeManager, targetSession);
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        new ArrayCollectionMappingHelper(this).simpleAddToCollectionChangeRecord(referenceKey, changeSetToAdd, changeSet, session);
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        new ArrayCollectionMappingHelper(this).simpleRemoveFromCollectionChangeRecord(referenceKey, changeSetToRemove, changeSet, session);
    }

    public Object createMapComponentFromRow(AbstractRecord dbRow, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        return this.valueFromRow(dbRow, null, query, parentCacheKey, query.getExecutionSession(), isTargetProtected, null);
    }
}

