/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.core.sessions.CoreProject;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.MultitenantPolicy;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.internal.helper.ConcurrentFixedCache;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.AbstractIdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.queries.SQLResultSetMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;

public class Project
extends CoreProject<ClassDescriptor, Login, DatabaseSession>
implements Serializable,
Cloneable {
    protected String name = "";
    protected Login datasourceLogin;
    protected Map<Class<?>, ClassDescriptor> descriptors;
    protected List<ClassDescriptor> orderedDescriptors;
    protected MultitenantPolicy multitenantPolicy;
    protected Vector<Class<?>> defaultReadOnlyClasses;
    protected Map<String, ClassDescriptor> aliasDescriptors;
    protected boolean hasIsolatedClasses = false;
    protected boolean hasNonIsolatedUOWClasses;
    protected boolean hasGenericHistorySupport = false;
    protected boolean hasProxyIndirection = false;
    protected Map<String, SQLResultSetMapping> sqlResultSetMappings;
    protected transient ConcurrentFixedCache jpqlParseCache;
    protected boolean defaultTemporalMutable = false;
    protected transient boolean hasMappingsPostCalculateChangesOnDeleted = false;
    protected Class<? extends IdentityMap> defaultIdentityMapClass = AbstractIdentityMap.getDefaultIdentityMapClass();
    protected int defaultIdentityMapSize = 100;
    protected CacheIsolationType defaultCacheIsolation;
    protected QueryResultsCachePolicy defaultQueryResultsCachePolicy;
    protected IdValidation defaultIdValidation;
    protected List<DatabaseQuery> queries;
    protected Map<String, AttributeGroup> attributeGroups = null;
    protected List<DatabaseQuery> jpaQueries;
    protected List<DatabaseQuery> jpaTablePerTenantQueries;
    protected boolean allowNativeSQLQueries = true;
    protected boolean allowTablePerMultitenantDDLGeneration = false;
    protected boolean allowSQLDeferral = true;
    protected boolean namingIntoIndexed = false;
    protected boolean allowExtendedCacheLogging = false;
    protected boolean allowExtendedThreadLogging = false;
    protected boolean allowExtendedThreadLoggingThreadDump = false;
    protected Map<String, ClassDescriptor> mappedSuperclassDescriptors;
    protected Map<String, List<String>> metamodelIdClassMap;
    protected Map<String, PartitioningPolicy> partitioningPolicies;
    protected Object descriptorsLock = Boolean.TRUE;
    protected String vpdIdentifier;
    protected String vpdLastIdentifierClassName;
    protected Collection<String> classNamesForWeaving;
    protected Collection<String> structConverters;
    protected boolean queryCacheForceDeferredLocks = false;

    public Project() {
        this.descriptors = new HashMap();
        this.defaultReadOnlyClasses = NonSynchronizedVector.newInstance();
        this.orderedDescriptors = new ArrayList<ClassDescriptor>();
        this.jpqlParseCache = new ConcurrentFixedCache(200);
        this.queries = new ArrayList<DatabaseQuery>();
        this.mappedSuperclassDescriptors = new HashMap<String, ClassDescriptor>(2);
        this.metamodelIdClassMap = new HashMap<String, List<String>>();
        this.attributeGroups = new HashMap<String, AttributeGroup>();
    }

    public Project(Login login) {
        this();
        this.datasourceLogin = login;
    }

    public Project(DatabaseLogin login) {
        this();
        this.datasourceLogin = login;
    }

    public QueryResultsCachePolicy getDefaultQueryResultsCachePolicy() {
        return this.defaultQueryResultsCachePolicy;
    }

    public void setDefaultQueryResultsCachePolicy(QueryResultsCachePolicy defaultQueryResultsCachePolicy) {
        this.defaultQueryResultsCachePolicy = defaultQueryResultsCachePolicy;
    }

    public boolean isQueryCacheForceDeferredLocks() {
        return this.queryCacheForceDeferredLocks;
    }

    public void setQueryCacheForceDeferredLocks(boolean queryCacheForceDeferredLocks) {
        this.queryCacheForceDeferredLocks = queryCacheForceDeferredLocks;
    }

    public boolean getDefaultTemporalMutable() {
        return this.defaultTemporalMutable;
    }

    public void setDefaultTemporalMutable(boolean defaultTemporalMutable) {
        this.defaultTemporalMutable = defaultTemporalMutable;
    }

    public List<DatabaseQuery> getJPAQueries() {
        if (this.jpaQueries == null) {
            this.jpaQueries = new ArrayList<DatabaseQuery>();
        }
        return this.jpaQueries;
    }

    public List<DatabaseQuery> getJPATablePerTenantQueries() {
        if (this.jpaTablePerTenantQueries == null) {
            this.jpaTablePerTenantQueries = new ArrayList<DatabaseQuery>();
        }
        return this.jpaTablePerTenantQueries;
    }

    public ConcurrentFixedCache getJPQLParseCache() {
        if (this.jpqlParseCache == null) {
            this.jpqlParseCache = new ConcurrentFixedCache(200);
        }
        return this.jpqlParseCache;
    }

    public void setJPQLParseCacheMaxSize(int maxSize) {
        this.setJPQLParseCache(new ConcurrentFixedCache(maxSize));
    }

    public int getJPQLParseCacheMaxSize() {
        return this.getJPQLParseCache().getMaxSize();
    }

    protected void setJPQLParseCache(ConcurrentFixedCache jpqlParseCache) {
        this.jpqlParseCache = jpqlParseCache;
    }

    public List<DatabaseQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<DatabaseQuery> queries) {
        this.queries = queries;
    }

    public Map<String, AttributeGroup> getAttributeGroups() {
        return this.attributeGroups;
    }

    public void setVPDIdentifier(String vpdIdentifier) {
        this.vpdIdentifier = vpdIdentifier;
    }

    public void setVPDLastIdentifierClassName(String vpdLastIdentifierClassName) {
        this.vpdLastIdentifierClassName = vpdLastIdentifierClassName;
    }

    public void addDefaultReadOnlyClass(Class<?> readOnlyClass) {
        this.getDefaultReadOnlyClasses().addElement(readOnlyClass);
    }

    @Override
    public void addDescriptor(ClassDescriptor descriptor) {
        this.getOrderedDescriptors().add(descriptor);
        String alias = descriptor.getAlias();
        if (alias != null) {
            this.addAlias(alias, descriptor);
        }
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptor(ClassDescriptor descriptor, DatabaseSessionImpl session) {
        Object object = this.descriptorsLock;
        synchronized (object) {
            if (session.isConnected()) {
                String alias = descriptor.getAlias();
                if (alias != null) {
                    HashMap<String, ClassDescriptor> aliasDescriptorsClone = this.getAliasDescriptors() != null ? (Map)((HashMap)this.getAliasDescriptors()).clone() : new HashMap<String, ClassDescriptor>();
                    aliasDescriptorsClone.put(alias, descriptor);
                    this.setAliasDescriptors(aliasDescriptorsClone);
                }
                Map descriptorsClone = (Map)((HashMap)this.getDescriptors()).clone();
                descriptorsClone.put(descriptor.getJavaClass(), descriptor);
                this.setDescriptors(descriptorsClone);
                session.copyDescriptorsFromProject();
                session.initializeDescriptorIfSessionAlive(descriptor);
                this.getOrderedDescriptors().add(descriptor);
            } else {
                this.addDescriptor(descriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptors(Collection descriptors, DatabaseSessionImpl session) {
        Object object = this.descriptorsLock;
        synchronized (object) {
            if (session.isConnected()) {
                HashMap<String, ClassDescriptor> aliasDescriptorsClone = this.getAliasDescriptors() != null ? (Map)((HashMap)this.getAliasDescriptors()).clone() : new HashMap<String, ClassDescriptor>();
                Map descriptorsClone = (Map)((HashMap)this.getDescriptors()).clone();
                for (ClassDescriptor descriptor : descriptors) {
                    descriptorsClone.put(descriptor.getJavaClass(), descriptor);
                    String alias = descriptor.getAlias();
                    if (alias == null) continue;
                    aliasDescriptorsClone.put(alias, descriptor);
                }
                if (!aliasDescriptorsClone.isEmpty()) {
                    this.setAliasDescriptors(aliasDescriptorsClone);
                }
                this.setDescriptors(descriptorsClone);
                session.copyDescriptorsFromProject();
                session.initializeDescriptors(descriptors);
            } else {
                Map<Class<?>, ClassDescriptor> projectDescriptors = this.getDescriptors();
                for (ClassDescriptor descriptor : descriptors) {
                    String alias = descriptor.getAlias();
                    projectDescriptors.put(descriptor.getJavaClass(), descriptor);
                    if (alias == null) continue;
                    this.addAlias(alias, descriptor);
                }
            }
            this.getOrderedDescriptors().addAll(descriptors);
        }
    }

    public void addDescriptors(Project project, DatabaseSessionImpl session) {
        this.addDescriptors(project.getDescriptors().values(), session);
    }

    public void addSQLResultSetMapping(SQLResultSetMapping sqlResultSetMapping) {
        if (sqlResultSetMapping == null || sqlResultSetMapping.getName() == null) {
            return;
        }
        if (this.sqlResultSetMappings == null) {
            this.sqlResultSetMappings = new HashMap<String, SQLResultSetMapping>();
        }
        this.sqlResultSetMappings.put(sqlResultSetMapping.getName(), sqlResultSetMapping);
    }

    public void conformAllDescriptors() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.setShouldAlwaysConformResultsInUnitOfWork(true);
        }
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        for (ClassDescriptor descriptor : this.orderedDescriptors) {
            descriptor.convertClassNamesToClasses(classLoader);
        }
        for (AttributeGroup group : this.getAttributeGroups().values()) {
            group.convertClassNamesToClasses(classLoader);
        }
        this.descriptors = new HashMap();
        if (this.sqlResultSetMappings != null) {
            for (SQLResultSetMapping mapping : this.sqlResultSetMappings.values()) {
                mapping.convertClassNamesToClasses(classLoader);
            }
        }
        if (this.partitioningPolicies != null) {
            for (PartitioningPolicy policy : this.partitioningPolicies.values()) {
                policy.convertClassNamesToClasses(classLoader);
            }
        }
    }

    public void assumeExistenceForDoesExist() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.getQueryManager().assumeExistenceForDoesExist();
        }
    }

    public void checkCacheForDoesExist() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.getQueryManager().checkCacheForDoesExist();
        }
    }

    public void checkDatabaseForDoesExist() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.getQueryManager().checkDatabaseForDoesExist();
        }
    }

    public Project clone() {
        try {
            return (Project)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
    }

    @Override
    public DatabaseSession createDatabaseSession() {
        return new DatabaseSessionImpl(this);
    }

    public Server createServerSession() {
        return new ServerSession(this);
    }

    public Server createServerSession(int min, int max) {
        return new ServerSession(this, min, max);
    }

    public Server createServerSession(int initial, int min, int max) {
        return new ServerSession(this, initial, min, max);
    }

    public Server createServerSession(ConnectionPolicy defaultConnectionPolicy) {
        return new ServerSession(this, defaultConnectionPolicy);
    }

    public Vector getDefaultReadOnlyClasses() {
        return this.defaultReadOnlyClasses;
    }

    public Class<? extends IdentityMap> getDefaultIdentityMapClass() {
        return this.defaultIdentityMapClass;
    }

    public int getDefaultIdentityMapSize() {
        return this.defaultIdentityMapSize;
    }

    public CacheIsolationType getDefaultCacheIsolation() {
        return this.defaultCacheIsolation;
    }

    public IdValidation getDefaultIdValidation() {
        return this.defaultIdValidation;
    }

    public ClassDescriptor getClassDescriptor(Class<?> theClass) {
        return this.getDescriptor((Class)theClass);
    }

    @Override
    public ClassDescriptor getDescriptor(Class<?> theClass) {
        if (theClass == null) {
            return null;
        }
        return this.getDescriptors().get(theClass);
    }

    public Map<Class<?>, ClassDescriptor> getDescriptors() {
        if (this.descriptors.isEmpty() && !this.orderedDescriptors.isEmpty()) {
            for (ClassDescriptor descriptor : this.orderedDescriptors) {
                this.descriptors.put(descriptor.getJavaClass(), descriptor);
            }
        }
        return this.descriptors;
    }

    @Override
    public List<ClassDescriptor> getOrderedDescriptors() {
        return this.orderedDescriptors;
    }

    public void setOrderedDescriptors(List<ClassDescriptor> orderedDescriptors) {
        this.orderedDescriptors = orderedDescriptors;
        for (ClassDescriptor descriptor : orderedDescriptors) {
            String alias = descriptor.getAlias();
            if (alias == null) continue;
            this.addAlias(alias, descriptor);
        }
    }

    public Collection<String> getClassNamesForWeaving() {
        return this.classNamesForWeaving;
    }

    public void setClassNamesForWeaving(Collection<String> classNamesForWeaving) {
        this.classNamesForWeaving = classNamesForWeaving;
    }

    public DatabaseLogin getLogin() {
        return (DatabaseLogin)this.datasourceLogin;
    }

    @Override
    public Login getDatasourceLogin() {
        return this.datasourceLogin;
    }

    public String getName() {
        return this.name;
    }

    public SQLResultSetMapping getSQLResultSetMapping(String sqlResultSetMapping) {
        if (sqlResultSetMapping == null || this.sqlResultSetMappings == null) {
            return null;
        }
        return this.sqlResultSetMappings.get(sqlResultSetMapping);
    }

    public Collection<String> getStructConverters() {
        return this.structConverters;
    }

    public void setStructConverters(Collection<String> structConverters) {
        this.structConverters = structConverters;
    }

    public String getVPDLastIdentifierClassName() {
        return this.vpdLastIdentifierClassName;
    }

    public String getVPDIdentifier() {
        return this.vpdIdentifier;
    }

    public MultitenantPolicy getMultitenantPolicy() {
        return this.multitenantPolicy;
    }

    public boolean hasGenericHistorySupport() {
        return this.hasGenericHistorySupport;
    }

    public void setDefaultReadOnlyClasses(Collection newValue) {
        this.defaultReadOnlyClasses = new Vector(newValue);
    }

    public void setDefaultIdentityMapClass(Class<? extends IdentityMap> defaultIdentityMapClass) {
        this.defaultIdentityMapClass = defaultIdentityMapClass;
    }

    public void setDefaultIdentityMapSize(int defaultIdentityMapSize) {
        this.defaultIdentityMapSize = defaultIdentityMapSize;
    }

    public void setDefaultCacheIsolation(CacheIsolationType isolationType) {
        this.defaultCacheIsolation = isolationType;
    }

    public void setDefaultIdValidation(IdValidation defaultIdValidation) {
        this.defaultIdValidation = defaultIdValidation;
    }

    public void setDescriptors(Map descriptors) {
        this.descriptors = descriptors;
        for (ClassDescriptor descriptor : descriptors.values()) {
            String alias = descriptor.getAlias();
            if (alias == null) continue;
            this.addAlias(alias, descriptor);
        }
    }

    public void setDeferModificationsUntilCommit(int deferralLevel) {
        for (ClassDescriptor descriptor : this.descriptors.values()) {
            if (descriptor.getCMPPolicy() == null) continue;
            descriptor.getCMPPolicy().setDeferModificationsUntilCommit(deferralLevel);
        }
    }

    public void setHasGenericHistorySupport(boolean hasGenericHistorySupport) {
        this.hasGenericHistorySupport = hasGenericHistorySupport;
    }

    public boolean hasIsolatedCacheClassWithoutUOWIsolation() {
        if (!this.hasIsolatedClasses) {
            return false;
        }
        for (ClassDescriptor descriptor : this.orderedDescriptors) {
            if (!descriptor.getCachePolicy().isIsolated() || descriptor.getCachePolicy().shouldIsolateObjectsInUnitOfWork()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIsolatedClasses() {
        return this.hasIsolatedClasses;
    }

    public void setHasIsolatedClasses(boolean hasIsolatedClasses) {
        this.hasIsolatedClasses = hasIsolatedClasses;
    }

    public boolean hasNonIsolatedUOWClasses() {
        return this.hasNonIsolatedUOWClasses;
    }

    public void setHasNonIsolatedUOWClasses(boolean hasNonIsolatedUOWClasses) {
        this.hasNonIsolatedUOWClasses = hasNonIsolatedUOWClasses;
    }

    public boolean hasProxyIndirection() {
        return this.hasProxyIndirection;
    }

    public boolean hasSQLResultSetMapping(String sqlResultSetMapping) {
        return this.sqlResultSetMappings.containsKey(sqlResultSetMapping);
    }

    public boolean hasVPDIdentifier(AbstractSession session) {
        return this.vpdIdentifier != null && session.getProperty(this.vpdIdentifier) != null;
    }

    public void setHasProxyIndirection(boolean hasProxyIndirection) {
        this.hasProxyIndirection = hasProxyIndirection;
    }

    @Override
    public void setLogin(DatabaseLogin datasourceLogin) {
        this.datasourceLogin = datasourceLogin;
    }

    public void setMultitenantPolicy(MultitenantPolicy policy) {
        this.multitenantPolicy = policy;
    }

    @Override
    public void setLogin(Login datasourceLogin) {
        this.datasourceLogin = datasourceLogin;
    }

    public void setDatasourceLogin(Login datasourceLogin) {
        this.datasourceLogin = datasourceLogin;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getName() + ")";
    }

    public void useCacheIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useCacheIdentityMap();
        }
    }

    public void useCacheIdentityMap(int cacheSize) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useCacheIdentityMap();
            descriptor.setIdentityMapSize(cacheSize);
        }
    }

    public void useFullIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useFullIdentityMap();
        }
    }

    public void useFullIdentityMap(int initialCacheSize) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useFullIdentityMap();
            descriptor.setIdentityMapSize(initialCacheSize);
        }
    }

    public void useNoIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useNoIdentityMap();
        }
    }

    public void useSoftCacheWeakIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useSoftCacheWeakIdentityMap();
        }
    }

    public void useSoftCacheWeakIdentityMap(int cacheSize) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useSoftCacheWeakIdentityMap();
            descriptor.setIdentityMapSize(cacheSize);
        }
    }

    public boolean usesOptimisticLocking() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            if (!descriptor.usesOptimisticLocking()) continue;
            return true;
        }
        return false;
    }

    public boolean usesSequencing() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            if (!descriptor.usesSequenceNumbers()) continue;
            return true;
        }
        return false;
    }

    public void useWeakIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useWeakIdentityMap();
        }
    }

    public void useWeakIdentityMap(int initialCacheSize) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useWeakIdentityMap();
            descriptor.setIdentityMapSize(initialCacheSize);
        }
    }

    public void applyLogin() {
    }

    public Map<String, ClassDescriptor> getAliasDescriptors() {
        return this.aliasDescriptors;
    }

    public void addAlias(String alias, ClassDescriptor descriptor) {
        if (this.aliasDescriptors == null) {
            this.aliasDescriptors = new HashMap<String, ClassDescriptor>(10);
        }
        this.aliasDescriptors.put(alias, descriptor);
    }

    public boolean allowTablePerMultitenantDDLGeneration() {
        return this.allowTablePerMultitenantDDLGeneration;
    }

    public boolean allowNativeSQLQueries() {
        return this.allowNativeSQLQueries;
    }

    public boolean allowSQLDeferral() {
        return this.allowSQLDeferral;
    }

    public boolean namingIntoIndexed() {
        return this.namingIntoIndexed;
    }

    public boolean allowExtendedCacheLogging() {
        return this.allowExtendedCacheLogging;
    }

    public boolean allowExtendedThreadLogging() {
        return this.allowExtendedThreadLogging;
    }

    public boolean allowExtendedThreadLoggingThreadDump() {
        return this.allowExtendedThreadLoggingThreadDump;
    }

    public ClassDescriptor getDescriptorForAlias(String alias) {
        ClassDescriptor descriptor = null;
        if (this.aliasDescriptors != null) {
            descriptor = this.aliasDescriptors.get(alias);
        }
        return descriptor;
    }

    public void setAliasDescriptors(Map<String, ClassDescriptor> aHashtable) {
        this.aliasDescriptors = aHashtable;
    }

    public void setAllowTablePerMultitenantDDLGeneration(boolean allowTablePerMultitenantDDLGeneration) {
        this.allowTablePerMultitenantDDLGeneration = allowTablePerMultitenantDDLGeneration;
    }

    public void setAllowNativeSQLQueries(boolean allowNativeSQLQueries) {
        this.allowNativeSQLQueries = allowNativeSQLQueries;
    }

    public void setAllowSQLDeferral(boolean allowSQLDeferral) {
        this.allowSQLDeferral = allowSQLDeferral;
    }

    public void setNamingIntoIndexed(boolean namingIntoIndexed) {
        this.namingIntoIndexed = namingIntoIndexed;
    }

    public void setAllowExtendedCacheLogging(boolean allowExtendedCacheLogging) {
        this.allowExtendedCacheLogging = allowExtendedCacheLogging;
    }

    public void setAllowExtendedThreadLogging(boolean allowExtendedThreadLogging) {
        this.allowExtendedThreadLogging = allowExtendedThreadLogging;
    }

    public void setAllowExtendedThreadLoggingThreadDump(boolean allowExtendedThreadLoggingThreadDump) {
        this.allowExtendedThreadLoggingThreadDump = allowExtendedThreadLoggingThreadDump;
    }

    public boolean hasMappingsPostCalculateChangesOnDeleted() {
        return this.hasMappingsPostCalculateChangesOnDeleted;
    }

    public void setHasMappingsPostCalculateChangesOnDeleted(boolean hasMappingsPostCalculateChangesOnDeleted) {
        this.hasMappingsPostCalculateChangesOnDeleted = hasMappingsPostCalculateChangesOnDeleted;
    }

    public boolean hasMappedSuperclasses() {
        return null != this.mappedSuperclassDescriptors && !this.mappedSuperclassDescriptors.isEmpty();
    }

    public boolean hasMappedSuperclass(String className) {
        if (!this.hasMappedSuperclasses()) {
            return false;
        }
        return this.mappedSuperclassDescriptors.containsKey(className);
    }

    public void addJPAQuery(DatabaseQuery query) {
        this.getJPAQueries().add(query);
    }

    public void addJPATablePerTenantQuery(DatabaseQuery query) {
        this.getJPATablePerTenantQueries().add(query);
    }

    public void addMappedSuperclass(String key, ClassDescriptor value, boolean replace) {
        if (null == this.mappedSuperclassDescriptors) {
            this.mappedSuperclassDescriptors = new HashMap<String, ClassDescriptor>(2);
        }
        if (replace || !this.mappedSuperclassDescriptors.containsKey(key)) {
            this.mappedSuperclassDescriptors.put(key, value);
        }
    }

    public ClassDescriptor getMappedSuperclass(String key) {
        if (null == this.mappedSuperclassDescriptors) {
            this.mappedSuperclassDescriptors = new HashMap<String, ClassDescriptor>(2);
            return null;
        }
        return this.mappedSuperclassDescriptors.get(key);
    }

    public Map<String, ClassDescriptor> getMappedSuperclassDescriptors() {
        if (null == this.mappedSuperclassDescriptors) {
            this.mappedSuperclassDescriptors = new HashMap<String, ClassDescriptor>(2);
        }
        return this.mappedSuperclassDescriptors;
    }

    public void addMetamodelIdClassMapEntry(String ownerName, String name) {
        if (this.metamodelIdClassMap.containsKey(ownerName)) {
            this.metamodelIdClassMap.get(ownerName).add(name);
        } else {
            ArrayList<String> ownerList = new ArrayList<String>();
            ownerList.add(name);
            this.metamodelIdClassMap.put(ownerName, ownerList);
        }
    }

    public Map<String, List<String>> getMetamodelIdClassMap() {
        return this.metamodelIdClassMap;
    }

    public Map<String, PartitioningPolicy> getPartitioningPolicies() {
        if (this.partitioningPolicies == null) {
            this.partitioningPolicies = new HashMap<String, PartitioningPolicy>();
        }
        return this.partitioningPolicies;
    }

    public void setPartitioningPolicies(Map<String, PartitioningPolicy> partitioningPolicies) {
        this.partitioningPolicies = partitioningPolicies;
    }

    public void addPartitioningPolicy(PartitioningPolicy partitioningPolicy) {
        this.getPartitioningPolicies().put(partitioningPolicy.getName(), partitioningPolicy);
    }

    public PartitioningPolicy getPartitioningPolicy(String name) {
        if (this.partitioningPolicies == null) {
            return null;
        }
        return this.partitioningPolicies.get(name);
    }
}

