/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import java.util.List;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;

public class CustomPartitioningPolicy
extends PartitioningPolicy {
    protected String partitioningClasName;
    protected PartitioningPolicy policy;

    @Override
    public void initialize(AbstractSession session) {
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.getPartitioningClasName() == null) {
            this.setPartitioningClasName("");
        }
        this.policy = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> {
            Class partitioningClass = PrivilegedAccessHelper.getClassForName(this.getPartitioningClasName(), true, classLoader);
            return (PartitioningPolicy)PrivilegedAccessHelper.newInstanceFromClass(partitioningClass);
        }, ex -> {
            if (ex instanceof ClassNotFoundException) {
                return ValidationException.classNotFoundWhileConvertingClassNames(this.getPartitioningClasName(), ex);
            }
            if (ex instanceof IllegalAccessException) {
                return ValidationException.reflectiveExceptionWhileCreatingClassInstance(this.getPartitioningClasName(), ex);
            }
            if (ex instanceof InstantiationException) {
                return ValidationException.reflectiveExceptionWhileCreatingClassInstance(this.getPartitioningClasName(), ex);
            }
            return new RuntimeException("Could not convert class names to classes", ex);
        });
    }

    @Override
    public List<Accessor> getConnectionsForQuery(AbstractSession session, DatabaseQuery query, AbstractRecord arguments) {
        return this.policy.getConnectionsForQuery(session, query, arguments);
    }

    public String getPartitioningClasName() {
        return this.partitioningClasName;
    }

    public void setPartitioningClasName(String partitioningClasName) {
        this.partitioningClasName = partitioningClasName;
    }

    public PartitioningPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(PartitioningPolicy policy) {
        this.policy = policy;
    }
}

