/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm;

import org.eclipse.persistence.internal.libraries.asm.ByteVector;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.Handle;
import org.eclipse.persistence.internal.libraries.asm.Symbol;
import org.eclipse.persistence.internal.libraries.asm.Type;

final class SymbolTable {
    final ClassWriter classWriter;
    private final ClassReader sourceClassReader;
    private int majorVersion;
    private String className;
    private int entryCount;
    private Entry[] entries;
    private int constantPoolCount;
    private ByteVector constantPool;
    private int bootstrapMethodCount;
    private ByteVector bootstrapMethods;
    private int typeCount;
    private Entry[] typeTable;

    SymbolTable(ClassWriter classWriter) {
        this.classWriter = classWriter;
        this.sourceClassReader = null;
        this.entries = new Entry[256];
        this.constantPoolCount = 1;
        this.constantPool = new ByteVector();
    }

    SymbolTable(ClassWriter classWriter, ClassReader classReader) {
        int n;
        int n2;
        int n3;
        this.classWriter = classWriter;
        this.sourceClassReader = classReader;
        byte[] byArray = classReader.b;
        int n4 = classReader.getItem(1) - 1;
        int n5 = classReader.header - n4;
        this.constantPoolCount = classReader.getItemCount();
        this.constantPool = new ByteVector(n5);
        this.constantPool.putByteArray(byArray, n4, n5);
        this.entries = new Entry[this.constantPoolCount * 2];
        char[] cArray = new char[classReader.getMaxStringLength()];
        block10: for (int i = 1; i < this.constantPoolCount; i += n3 == 5 || n3 == 6 ? 2 : 1) {
            n2 = classReader.getItem(i);
            n3 = byArray[n2 - 1];
            switch (n3) {
                case 9: 
                case 10: 
                case 11: {
                    int n6 = classReader.getItem(classReader.readUnsignedShort(n2 + 2));
                    this.addConstantMemberReference(i, n3, classReader.readClass(n2, cArray), classReader.readUTF8(n6, cArray), classReader.readUTF8(n6 + 2, cArray));
                    continue block10;
                }
                case 3: 
                case 4: {
                    this.addConstantInteger(i, n3, classReader.readInt(n2));
                    continue block10;
                }
                case 12: {
                    this.addConstantNameAndType(i, classReader.readUTF8(n2, cArray), classReader.readUTF8(n2 + 2, cArray));
                    continue block10;
                }
                case 5: 
                case 6: {
                    this.addConstantLong(i, n3, classReader.readLong(n2));
                    continue block10;
                }
                case 1: {
                    this.addConstantUtf8(i, classReader.readUTF(i, cArray));
                    continue block10;
                }
                case 15: {
                    n = classReader.getItem(classReader.readUnsignedShort(n2 + 1));
                    int n6 = classReader.getItem(classReader.readUnsignedShort(n + 2));
                    this.addConstantMethodHandle(i, classReader.readByte(n2), classReader.readClass(n, cArray), classReader.readUTF8(n6, cArray), classReader.readUTF8(n6 + 2, cArray));
                    continue block10;
                }
                case 18: {
                    int n6 = classReader.getItem(classReader.readUnsignedShort(n2 + 2));
                    this.addConstantInvokeDynamic(i, classReader.readUTF8(n6, cArray), classReader.readUTF8(n6 + 2, cArray), classReader.readUnsignedShort(n2));
                    continue block10;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    this.addConstantUtf8Reference(i, n3, classReader.readUTF8(n2, cArray));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        n2 = classReader.getFirstAttributeOffset();
        for (n3 = classReader.readUnsignedShort(n2 - 2); n3 > 0; --n3) {
            String string = classReader.readUTF8(n2, cArray);
            if ("BootstrapMethods".equals(string)) {
                this.bootstrapMethodCount = classReader.readUnsignedShort(n2 + 6);
                break;
            }
            n2 += 6 + classReader.readInt(n2 + 2);
        }
        if (this.bootstrapMethodCount > 0) {
            n3 = n2 + 8;
            int n7 = classReader.readInt(n2 + 2) - 2;
            this.bootstrapMethods = new ByteVector(n7);
            this.bootstrapMethods.putByteArray(byArray, n3, n7);
            n = n3;
            for (int i = 0; i < this.bootstrapMethodCount; ++i) {
                int n8 = n - n3;
                int n9 = classReader.readUnsignedShort(n);
                int n10 = classReader.readUnsignedShort(n += 2);
                n += 2;
                int n11 = classReader.readConst(n9, cArray).hashCode();
                while (n10-- > 0) {
                    int n12 = classReader.readUnsignedShort(n);
                    n += 2;
                    n11 ^= classReader.readConst(n12, cArray).hashCode();
                }
                this.add(new Entry(i, 64, n8, n11 & Integer.MAX_VALUE));
            }
        }
    }

    ClassReader getSource() {
        return this.sourceClassReader;
    }

    int getMajorVersion() {
        return this.majorVersion;
    }

    String getClassName() {
        return this.className;
    }

    int setMajorVersionAndClassName(int n, String string) {
        this.majorVersion = n;
        this.className = string;
        return this.addConstantClass((String)string).index;
    }

    int getConstantPoolCount() {
        return this.constantPoolCount;
    }

    int getConstantPoolLength() {
        return this.constantPool.length;
    }

    void putConstantPool(ByteVector byteVector) {
        byteVector.putShort(this.constantPoolCount).putByteArray(this.constantPool.data, 0, this.constantPool.length);
    }

    int computeBootstrapMethodsSize() {
        if (this.bootstrapMethods != null) {
            this.addConstantUtf8("BootstrapMethods");
            return 8 + this.bootstrapMethods.length;
        }
        return 0;
    }

    void putBootstrapMethods(ByteVector byteVector) {
        if (this.bootstrapMethods != null) {
            byteVector.putShort(this.addConstantUtf8("BootstrapMethods")).putInt(this.bootstrapMethods.length + 2).putShort(this.bootstrapMethodCount).putByteArray(this.bootstrapMethods.data, 0, this.bootstrapMethods.length);
        }
    }

    private Entry get(int n) {
        return this.entries[n % this.entries.length];
    }

    private Entry put(Entry entry) {
        int n;
        if (this.entryCount > this.entries.length * 3 / 4) {
            n = this.entries.length;
            int n2 = n * 2 + 1;
            Entry[] entryArray = new Entry[n2];
            for (int i = n - 1; i >= 0; --i) {
                Entry entry2 = this.entries[i];
                while (entry2 != null) {
                    int n3 = entry2.hashCode % n2;
                    Entry entry3 = entry2.next;
                    entry2.next = entryArray[n3];
                    entryArray[n3] = entry2;
                    entry2 = entry3;
                }
            }
            this.entries = entryArray;
        }
        ++this.entryCount;
        n = entry.hashCode % this.entries.length;
        entry.next = this.entries[n];
        this.entries[n] = entry;
        return this.entries[n];
    }

    private void add(Entry entry) {
        ++this.entryCount;
        int n = entry.hashCode % this.entries.length;
        entry.next = this.entries[n];
        this.entries[n] = entry;
    }

    Symbol addConstant(Object object) {
        if (object instanceof Integer) {
            return this.addConstantInteger((Integer)object);
        }
        if (object instanceof Byte) {
            return this.addConstantInteger(((Byte)object).intValue());
        }
        if (object instanceof Character) {
            return this.addConstantInteger(((Character)object).charValue());
        }
        if (object instanceof Short) {
            return this.addConstantInteger(((Short)object).intValue());
        }
        if (object instanceof Boolean) {
            return this.addConstantInteger((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Float) {
            return this.addConstantFloat(((Float)object).floatValue());
        }
        if (object instanceof Long) {
            return this.addConstantLong((Long)object);
        }
        if (object instanceof Double) {
            return this.addConstantDouble((Double)object);
        }
        if (object instanceof String) {
            return this.addConstantString((String)object);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            int n = type.getSort();
            if (n == 10) {
                return this.addConstantClass(type.getInternalName());
            }
            if (n == 11) {
                return this.addConstantMethodType(type.getDescriptor());
            }
            return this.addConstantClass(type.getDescriptor());
        }
        if (object instanceof Handle) {
            Handle handle = (Handle)object;
            return this.addConstantMethodHandle(handle.tag, handle.owner, handle.name, handle.descriptor, handle.isInterface);
        }
        throw new IllegalArgumentException("value " + object);
    }

    Symbol addConstantClass(String string) {
        return this.addConstantUtf8Reference(7, string);
    }

    Symbol addConstantFieldref(String string, String string2, String string3) {
        return this.addConstantMemberReference(9, string, string2, string3);
    }

    Symbol addConstantMethodref(String string, String string2, String string3, boolean bl) {
        int n = bl ? 11 : 10;
        return this.addConstantMemberReference(n, string, string2, string3);
    }

    private Entry addConstantMemberReference(int n, String string, String string2, String string3) {
        int n2 = SymbolTable.hash(n, string, string2, string3);
        Entry entry = this.get(n2);
        while (entry != null) {
            if (entry.tag == n && entry.hashCode == n2 && entry.owner.equals(string) && entry.name.equals(string2) && entry.value.equals(string3)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put122(n, this.addConstantClass((String)string).index, this.addConstantNameAndType(string2, string3));
        return this.put(new Entry(this.constantPoolCount++, n, string, string2, string3, 0L, n2));
    }

    private void addConstantMemberReference(int n, int n2, String string, String string2, String string3) {
        this.add(new Entry(n, n2, string, string2, string3, 0L, SymbolTable.hash(n2, string, string2, string3)));
    }

    Symbol addConstantString(String string) {
        return this.addConstantUtf8Reference(8, string);
    }

    Symbol addConstantInteger(int n) {
        return this.addConstantInteger(3, n);
    }

    Symbol addConstantFloat(float f) {
        return this.addConstantInteger(4, Float.floatToRawIntBits(f));
    }

    private Symbol addConstantInteger(int n, int n2) {
        int n3 = SymbolTable.hash(n, n2);
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == n && entry.hashCode == n3 && entry.data == (long)n2) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.putByte(n).putInt(n2);
        return this.put(new Entry(this.constantPoolCount++, n, n2, n3));
    }

    private void addConstantInteger(int n, int n2, int n3) {
        this.add(new Entry(n, n2, n3, SymbolTable.hash(n2, n3)));
    }

    Symbol addConstantLong(long l) {
        return this.addConstantLong(5, l);
    }

    Symbol addConstantDouble(double d) {
        return this.addConstantLong(6, Double.doubleToRawLongBits(d));
    }

    private Symbol addConstantLong(int n, long l) {
        int n2 = SymbolTable.hash(n, l);
        Entry entry = this.get(n2);
        while (entry != null) {
            if (entry.tag == n && entry.hashCode == n2 && entry.data == l) {
                return entry;
            }
            entry = entry.next;
        }
        int n3 = this.constantPoolCount;
        this.constantPool.putByte(n).putLong(l);
        this.constantPoolCount += 2;
        return this.put(new Entry(n3, n, l, n2));
    }

    private void addConstantLong(int n, int n2, long l) {
        this.add(new Entry(n, n2, l, SymbolTable.hash(n2, l)));
    }

    int addConstantNameAndType(String string, String string2) {
        int n = SymbolTable.hash(12, string, string2);
        Entry entry = this.get(n);
        while (entry != null) {
            if (entry.tag == 12 && entry.hashCode == n && entry.name.equals(string) && entry.value.equals(string2)) {
                return entry.index;
            }
            entry = entry.next;
        }
        this.constantPool.put122(12, this.addConstantUtf8(string), this.addConstantUtf8(string2));
        return this.put((Entry)new Entry((int)this.constantPoolCount++, (int)12, (String)string, (String)string2, (int)n)).index;
    }

    private void addConstantNameAndType(int n, String string, String string2) {
        this.add(new Entry(n, 12, string, string2, SymbolTable.hash(12, string, string2)));
    }

    int addConstantUtf8(String string) {
        int n = SymbolTable.hash(1, string);
        Entry entry = this.get(n);
        while (entry != null) {
            if (entry.tag == 1 && entry.hashCode == n && entry.value.equals(string)) {
                return entry.index;
            }
            entry = entry.next;
        }
        this.constantPool.putByte(1).putUTF8(string);
        return this.put((Entry)new Entry((int)this.constantPoolCount++, (int)1, (String)string, (int)n)).index;
    }

    private void addConstantUtf8(int n, String string) {
        this.add(new Entry(n, 1, string, SymbolTable.hash(1, string)));
    }

    Symbol addConstantMethodHandle(int n, String string, String string2, String string3, boolean bl) {
        int n2 = SymbolTable.hash(15, string, string2, string3, n);
        Entry entry = this.get(n2);
        while (entry != null) {
            if (entry.tag == 15 && entry.hashCode == n2 && entry.data == (long)n && entry.owner.equals(string) && entry.name.equals(string2) && entry.value.equals(string3)) {
                return entry;
            }
            entry = entry.next;
        }
        if (n <= 4) {
            this.constantPool.put112(15, n, this.addConstantFieldref((String)string, (String)string2, (String)string3).index);
        } else {
            this.constantPool.put112(15, n, this.addConstantMethodref((String)string, (String)string2, (String)string3, (boolean)bl).index);
        }
        return this.put(new Entry(this.constantPoolCount++, 15, string, string2, string3, n, n2));
    }

    private void addConstantMethodHandle(int n, int n2, String string, String string2, String string3) {
        int n3 = SymbolTable.hash(15, string, string2, string3, n2);
        this.add(new Entry(n, 15, string, string2, string3, n2, n3));
    }

    Symbol addConstantMethodType(String string) {
        return this.addConstantUtf8Reference(16, string);
    }

    Symbol addConstantInvokeDynamic(String string, String string2, Handle handle, Object ... objectArray) {
        Symbol symbol = this.addBootstrapMethod(handle, objectArray);
        return this.addConstantInvokeDynamic(string, string2, symbol.index);
    }

    private Symbol addConstantInvokeDynamic(String string, String string2, int n) {
        int n2 = SymbolTable.hash(18, string, string2, n);
        Entry entry = this.get(n2);
        while (entry != null) {
            if (entry.tag == 18 && entry.hashCode == n2 && entry.data == (long)n && entry.name.equals(string) && entry.value.equals(string2)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put122(18, n, this.addConstantNameAndType(string, string2));
        return this.put(new Entry(this.constantPoolCount++, 18, null, string, string2, n, n2));
    }

    private void addConstantInvokeDynamic(int n, String string, String string2, int n2) {
        int n3 = SymbolTable.hash(18, string, string2, n2);
        this.add(new Entry(n, 18, null, string, string2, n2, n3));
    }

    Symbol addConstantModule(String string) {
        return this.addConstantUtf8Reference(19, string);
    }

    Symbol addConstantPackage(String string) {
        return this.addConstantUtf8Reference(20, string);
    }

    private Symbol addConstantUtf8Reference(int n, String string) {
        int n2 = SymbolTable.hash(n, string);
        Entry entry = this.get(n2);
        while (entry != null) {
            if (entry.tag == n && entry.hashCode == n2 && entry.value.equals(string)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put12(n, this.addConstantUtf8(string));
        return this.put(new Entry(this.constantPoolCount++, n, string, n2));
    }

    private void addConstantUtf8Reference(int n, int n2, String string) {
        this.add(new Entry(n, n2, string, SymbolTable.hash(n2, string)));
    }

    Symbol addBootstrapMethod(Handle handle, Object ... objectArray) {
        int n;
        ByteVector byteVector = this.bootstrapMethods;
        if (byteVector == null) {
            byteVector = this.bootstrapMethods = new ByteVector();
        }
        int n2 = byteVector.length;
        byteVector.putShort(this.addConstantMethodHandle((int)handle.tag, (String)handle.owner, (String)handle.name, (String)handle.descriptor, (boolean)handle.isInterface()).index);
        int n3 = objectArray.length;
        byteVector.putShort(n3);
        for (n = 0; n < n3; ++n) {
            byteVector.putShort(this.addConstant((Object)objectArray[n]).index);
        }
        n = byteVector.length - n2;
        int n4 = handle.hashCode();
        for (int i = 0; i < n3; ++i) {
            n4 ^= objectArray[i].hashCode();
        }
        return this.addBootstrapMethod(n2, n, n4 &= Integer.MAX_VALUE);
    }

    private Symbol addBootstrapMethod(int n, int n2, int n3) {
        byte[] byArray = this.bootstrapMethods.data;
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == 64 && entry.hashCode == n3) {
                int n4 = (int)entry.data;
                boolean bl = true;
                for (int i = 0; i < n2; ++i) {
                    if (byArray[n + i] == byArray[n4 + i]) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    this.bootstrapMethods.length = n;
                    return entry;
                }
            }
            entry = entry.next;
        }
        return this.put(new Entry(this.bootstrapMethodCount++, 64, n, n3));
    }

    Symbol getType(int n) {
        return this.typeTable[n];
    }

    int addType(String string) {
        int n = SymbolTable.hash(128, string);
        Entry entry = this.get(n);
        while (entry != null) {
            if (entry.tag == 128 && entry.hashCode == n && entry.value.equals(string)) {
                return entry.index;
            }
            entry = entry.next;
        }
        return this.addType(new Entry(this.typeCount, 128, string, n));
    }

    int addUninitializedType(String string, int n) {
        int n2 = SymbolTable.hash(129, string, n);
        Entry entry = this.get(n2);
        while (entry != null) {
            if (entry.tag == 129 && entry.hashCode == n2 && entry.data == (long)n && entry.value.equals(string)) {
                return entry.index;
            }
            entry = entry.next;
        }
        return this.addType(new Entry(this.typeCount, 129, string, n, n2));
    }

    int addMergedType(int n, int n2) {
        int n3;
        long l = (long)n | (long)n2 << 32;
        int n4 = SymbolTable.hash(130, n + n2);
        Entry entry = this.get(n4);
        while (entry != null) {
            if (entry.tag == 130 && entry.hashCode == n4 && entry.data == l) {
                return entry.info;
            }
            entry = entry.next;
        }
        String string = this.typeTable[n].value;
        String string2 = this.typeTable[n2].value;
        this.put((Entry)new Entry((int)this.typeCount, (int)130, (long)l, (int)n4)).info = n3 = this.addType(this.classWriter.getCommonSuperClass(string, string2));
        return n3;
    }

    private int addType(Entry entry) {
        if (this.typeTable == null) {
            this.typeTable = new Entry[16];
        }
        if (this.typeCount == this.typeTable.length) {
            Entry[] entryArray = new Entry[2 * this.typeTable.length];
            System.arraycopy(this.typeTable, 0, entryArray, 0, this.typeTable.length);
            this.typeTable = entryArray;
        }
        this.typeTable[this.typeCount++] = entry;
        return this.put((Entry)entry).index;
    }

    private static int hash(int n, int n2) {
        return Integer.MAX_VALUE & n + n2;
    }

    private static int hash(int n, long l) {
        return Integer.MAX_VALUE & n + (int)l + (int)(l >>> 32);
    }

    private static int hash(int n, String string) {
        return Integer.MAX_VALUE & n + string.hashCode();
    }

    private static int hash(int n, String string, int n2) {
        return Integer.MAX_VALUE & n + string.hashCode() + n2;
    }

    private static int hash(int n, String string, String string2) {
        return Integer.MAX_VALUE & n + string.hashCode() * string2.hashCode();
    }

    private static int hash(int n, String string, String string2, int n2) {
        return Integer.MAX_VALUE & n + string.hashCode() * string2.hashCode() * (n2 + 1);
    }

    private static int hash(int n, String string, String string2, String string3) {
        return Integer.MAX_VALUE & n + string.hashCode() * string2.hashCode() * string3.hashCode();
    }

    private static int hash(int n, String string, String string2, String string3, int n2) {
        return Integer.MAX_VALUE & n + string.hashCode() * string2.hashCode() * string3.hashCode() * n2;
    }

    private static class Entry
    extends Symbol {
        final int hashCode;
        Entry next;

        Entry(int n, int n2, String string, String string2, String string3, long l, int n3) {
            super(n, n2, string, string2, string3, l);
            this.hashCode = n3;
        }

        Entry(int n, int n2, String string, int n3) {
            super(n, n2, null, null, string, 0L);
            this.hashCode = n3;
        }

        Entry(int n, int n2, String string, long l, int n3) {
            super(n, n2, null, null, string, l);
            this.hashCode = n3;
        }

        Entry(int n, int n2, String string, String string2, int n3) {
            super(n, n2, null, string, string2, 0L);
            this.hashCode = n3;
        }

        Entry(int n, int n2, long l, int n3) {
            super(n, n2, null, null, null, l);
            this.hashCode = n3;
        }
    }
}

