/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.coordination.corba;

import java.io.Serializable;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.helper.SerializationHelper;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.internal.sessions.coordination.corba.CORBAConnection;
import org.eclipse.persistence.sessions.coordination.Command;
import org.omg.CORBA.SystemException;

public class CORBARemoteCommandConnection
extends RemoteConnection {
    CORBAConnection wrappedConnection;

    public CORBARemoteCommandConnection(CORBAConnection connection) {
        this.wrappedConnection = connection;
    }

    public Object executeCommand(Command command) throws CommunicationException {
        byte[] serializedCmd = null;
        try {
            serializedCmd = SerializationHelper.serialize((Serializable)command);
        }
        catch (Exception e) {
            RemoteCommandManagerException.errorSerializeOrDeserialzeCommand((Exception)e);
        }
        try {
            byte[] result = this.wrappedConnection.executeCommand(serializedCmd);
            if (result != null) {
                return new String(result);
            }
        }
        catch (SystemException exception) {
            throw CommunicationException.errorInInvocation((Exception)((Object)exception));
        }
        return null;
    }

    public Object executeCommand(byte[] command) throws CommunicationException {
        try {
            byte[] result = this.wrappedConnection.executeCommand(command);
            if (result != null) {
                return new String(result);
            }
        }
        catch (SystemException exception) {
            throw CommunicationException.errorInInvocation((Exception)((Object)exception));
        }
        return null;
    }
}

