/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.remote.rmi.iiop;

import java.io.IOException;
import java.net.InetAddress;
import javax.naming.Context;
import javax.rmi.PortableRemoteObject;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.internal.sessions.coordination.rmi.RMIRemoteCommandConnection;
import org.eclipse.persistence.internal.sessions.coordination.rmi.RMIRemoteCommandConnectionImpl;
import org.eclipse.persistence.internal.sessions.coordination.rmi.RMIRemoteConnection;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.rmi.RMITransportManager;

public class RMIIIOPTransportManager
extends RMITransportManager {
    public RMIIIOPTransportManager(RemoteCommandManager rcm) {
        super(rcm);
    }

    protected RemoteConnection createConnectionFromJNDI(String remoteObjectIdentifier, String hostURL) {
        Object[] args = new Object[]{remoteObjectIdentifier, hostURL};
        this.rcm.logDebug("looking_up_remote_conn_in_jndi", args);
        try {
            Context context = this.getRemoteHostContext(hostURL);
            return new RMIRemoteConnection((RMIRemoteCommandConnection)PortableRemoteObject.narrow((Object)context.lookup(remoteObjectIdentifier), RMIRemoteCommandConnection.class));
        }
        catch (Exception e) {
            try {
                this.rcm.handleException((RuntimeException)RemoteCommandManagerException.errorLookingUpRemoteConnection((String)remoteObjectIdentifier, (String)hostURL, (Exception)e));
            }
            catch (Exception ex2) {
                this.rcm.logDebug("unable_to_look_up_remote_conn_in_jndi", args);
            }
            return null;
        }
    }

    protected void createLocalConnectionInJNDI() {
        try {
            RMIRemoteCommandConnectionImpl remoteConnectionObject = new RMIRemoteCommandConnectionImpl(this.rcm);
            Object[] args = new Object[]{this.rcm.getServiceId().getId()};
            this.rcm.logDebug("register_local_connection_in_jndi", args);
            this.getLocalHostContext().rebind(this.rcm.getServiceId().getId(), (Object)remoteConnectionObject);
            this.localConnection = new RMIRemoteConnection((RMIRemoteCommandConnection)remoteConnectionObject);
        }
        catch (Exception exception) {
            this.rcm.handleException((RuntimeException)RemoteCommandManagerException.errorBindingConnection((String)this.rcm.getServiceId().toString(), (Exception)exception));
        }
    }

    public String getDefaultLocalUrl() {
        try {
            String localHost = InetAddress.getLocalHost().getHostName();
            return "corbaname::" + localHost + ":5555#";
        }
        catch (IOException exception) {
            throw RemoteCommandManagerException.errorGettingHostName((Exception)exception);
        }
    }
}

