/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLConversionPair;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.record.XMLRecord;

public class XMLField
extends DatabaseField {
    private NamespaceResolver namespaceResolver;
    private QName schemaType;
    private XPathFragment xPathFragment;
    private XPathFragment lastXPathFragment;
    private boolean isCDATA = false;
    private boolean isRequired = false;
    private boolean isInitialized = false;
    private boolean usesSingleNode;
    protected HashMap userXMLTypes;
    protected HashMap userJavaTypes;
    protected boolean isTypedTextField = false;
    protected QName leafElementType;

    public XMLField() {
    }

    public XMLField(String xPath) {
        super(xPath, new DatabaseTable());
    }

    public void initialize() {
        if (this.xPathFragment != null) {
            this.initializeXPathFragment(this.xPathFragment);
        }
        this.isInitialized = true;
    }

    private void initializeXPathFragment(XPathFragment xPathFragment) {
        XPathFragment nextXPathFragment;
        String localName;
        XPathPredicate predicate = xPathFragment.getPredicate();
        if (predicate != null) {
            this.initializeXPathFragment(predicate.getXPathFragment());
        }
        if ((localName = xPathFragment.getLocalName()) != null && !localName.equals("") && xPathFragment.getNamespaceURI() == null) {
            if (xPathFragment.hasNamespace()) {
                if (this.namespaceResolver == null) {
                    throw XMLMarshalException.namespaceNotFound(xPathFragment.getShortName());
                }
                String uri = this.namespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
                if (uri == null && xPathFragment.getPrefix() != null) {
                    throw XMLMarshalException.namespaceNotFound(xPathFragment.getShortName());
                }
                xPathFragment.setNamespaceURI(uri);
            } else if (!xPathFragment.isAttribute() && this.namespaceResolver != null) {
                xPathFragment.setNamespaceURI(this.namespaceResolver.getDefaultNamespaceURI());
            }
        }
        if ((nextXPathFragment = xPathFragment.getNextFragment()) != null) {
            this.initializeXPathFragment(nextXPathFragment);
        }
    }

    public String getXPath() {
        return this.getName();
    }

    public void setXPath(String xPath) {
        this.setName(xPath);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setNamespaceResolver(NamespaceResolver newNamespaceResolver) {
        this.namespaceResolver = newNamespaceResolver;
    }

    public void setUsesSingleNode(boolean usesSingleNode) {
        this.usesSingleNode = usesSingleNode;
    }

    public boolean usesSingleNode() {
        return this.usesSingleNode;
    }

    public void setSchemaType(QName value) {
        this.schemaType = value;
    }

    public QName getSchemaType() {
        return this.schemaType;
    }

    public boolean isTypedTextField() {
        return this.isTypedTextField;
    }

    public void setIsTypedTextField(boolean value) {
        this.isTypedTextField = value;
    }

    public boolean isSelfField() {
        if (this.xPathFragment == null) {
            return false;
        }
        return this.xPathFragment.isSelfFragment();
    }

    public boolean isUnionField() {
        return false;
    }

    @Override
    public void setName(String xPath, String startDelimiter, String endDelimiter) {
        super.setName(xPath, null, null);
        if (this.hasPath(xPath)) {
            this.buildFragments(xPath);
        } else {
            XPathFragment xPathFragment = new XPathFragment(xPath.intern());
            xPathFragment.setXMLField(this);
            this.setXPathFragment(xPathFragment);
            this.setLastXPathFragment(xPathFragment);
        }
    }

    @Override
    public void setName(String xPath) {
        this.setName(xPath, null, null);
    }

    private boolean hasPath(String xpathString) {
        return xpathString != null && xpathString.indexOf(47) != -1;
    }

    private void buildFragments(String xpathString) {
        StringTokenizer st = new StringTokenizer(xpathString, "/", true);
        int i = 0;
        XPathFragment currentXPathFragment = null;
        XPathFragment nextXPathFragment = null;
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            if (next != null) {
                if ("/".equals(next)) {
                    if (i != 0) continue;
                    next = "/" + st.nextToken();
                }
                if (next.contains("[") && !next.contains("]")) {
                    StringBuilder sb = new StringBuilder(next);
                    while (st.hasMoreTokens()) {
                        String more = st.nextToken();
                        sb.append(more);
                        if (more.contains("]")) break;
                    }
                    next = sb.toString().intern();
                } else {
                    next = next.intern();
                }
                nextXPathFragment = new XPathFragment(next);
                if (i == 0) {
                    this.setXPathFragment(nextXPathFragment);
                } else {
                    currentXPathFragment.setNextFragment(nextXPathFragment);
                    if (nextXPathFragment.isAttribute() || nextXPathFragment.nameIsText()) {
                        currentXPathFragment.setHasText(true);
                    }
                }
                nextXPathFragment.setXMLField(this);
                currentXPathFragment = nextXPathFragment;
                ++i;
            }
            this.setLastXPathFragment(currentXPathFragment);
        }
    }

    public XPathFragment getXPathFragment() {
        return this.xPathFragment;
    }

    public void setXPathFragment(XPathFragment xPathFragment) {
        this.xPathFragment = xPathFragment;
    }

    public XPathFragment getLastXPathFragment() {
        return this.lastXPathFragment;
    }

    public void setLastXPathFragment(XPathFragment lastXPathFragment) {
        this.lastXPathFragment = lastXPathFragment;
    }

    public Class getJavaClass(QName qname) {
        Class theClass;
        if (this.userXMLTypes != null && (theClass = (Class)this.userXMLTypes.get(qname)) != null) {
            return theClass;
        }
        return (Class)XMLConversionManager.getDefaultXMLTypes().get(qname);
    }

    public QName getXMLType(Class javaClass) {
        QName theQName;
        if (this.userJavaTypes != null && (theQName = (QName)this.userJavaTypes.get(javaClass)) != null) {
            return theQName;
        }
        return (QName)XMLConversionManager.getDefaultJavaTypes().get(javaClass);
    }

    private HashMap getUserJavaTypes() {
        if (this.userJavaTypes == null) {
            this.userJavaTypes = new HashMap();
        }
        return this.userJavaTypes;
    }

    private HashMap getUserXMLTypes() {
        if (this.userXMLTypes == null) {
            this.userXMLTypes = new HashMap();
        }
        return this.userXMLTypes;
    }

    public ArrayList getUserXMLTypesForDeploymentXML() {
        if (this.userXMLTypes != null) {
            ArrayList<XMLConversionPair> types = new ArrayList<XMLConversionPair>(this.userXMLTypes.size());
            for (Map.Entry entry : this.userXMLTypes.entrySet()) {
                XMLConversionPair pair = new XMLConversionPair((QName)entry.getKey(), ((Class)entry.getValue()).getName());
                types.add(pair);
            }
            return types;
        }
        return null;
    }

    public void setUserXMLTypesForDeploymentXML(ArrayList pairs) throws Exception {
        if (pairs.size() > 0) {
            this.userXMLTypes = new HashMap();
            for (XMLConversionPair pair : pairs) {
                if (pair.getXmlType() == null || pair.getJavaType() == null) continue;
                this.userXMLTypes.put(pair.getXmlType(), Class.forName(pair.getJavaType()));
            }
        }
    }

    public ArrayList getUserJavaTypesForDeploymentXML() {
        if (this.userJavaTypes != null) {
            ArrayList<XMLConversionPair> types = new ArrayList<XMLConversionPair>(this.userJavaTypes.size());
            for (Map.Entry entry : this.userJavaTypes.entrySet()) {
                XMLConversionPair pair = new XMLConversionPair((QName)entry.getValue(), ((Class)entry.getKey()).getName());
                types.add(pair);
            }
            return types;
        }
        return null;
    }

    public void setUserJavaTypesForDeploymentXML(ArrayList pairs) throws Exception {
        if (pairs.size() > 0) {
            this.userJavaTypes = new HashMap();
            for (XMLConversionPair pair : pairs) {
                if (pair.getXmlType() == null || pair.getJavaType() == null) continue;
                this.userJavaTypes.put(Class.forName(pair.getJavaType()), pair.getXmlType());
            }
        }
    }

    public Object convertValueBasedOnSchemaType(Object value, XMLConversionManager xmlConversionManager, XMLRecord record) {
        if (this.schemaType != null) {
            if (XMLConstants.QNAME_QNAME.equals(this.schemaType)) {
                return xmlConversionManager.buildQNameFromString((String)value, record);
            }
            Class fieldType = this.getType();
            if (fieldType == null) {
                fieldType = this.getJavaClass(this.schemaType);
            }
            return xmlConversionManager.convertObject(value, fieldType, this.schemaType);
        }
        return value;
    }

    public void addXMLConversion(QName qname, Class javaClass) {
        this.getUserXMLTypes().put(qname, javaClass);
    }

    public void addJavaConversion(Class javaClass, QName qname) {
        this.getUserJavaTypes().put(javaClass, qname);
    }

    public void addConversion(QName qname, Class javaClass) {
        this.addJavaConversion(javaClass, qname);
        this.addXMLConversion(qname, javaClass);
    }

    public void removeXMLConversion(QName qname) {
        this.getUserXMLTypes().remove(qname);
    }

    public void removeJavaConversion(Class javaClass) {
        this.getUserJavaTypes().remove(javaClass);
    }

    public void removeConversion(QName qname, Class javaClass) {
        this.removeJavaConversion(javaClass);
        this.removeXMLConversion(qname);
    }

    public void setLeafElementType(QName type) {
        this.leafElementType = type;
        if (this.hasLastXPathFragment()) {
            this.getLastXPathFragment().setLeafElementType(type);
        }
    }

    public QName getLeafElementType() {
        if (this.lastXPathFragment != null) {
            return this.lastXPathFragment.getLeafElementType();
        }
        return this.leafElementType;
    }

    public boolean hasLastXPathFragment() {
        return this.lastXPathFragment != null;
    }

    public QName getSchemaTypeForValue(Object value, AbstractSession session) {
        if (this.leafElementType != null) {
            return this.leafElementType;
        }
        if (this.isTypedTextField) {
            if (value != null && ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(value.getClass())) {
                return ((XMLGregorianCalendar)value).getXMLSchemaType();
            }
            if (ClassConstants.DURATION.isAssignableFrom(value.getClass())) {
                return this.getXMLType(ClassConstants.DURATION);
            }
            return this.getXMLType(value.getClass());
        }
        return this.schemaType;
    }

    public void setIsCDATA(boolean CDATA) {
        this.isCDATA = CDATA;
    }

    public boolean isCDATA() {
        return this.isCDATA;
    }

    public boolean isSchemaType(QName schemaType) {
        if (this.getSchemaType() == null) {
            return false;
        }
        return this.getSchemaType().equals(schemaType);
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        try {
            if (!this.isInitialized) {
                return super.equals(object);
            }
            if (this == object) {
                return true;
            }
            XMLField xmlField = (XMLField)object;
            if (!this.xPathFragment.equals(xmlField.getXPathFragment())) {
                return false;
            }
            XPathFragment xpf = this.xPathFragment;
            XPathFragment xpf2 = xmlField.getXPathFragment();
            do {
                if (xpf.getNextFragment() != null) continue;
                return xpf2.getNextFragment() == null;
            } while ((xpf = xpf.getNextFragment()).equals(xpf2 = xpf2.getNextFragment()));
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        if (this.xPathFragment == null) {
            return 1;
        }
        return this.xPathFragment.hashCode();
    }
}

