/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class QueryBasedValueHolder
extends DatabaseValueHolder {
    protected transient ReadQuery query;
    protected transient Object sourceObject;
    protected Integer refreshCascade;

    protected QueryBasedValueHolder() {
    }

    public QueryBasedValueHolder(ReadQuery query, AbstractRecord row, AbstractSession session) {
        this(query, null, row, session);
    }

    public QueryBasedValueHolder(ReadQuery query, Object sourceObject, AbstractRecord row, AbstractSession session) {
        this.row = row;
        this.session = session;
        if (!session.isUnitOfWork()) {
            this.session = session.getRootSession(query);
        }
        this.query = query;
        this.sourceObject = sourceObject;
    }

    public Integer getRefreshCascadePolicy() {
        return this.refreshCascade;
    }

    public ReadQuery getQuery() {
        return this.query;
    }

    @Override
    protected Object instantiate() throws DatabaseException {
        return this.instantiate(this.session);
    }

    protected Object instantiate(AbstractSession session) throws DatabaseException {
        if (session == null) {
            throw ValidationException.instantiatingValueholderWithNullSession();
        }
        if (this.query.isObjectBuildingQuery() && ((ObjectBuildingQuery)this.query).shouldRefreshIdentityMapResult()) {
            this.refreshCascade = ((ObjectBuildingQuery)this.query).getCascadePolicy();
        }
        return session.executeQuery((DatabaseQuery)this.getQuery(), this.getRow());
    }

    @Override
    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate(unitOfWorkValueHolder.getUnitOfWork());
    }

    @Override
    public void postInstantiate() {
        DatabaseMapping mapping = this.query.getSourceMapping();
        if (mapping != null && mapping.isForeignReferenceMapping()) {
            ClassDescriptor descriptor = mapping.getDescriptor();
            if (descriptor == null || descriptor.isAggregateDescriptor()) {
                descriptor = this.session.getDescriptor(this.sourceObject);
            }
            if (descriptor != null) {
                this.session.getIdentityMapAccessorInstance().getIdentityMap(descriptor).lazyRelationshipLoaded(this.sourceObject, this, (ForeignReferenceMapping)this.query.getSourceMapping());
            }
        }
    }

    @Override
    public void releaseWrappedValueHolder(AbstractSession targetSession) {
        AbstractSession session = this.getSession();
        if (session != null && session.isUnitOfWork()) {
            this.setSession(targetSession);
        }
    }

    @Override
    protected void resetFields() {
        super.resetFields();
        this.query = null;
    }

    protected void setQuery(ReadQuery theQuery) {
        this.query = theQuery;
    }

    @Override
    public boolean isPessimisticLockingValueHolder() {
        if (this.query == null || !this.query.isObjectLevelReadQuery()) {
            return false;
        }
        ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.query;
        return query.isLockQuery(this.session);
    }

    public void setSourceObject(Object sourceObject) {
        this.sourceObject = sourceObject;
    }
}

