/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.helper.JavaVersion;

public enum JavaSEPlatform implements Comparable<JavaSEPlatform>
{
    v1_1(1, 1),
    v1_2(1, 2),
    v1_3(1, 3),
    v1_4(1, 4),
    v1_5(1, 5),
    v1_6(1, 6),
    v1_7(1, 7),
    v1_8(1, 8),
    v1_9(1, 9);

    private static final Map<String, JavaSEPlatform> stringValuesMap;
    public static final int LENGTH;
    public static final JavaSEPlatform CURRENT;
    public static final JavaSEPlatform MIN_SUPPORTED;
    private final int major;
    private final int minor;

    static {
        stringValuesMap = new HashMap<String, JavaSEPlatform>(JavaSEPlatform.values().length);
        JavaSEPlatform[] javaSEPlatformArray = JavaSEPlatform.values();
        int n = javaSEPlatformArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaSEPlatform platform = javaSEPlatformArray[n2];
            stringValuesMap.put(platform.versionString(), platform);
            ++n2;
        }
        LENGTH = JavaSEPlatform.values().length;
        CURRENT = JavaVersion.vmVersion().toPlatform();
        MIN_SUPPORTED = v1_7;
    }

    public static boolean is(JavaSEPlatform platform) {
        return CURRENT.equals(platform);
    }

    public static JavaSEPlatform toValue(String platformName) {
        if (platformName != null) {
            return stringValuesMap.get(platformName);
        }
        return null;
    }

    public static JavaSEPlatform toValue(int major, int minor) {
        if (major == 1) {
            switch (minor) {
                case 1: {
                    return v1_1;
                }
                case 2: {
                    return v1_2;
                }
                case 3: {
                    return v1_3;
                }
                case 4: {
                    return v1_4;
                }
                case 5: {
                    return v1_5;
                }
                case 6: {
                    return v1_6;
                }
                case 7: {
                    return v1_7;
                }
                case 8: {
                    return v1_8;
                }
                case 9: {
                    return v1_9;
                }
            }
            return null;
        }
        return null;
    }

    public static final String versionString(int major, int minor) {
        StringBuilder sb = new StringBuilder(4);
        sb.append(Integer.toString(major));
        sb.append('.');
        sb.append(Integer.toString(minor));
        return sb.toString();
    }

    private JavaSEPlatform(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public boolean atLeast(JavaSEPlatform platform) {
        return this.compareTo(platform) >= 0;
    }

    public boolean isSupported() {
        return this.compareTo(MIN_SUPPORTED) >= 0;
    }

    public String versionString() {
        return JavaSEPlatform.versionString(this.major, this.minor);
    }

    public String toString() {
        return JavaSEPlatform.versionString(this.major, this.minor);
    }
}

