/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;

public class PrivilegedAccessHelper {
    private static final String TRUE_STRING = "true";
    private static boolean defaultUseDoPrivilegedValue = false;
    private static boolean shouldCheckPrivilegedAccess = true;
    private static boolean shouldUsePrivilegedAccess = false;
    private static final String[] legalProperties = new String[]{"file.separator", "java.io.tmpdir", "java.specification.version", "line.separator", "path.separator", "user.dir", "org.eclipse.persistence.fetchgroupmonitor", "org.eclipse.persistence.querymonitor", "SAP_J2EE_Engine_Version", "eclipselink.persistencexml", "INTERACT_WITH_DB", "eclipselink.logging.file", "eclipselink.logging.level", "eclipselink.archive.factory", "eclipselink.target-server.enforce", "eclipselink.cache.record-stack-on-lock", "eclipselink.weaving.output.path", "eclipselink.weaving.overwrite.existing", "eclipselink.weaving.reflective-introspection", "eclipselink.query.query-by-example.ignore-xtomany", "eclipselink.mapping.onetomany.defer-inserts", "eclipselink.concurrency.manager.waittime", "eclipselink.concurrency.manager.maxsleeptime", "eclipselink.concurrency.manager.maxfrequencytodumptinymessage", "eclipselink.concurrency.manager.maxfrequencytodumpmassivemessage", "eclipselink.concurrency.manager.allow.interruptedexception", "eclipselink.concurrency.manager.allow.concurrency.exception", "eclipselink.concurrency.manager.allow.readlockstacktrace", "eclipselink.register.run.mbean", "eclipselink.register.dev.mbean", "eclipselink.xml.platform"};
    private static final Set<String> legalPropertiesSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(legalProperties)));
    private static final String[] exemptedProperties = new String[]{"line.separator"};
    private static final Set<String> exemptedPropertiesSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(exemptedProperties)));
    private static Map<String, Class> primitiveClasses = new HashMap<String, Class>();

    public static void setDefaultUseDoPrivilegedValue(boolean def) {
        defaultUseDoPrivilegedValue = def;
        shouldCheckPrivilegedAccess = true;
    }

    private static Field findDeclaredField(Class javaClass, String fieldName) throws NoSuchFieldException {
        try {
            return javaClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            Class superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            return PrivilegedAccessHelper.findDeclaredField(superclass, fieldName);
        }
    }

    private static Method findMethod(Class javaClass, String methodName, Class[] methodParameterTypes) throws NoSuchMethodException {
        try {
            return javaClass.getDeclaredMethod(methodName, methodParameterTypes);
        }
        catch (NoSuchMethodException ex) {
            Class superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            try {
                return PrivilegedAccessHelper.findMethod(superclass, methodName, methodParameterTypes);
            }
            catch (NoSuchMethodException lastEx) {
                throw ex;
            }
        }
    }

    public static Class getClassForName(String className) throws ClassNotFoundException {
        Class primitive = primitiveClasses.get(className);
        if (primitive != null) {
            return primitive;
        }
        return Class.forName(className);
    }

    public static Class getClassForName(String className, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        Class primitive = primitiveClasses.get(className);
        if (primitive != null) {
            return primitive;
        }
        return Class.forName(className, initialize, loader);
    }

    public static ClassLoader getClassLoaderForClass(Class clazz) {
        return clazz.getClassLoader();
    }

    public static Constructor getConstructorFor(Class javaClass, Class[] args, boolean shouldSetAccessible) throws NoSuchMethodException {
        Constructor<Object> result;
        block5: {
            result = null;
            try {
                result = javaClass.getConstructor(args);
            }
            catch (NoSuchMethodException missing) {
                for (Constructor<?> constructor : javaClass.getConstructors()) {
                    if (constructor.getParameterTypes().length != args.length) continue;
                    boolean found = true;
                    for (int index = 0; index < args.length; ++index) {
                        Class argType;
                        Class parameterType = Helper.getObjectClass(constructor.getParameterTypes()[index]);
                        if (parameterType.isAssignableFrom(argType = Helper.getObjectClass(args[index])) || argType.isAssignableFrom(parameterType)) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    result = constructor;
                    break;
                }
                if (result != null) break block5;
                throw missing;
            }
        }
        if (shouldSetAccessible) {
            result.setAccessible(true);
        }
        return result;
    }

    public static ClassLoader getContextClassLoader(Thread thread) {
        return thread.getContextClassLoader();
    }

    public static Constructor getDeclaredConstructorFor(Class javaClass, Class[] args, boolean shouldSetAccessible) throws NoSuchMethodException {
        Constructor result = javaClass.getDeclaredConstructor(args);
        if (shouldSetAccessible) {
            result.setAccessible(true);
        }
        return result;
    }

    public static Field getField(Class javaClass, String fieldName, boolean shouldSetAccessible) throws NoSuchFieldException {
        Field field = PrivilegedAccessHelper.findDeclaredField(javaClass, fieldName);
        if (shouldSetAccessible) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field getDeclaredField(Class javaClass, String fieldName, boolean shouldSetAccessible) throws NoSuchFieldException {
        Field field = javaClass.getDeclaredField(fieldName);
        if (shouldSetAccessible) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field[] getDeclaredFields(Class clazz) {
        return clazz.getDeclaredFields();
    }

    public static Field[] getFields(Class clazz) {
        return clazz.getFields();
    }

    public static Method getDeclaredMethod(Class clazz, String methodName, Class[] methodParameterTypes) throws NoSuchMethodException {
        return clazz.getDeclaredMethod(methodName, methodParameterTypes);
    }

    public static Method getMethod(Class javaClass, String methodName, Class[] methodParameterTypes, boolean shouldSetAccessible) throws NoSuchMethodException {
        Method method = PrivilegedAccessHelper.findMethod(javaClass, methodName, methodParameterTypes);
        if (shouldSetAccessible) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method getPublicMethod(Class javaClass, String methodName, Class[] methodParameterTypes, boolean shouldSetAccessible) throws NoSuchMethodException {
        Method method = javaClass.getMethod(methodName, methodParameterTypes);
        if (shouldSetAccessible) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method[] getDeclaredMethods(Class clazz) {
        return clazz.getDeclaredMethods();
    }

    public static Class getFieldType(Field field) {
        return field.getType();
    }

    private static boolean isIllegalProperty(String key) {
        return key == null || !legalPropertiesSet.contains(key) && !key.startsWith("eclipselink.") && !key.startsWith("jakarta.persistence.") && !key.startsWith("org.eclipse.persistence.") && !key.startsWith("persistence.") && !key.startsWith("javax.xml.") && !key.startsWith("jakarta.xml.");
    }

    private static boolean isExemptedProperty(String key) {
        return key != null && exemptedPropertiesSet.contains(key);
    }

    public static final String getSystemProperty(String key) {
        if (PrivilegedAccessHelper.isIllegalProperty(key)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unexpect_argument", new Object[]{key}));
        }
        if (PrivilegedAccessHelper.isExemptedProperty(key) || PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedGetSystemProperty(key));
        }
        return System.getProperty(key);
    }

    public static final String getSystemProperty(String key, String def) {
        if (PrivilegedAccessHelper.isIllegalProperty(key)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unexpect_argument", new Object[]{key}));
        }
        if (PrivilegedAccessHelper.isExemptedProperty(key) || PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedGetSystemProperty(key, def));
        }
        return System.getProperty(key, def);
    }

    public static final boolean getSystemPropertyBoolean(String key, boolean def) {
        return TRUE_STRING.equalsIgnoreCase(PrivilegedAccessHelper.getSystemProperty(key, def ? TRUE_STRING : ""));
    }

    public static final String getLineSeparator() {
        return PrivilegedAccessHelper.getSystemProperty("line.separator");
    }

    public static Class[] getMethodParameterTypes(Method method) {
        return method.getParameterTypes();
    }

    public static Class getMethodReturnType(Method method) {
        return method.getReturnType();
    }

    public static Method[] getMethods(Class clazz) {
        return clazz.getMethods();
    }

    public static Object getValueFromField(Field field, Object object) throws IllegalAccessException {
        return field.get(object);
    }

    public static Object invokeConstructor(Constructor constructor, Object[] args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return constructor.newInstance(args);
    }

    public static Object invokeMethod(Method method, Object object) throws IllegalAccessException, InvocationTargetException {
        return PrivilegedAccessHelper.invokeMethod(method, object, null);
    }

    public static Object invokeMethod(Method method, Object object, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method.invoke(object, parameters);
    }

    public static <T> T newInstanceFromClass(Class<T> clazz) throws IllegalAccessException, InstantiationException {
        return clazz.newInstance();
    }

    public static void setValueInField(Field field, Object object, Object value) throws IllegalAccessException {
        field.set(object, value);
    }

    public static boolean shouldUsePrivilegedAccess() {
        if (shouldCheckPrivilegedAccess) {
            String usePrivileged;
            shouldUsePrivilegedAccess = System.getSecurityManager() != null ? ((usePrivileged = AccessController.doPrivileged(new PrivilegedGetSystemProperty("eclipselink.security.usedoprivileged"))) == null ? defaultUseDoPrivilegedValue : usePrivileged.equalsIgnoreCase(TRUE_STRING)) : false;
            shouldCheckPrivilegedAccess = false;
        }
        return shouldUsePrivilegedAccess;
    }

    static {
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("void", Void.TYPE);
        primitiveClasses.put("short", Short.TYPE);
    }
}

