/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.PropertyException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Source;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.core.sessions.CoreProject;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jaxb.JAXBSchemaOutputResolver;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.jaxb.ObjectGraphImpl;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGenerator;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelOutputResolver;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBBinder;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBIntrospector;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.JAXBValidator;
import org.eclipse.persistence.jaxb.ObjectGraph;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.javamodel.reflection.AnnotationHelper;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelInputImpl;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.platform.SAXPlatform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventListener;

public class JAXBContext
extends javax.xml.bind.JAXBContext {
    private static final Map<String, Boolean> PARSER_FEATURES = new HashMap<String, Boolean>(2);
    private static final String RI_XML_ACCESSOR_FACTORY_SUPPORT = "com.sun.xml.bind.XmlAccessorFactory";
    protected static final ValidationEventHandler DEFAULT_VALIDATION_EVENT_HANDER;
    protected JAXBContextInput contextInput;
    protected volatile JAXBContextState contextState;
    private XMLInputFactory xmlInputFactory;
    private boolean initializedXMLInputFactory = false;

    static {
        PARSER_FEATURES.put("http://apache.org/xml/features/validation/schema/normalized-value", false);
        PARSER_FEATURES.put("http://apache.org/xml/features/validation/schema/element-default", false);
        DEFAULT_VALIDATION_EVENT_HANDER = new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                return event.getSeverity() < 2;
            }
        };
    }

    protected JAXBContext() {
        this.contextState = new JAXBContextState();
    }

    protected JAXBContext(JAXBContextInput contextInput) throws javax.xml.bind.JAXBException {
        this.contextInput = contextInput;
        this.contextState = contextInput.createContextState();
    }

    public JAXBContext(XMLContext context) {
        this.contextState = new JAXBContextState(context);
    }

    public JAXBContext(XMLContext context, Generator generator, Type[] boundTypes) {
        this.contextState = new JAXBContextState(context, generator, boundTypes, null);
    }

    public JAXBContext(XMLContext context, Generator generator, TypeMappingInfo[] boundTypes) {
        this.contextState = new JAXBContextState(context, generator, boundTypes, null);
    }

    public XMLInputFactory getXMLInputFactory() {
        if (!this.initializedXMLInputFactory) {
            try {
                try {
                    this.xmlInputFactory = XMLInputFactory.newInstance();
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    this.initializedXMLInputFactory = true;
                }
            }
            finally {
                this.initializedXMLInputFactory = true;
            }
        }
        return this.xmlInputFactory;
    }

    void postInitialize() {
        if (this.contextState.generator != null) {
            this.contextState.generator.postInitialize();
        }
    }

    public void refreshMetadata() throws javax.xml.bind.JAXBException {
        JAXBContextState newState = this.newContextState();
        if (newState != null) {
            this.contextState = newState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContextState newContextState() throws javax.xml.bind.JAXBException {
        if (this.contextInput == null) {
            return null;
        }
        JAXBContext jAXBContext = this;
        synchronized (jAXBContext) {
            JAXBContextState newState = this.contextInput.createContextState();
            XMLContext xmlContext = this.getXMLContext();
            xmlContext.setXMLContextState(newState.getXMLContext().getXMLContextState());
            newState.setXMLContext(xmlContext);
            newState.setTypeToTypeMappingInfo(this.contextState.getTypeToTypeMappingInfo());
            return newState;
        }
    }

    boolean isRefreshable() {
        return false;
    }

    public XMLContext getXMLContext() {
        return this.contextState.getXMLContext();
    }

    public void setXMLContext(XMLContext xmlContext) {
        this.contextState.setXMLContext(xmlContext);
    }

    public void generateSchema(SchemaOutputResolver outputResolver) {
        this.generateSchema(outputResolver, null);
    }

    public void generateSchema(SchemaOutputResolver outputResolver, Map<QName, Type> additonalGlobalElements) {
        JAXBContextState currentJAXBContextState = this.contextState;
        if (this.isRefreshable()) {
            try {
                currentJAXBContextState = this.newContextState();
            }
            catch (Exception e) {
                throw JAXBException.exceptionDuringSchemaGeneration((Exception)e);
            }
        }
        XMLContext xmlContext = currentJAXBContextState.getXMLContext();
        Generator generator = currentJAXBContextState.getGenerator();
        if (generator == null) {
            ArrayList<Descriptor> descriptorsToProcess = new ArrayList<Descriptor>();
            List sessions = xmlContext.getSessions();
            for (Session session : sessions) {
                List descriptors = session.getProject().getOrderedDescriptors();
                for (Descriptor xDesc : descriptors) {
                    descriptorsToProcess.add(xDesc);
                }
            }
            SchemaModelGenerator smGen = new SchemaModelGenerator();
            smGen.generateSchemas(descriptorsToProcess, null, (SchemaModelOutputResolver)new JAXBSchemaOutputResolver(outputResolver), additonalGlobalElements);
        } else {
            generator.generateSchemaFiles(outputResolver, additonalGlobalElements);
        }
    }

    public JAXBMarshaller createMarshaller() throws javax.xml.bind.JAXBException {
        return this.contextState.createMarshaller(this);
    }

    public JAXBUnmarshaller createUnmarshaller() throws javax.xml.bind.JAXBException {
        return this.contextState.createUnmarshaller(this);
    }

    public JAXBValidator createValidator() {
        return new JAXBValidator(this.getXMLContext().createValidator());
    }

    public JAXBBinder createBinder() {
        return new JAXBBinder(this.getXMLContext());
    }

    public <T> JAXBBinder createBinder(Class<T> nodeClass) {
        if (nodeClass.getName().equals("org.w3c.dom.Node")) {
            return new JAXBBinder(this.getXMLContext());
        }
        throw new UnsupportedOperationException(JAXBException.unsupportedNodeClass((String)nodeClass.getName()));
    }

    public JAXBIntrospector createJAXBIntrospector() {
        return new JAXBIntrospector(this.getXMLContext());
    }

    public void setQNameToGeneratedClasses(HashMap<QName, Class> qNameToClass) {
        this.contextState.setQNameToGeneratedClasses(qNameToClass);
    }

    public HashMap<String, Class> getClassToGeneratedClasses() {
        return this.contextState.getClassToGeneratedClasses();
    }

    public void setClassToGeneratedClasses(HashMap<String, Class> classToClass) {
        this.contextState.setClassToGeneratedClasses(classToClass);
    }

    public void applyORMMetadata(AbstractSession ormSession) {
        this.getXMLContext().applyORMMetadata(ormSession);
    }

    public HashMap<QName, Class> getQNamesToDeclaredClasses() {
        return this.contextState.getQNamesToDeclaredClasses();
    }

    Map<QName, Class> getQNameToGeneratedClasses() {
        return this.contextState.getQNameToGeneratedClasses();
    }

    public void setQNamesToDeclaredClasses(HashMap<QName, Class> nameToDeclaredClasses) {
        this.contextState.setQNamesToDeclaredClasses(nameToDeclaredClasses);
    }

    public Map<String, Class> getArrayClassesToGeneratedClasses() {
        if (this.contextState.getGenerator() == null) {
            return null;
        }
        return this.contextState.getGenerator().getAnnotationsProcessor().getArrayClassesToGeneratedClasses();
    }

    public Map<Type, Class> getCollectionClassesToGeneratedClasses() {
        if (this.contextState.getGenerator() == null) {
            return null;
        }
        return this.contextState.getGenerator().getAnnotationsProcessor().getCollectionClassesToGeneratedClasses();
    }

    public void initTypeToSchemaType() {
        this.contextState.initTypeToSchemaType();
    }

    public Map<TypeMappingInfo, QName> getTypeMappingInfoToSchemaType() {
        return this.contextState.getTypeMappingInfoToSchemaType();
    }

    public HashMap<Type, QName> getTypeToSchemaType() {
        return this.contextState.getTypeToSchemaType();
    }

    Map<TypeMappingInfo, Class> getTypeMappingInfoToGeneratedType() {
        return this.contextState.getTypeMappingInfoToGeneratedType();
    }

    Map<Type, TypeMappingInfo> getTypeToTypeMappingInfo() {
        return this.contextState.getTypeToTypeMappingInfo();
    }

    void setTypeToTypeMappingInfo(Map<Type, TypeMappingInfo> typeToMappingInfo) {
        this.contextState.setTypeToTypeMappingInfo(typeToMappingInfo);
    }

    void setTypeMappingInfoToJavaTypeAdapaters(Map<TypeMappingInfo, RootLevelXmlAdapter> typeMappingInfoToAdapters) {
        this.contextState.setTypeMappingInfoToJavaTypeAdapaters(typeMappingInfoToAdapters);
    }

    Map<TypeMappingInfo, RootLevelXmlAdapter> getTypeMappingInfoToJavaTypeAdapters() {
        return this.contextState.getTypeMappingInfoToJavaTypeAdapters();
    }

    public <T> T getValueByXPath(Object object, String xPath, NamespaceResolver namespaceResolver, Class<T> returnType) {
        return (T)this.getXMLContext().getValueByXPath(object, xPath, namespaceResolver, returnType);
    }

    public void setValueByXPath(Object object, String xPath, NamespaceResolver namespaceResolver, Object value) {
        this.getXMLContext().setValueByXPath(object, xPath, namespaceResolver, value);
    }

    public Object createByQualifiedName(String namespace, String typeName, boolean isGlobalType) {
        return this.getXMLContext().createByQualifiedName(namespace, typeName, isGlobalType);
    }

    public <T> T createByXPath(Object parentObject, String xPath, NamespaceResolver namespaceResolver, Class<T> returnType) {
        return (T)this.getXMLContext().createByXPath(parentObject, xPath, namespaceResolver, returnType);
    }

    public ObjectGraph createObjectGraph(Class type) {
        CoreAttributeGroup group = new CoreAttributeGroup(null, type, true);
        return new ObjectGraphImpl(group);
    }

    public ObjectGraph createObjectGraph(String typeName) {
        ClassLoader loader = this.contextInput.classLoader;
        try {
            Class cls = PrivilegedAccessHelper.getClassForName((String)typeName, (boolean)true, (ClassLoader)loader);
            return this.createObjectGraph(cls);
        }
        catch (Exception ex) {
            throw ConversionException.couldNotBeConvertedToClass((Object)typeName, Class.class, (Exception)ex);
        }
    }

    protected JAXBElement createJAXBElementFromXMLRoot(Root xmlRoot, Class declaredType) {
        Class declaredClass;
        Object value = xmlRoot.getObject();
        if (value instanceof List) {
            List theList = (List)value;
            int i = 0;
            while (i < theList.size()) {
                Object next = theList.get(i);
                if (next instanceof Root) {
                    theList.set(i, this.createJAXBElementFromXMLRoot((Root)next, declaredType));
                }
                ++i;
            }
        } else {
            if (value instanceof WrappedValue) {
                QName qname = new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName());
                return new JAXBElement(qname, ((WrappedValue)((Object)value)).getDeclaredType(), ((WrappedValue)((Object)value)).getValue());
            }
            if (value instanceof JAXBElement) {
                return (JAXBElement)value;
            }
            if (value instanceof ManyValue) {
                value = ((ManyValue)value).getItem();
            }
        }
        QName qname = new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName());
        HashMap<QName, Class> qNamesToDeclaredClasses = this.getQNamesToDeclaredClasses();
        if (qNamesToDeclaredClasses != null && qNamesToDeclaredClasses.size() > 0 && (declaredClass = (Class)qNamesToDeclaredClasses.get(qname)) != null) {
            return this.createJAXBElement(qname, declaredClass, value);
        }
        Class xmlRootDeclaredType = xmlRoot.getDeclaredType();
        if (xmlRootDeclaredType != null) {
            return this.createJAXBElement(qname, xmlRootDeclaredType, value);
        }
        return this.createJAXBElement(qname, declaredType, value);
    }

    protected JAXBElement createJAXBElement(QName qname, Class theClass, Object value) {
        if (theClass == null) {
            return new JAXBElement(qname, Object.class, value);
        }
        if (CoreClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(theClass)) {
            theClass = CoreClassConstants.XML_GREGORIAN_CALENDAR;
        } else if (CoreClassConstants.DURATION.isAssignableFrom(theClass)) {
            theClass = CoreClassConstants.DURATION;
        }
        return new JAXBElement(qname, theClass, value);
    }

    public boolean hasSwaRef() {
        return this.contextState.getGenerator().getAnnotationsProcessor().hasSwaRef();
    }

    static class ContextPathInput
    extends JAXBContextInput {
        private String contextPath;

        ContextPathInput(String contextPath, Map properties, ClassLoader classLoader) {
            super(properties, classLoader);
            this.contextPath = contextPath;
        }

        @Override
        protected JAXBContextState createContextState() throws javax.xml.bind.JAXBException {
            boolean foundMetadata = false;
            List<Class> classes = new ArrayList<Class>();
            Map<String, XmlBindings> xmlBindingMap = JAXBContextFactory.getXmlBindingsFromProperties(this.properties, this.classLoader);
            foundMetadata = xmlBindingMap != null && !xmlBindingMap.isEmpty();
            classes = this.getXmlBindingsClassesFromMap(xmlBindingMap, this.classLoader, classes);
            StringTokenizer tokenizer = new StringTokenizer(this.contextPath, ":");
            while (tokenizer.hasMoreElements()) {
                String path = tokenizer.nextToken();
                try {
                    Class<?> objectFactory = this.classLoader.loadClass(String.valueOf(path) + ".ObjectFactory");
                    if (this.isJAXB2ObjectFactory(objectFactory, this.classLoader)) {
                        classes.add(objectFactory);
                        foundMetadata = true;
                    }
                }
                catch (Exception exception) {}
                try {
                    this.classLoader.loadClass(String.valueOf(path) + ".package-info");
                }
                catch (Exception exception) {}
                InputStream jaxbIndex = this.classLoader.getResourceAsStream(String.valueOf(path.replace('.', '/')) + "/jaxb.index");
                if (jaxbIndex == null) continue;
                foundMetadata = true;
                BufferedReader reader = new BufferedReader(new InputStreamReader(jaxbIndex));
                try {
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            String className = String.valueOf(path) + "." + line.trim();
                            try {
                                classes.add(this.classLoader.loadClass(className));
                            }
                            catch (Exception exception) {}
                            line = reader.readLine();
                        }
                    }
                    catch (Exception exception) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (foundMetadata) {
                Class[] classArray = new Class[classes.size()];
                int i = 0;
                while (i < classes.size()) {
                    classArray[i] = classes.get(i);
                    ++i;
                }
                return this.createContextState(classArray, xmlBindingMap);
            }
            Exception sessionLoadingException = null;
            try {
                XMLContext xmlContext = new XMLContext(this.contextPath, this.classLoader);
                return new JAXBContextState(xmlContext);
            }
            catch (Exception exception) {
                sessionLoadingException = exception;
                JAXBException jaxbException = JAXBException.noObjectFactoryOrJaxbIndexInPath((String)this.contextPath);
                if (sessionLoadingException != null) {
                    jaxbException.setInternalException((Throwable)sessionLoadingException);
                }
                throw new javax.xml.bind.JAXBException((Throwable)jaxbException);
            }
        }

        private JAXBContextState createContextState(Class[] classesToBeBound, Map<String, XmlBindings> xmlBindings) throws javax.xml.bind.JAXBException {
            JaxbClassLoader loader = new JaxbClassLoader(this.classLoader, classesToBeBound);
            String defaultTargetNamespace = null;
            AnnotationHelper annotationHelper = null;
            boolean enableXmlAccessorFactory = false;
            if (this.properties != null) {
                defaultTargetNamespace = (String)this.properties.get("eclipselink.default-target-namespace");
                if (defaultTargetNamespace == null) {
                    defaultTargetNamespace = (String)this.properties.get("defaultTargetNamespace");
                }
                if ((annotationHelper = (AnnotationHelper)this.properties.get("eclipselink.annotation-helper")) == null) {
                    annotationHelper = (AnnotationHelper)this.properties.get("annotationHelper");
                }
                Boolean xmlAccessorFactorySupport = (Boolean)this.properties.get("eclipselink.xml-accessor-factory.support");
                Boolean xmlAccessorFactorySupportRI = (Boolean)this.properties.get(JAXBContext.RI_XML_ACCESSOR_FACTORY_SUPPORT);
                if (Boolean.TRUE.equals(xmlAccessorFactorySupport) || Boolean.TRUE.equals(xmlAccessorFactorySupportRI)) {
                    enableXmlAccessorFactory = true;
                }
            }
            JavaModelImpl jModel = annotationHelper != null ? new JavaModelImpl(loader, annotationHelper) : new JavaModelImpl(loader);
            HashMap<String, Boolean> metadataComplete = new HashMap<String, Boolean>();
            for (String packageName : xmlBindings.keySet()) {
                if (!xmlBindings.get(packageName).isXmlMappingMetadataComplete()) continue;
                metadataComplete.put(packageName, true);
            }
            if (metadataComplete.size() > 0) {
                jModel.setMetadataCompletePackageMap(metadataComplete);
            }
            JavaModelInputImpl inputImpl = new JavaModelInputImpl(classesToBeBound, (JavaModel)jModel);
            try {
                Generator generator = new Generator((JavaModelInput)inputImpl, xmlBindings, loader, defaultTargetNamespace, enableXmlAccessorFactory);
                return this.createContextState(generator, loader, classesToBeBound, this.properties);
            }
            catch (Exception ex) {
                throw new javax.xml.bind.JAXBException(ex.getMessage(), (Throwable)ex);
            }
        }

        private JAXBContextState createContextState(Generator generator, JaxbClassLoader loader, Type[] typesToBeBound, Map properties) throws Exception {
            CoreProject proj = generator.generateProject();
            ConversionManager conversionManager = null;
            if (this.classLoader != null) {
                conversionManager = new ConversionManager();
                conversionManager.setLoader((ClassLoader)loader);
            } else {
                conversionManager = ConversionManager.getDefaultManager();
            }
            proj.convertClassNamesToClasses(conversionManager.getLoader());
            for (ClassDescriptor descriptor : proj.getOrderedDescriptors()) {
                if (descriptor.getJavaClass() != null) continue;
                descriptor.setJavaClass(conversionManager.convertClassNameToClass(descriptor.getJavaClassName()));
            }
            SAXPlatform platform = new SAXPlatform();
            platform.getConversionManager().setLoader((ClassLoader)loader);
            XMLContext xmlContext = new XMLContext((Project)proj, (ClassLoader)loader, this.sessionEventListeners());
            ((XMLLogin)((DatabaseSession)xmlContext.getSession()).getDatasourceLogin()).setEqualNamespaceResolvers(true);
            return new JAXBContextState(xmlContext, generator, typesToBeBound, properties);
        }

        private List<Class> getXmlBindingsClassesFromMap(Map<String, XmlBindings> xmlBindingMap, ClassLoader classLoader, List<Class> existingClasses) {
            List<Class> additionalClasses = existingClasses;
            for (Map.Entry<String, XmlBindings> entry : xmlBindingMap.entrySet()) {
                additionalClasses = this.getXmlBindingsClasses(entry.getValue(), classLoader, additionalClasses);
            }
            return additionalClasses;
        }

        private List<Class> getXmlBindingsClasses(XmlBindings xmlBindings, ClassLoader classLoader, List<Class> existingClasses) {
            List<Class> additionalClasses = existingClasses;
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    try {
                        Class<?> jClass = classLoader.loadClass(Helper.getQualifiedJavaTypeName(javaType.getName(), xmlBindings.getPackageName()));
                        if (additionalClasses.contains(jClass)) continue;
                        additionalClasses.add(jClass);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw JAXBException.couldNotLoadClassFromMetadata((String)javaType.getName());
                    }
                }
            }
            return additionalClasses;
        }

        private boolean isJAXB2ObjectFactory(Class objectFactoryClass, ClassLoader classLoader) {
            try {
                Class xmlRegistry = PrivilegedAccessHelper.getClassForName((String)"javax.xml.bind.annotation.XmlRegistry", (boolean)false, (ClassLoader)classLoader);
                return objectFactoryClass.isAnnotationPresent(xmlRegistry);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static abstract class JAXBContextInput {
        protected Map properties;
        protected ClassLoader classLoader;

        public JAXBContextInput(Map properties, ClassLoader classLoader) {
            this.properties = properties;
            this.classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        }

        protected abstract JAXBContextState createContextState() throws javax.xml.bind.JAXBException;

        protected Collection<SessionEventListener> sessionEventListeners() {
            ArrayList<SessionEventListener> eventListeners;
            SessionEventListener eventListenerFromProperties = null;
            if (this.properties != null) {
                eventListenerFromProperties = (SessionEventListener)this.properties.get("eclipselink.session-event-listener");
            }
            if (eventListenerFromProperties == null) {
                eventListeners = new ArrayList<SessionEventListener>(1);
            } else {
                eventListeners = new ArrayList(2);
                eventListeners.add(eventListenerFromProperties);
            }
            org.eclipse.persistence.internal.jaxb.SessionEventListener eventListener = new org.eclipse.persistence.internal.jaxb.SessionEventListener();
            eventListener.setShouldValidateInstantiationPolicy(false);
            eventListeners.add((SessionEventListener)eventListener);
            return eventListeners;
        }
    }

    protected static class JAXBContextState {
        private XMLContext xmlContext;
        private Generator generator;
        private Map<QName, Class> qNameToGeneratedClasses;
        private HashMap<String, Class> classToGeneratedClasses;
        private HashMap<QName, Class> qNamesToDeclaredClasses;
        private HashMap<Type, QName> typeToSchemaType;
        private TypeMappingInfo[] boundTypes;
        private Map<TypeMappingInfo, Class> typeMappingInfoToGeneratedType;
        private Map<Type, TypeMappingInfo> typeToTypeMappingInfo;
        private Map<TypeMappingInfo, RootLevelXmlAdapter> typeMappingInfoToJavaTypeAdapters;
        private Map properties;

        protected JAXBContextState() {
        }

        protected JAXBContextState(XMLContext context) {
            this.xmlContext = context;
            this.updateNamespaces();
        }

        protected JAXBContextState(XMLContext context, Generator generator, Type[] boundTypes, Map properties) {
            this(context);
            this.generator = generator;
            this.qNameToGeneratedClasses = generator.getMappingsGenerator().getQNamesToGeneratedClasses();
            this.classToGeneratedClasses = generator.getMappingsGenerator().getClassToGeneratedClasses();
            this.qNamesToDeclaredClasses = generator.getMappingsGenerator().getQNamesToDeclaredClasses();
            this.boundTypes = new TypeMappingInfo[boundTypes.length];
            int i = 0;
            while (i < boundTypes.length) {
                TypeMappingInfo newTypeInfo = new TypeMappingInfo();
                newTypeInfo.setType(boundTypes[i]);
                this.boundTypes[i] = newTypeInfo;
                ++i;
            }
            if (properties != null) {
                this.properties = new HashMap(properties);
            }
        }

        protected JAXBContextState(XMLContext context, Generator generator, TypeMappingInfo[] boundTypes, Map properties) {
            this(context);
            this.generator = generator;
            this.qNameToGeneratedClasses = generator.getMappingsGenerator().getQNamesToGeneratedClasses();
            this.classToGeneratedClasses = generator.getMappingsGenerator().getClassToGeneratedClasses();
            this.qNamesToDeclaredClasses = generator.getMappingsGenerator().getQNamesToDeclaredClasses();
            this.typeMappingInfoToGeneratedType = generator.getAnnotationsProcessor().getTypeMappingInfoToGeneratedClasses();
            this.setTypeMappingInfoToJavaTypeAdapaters(this.createAdaptersForAdapterClasses(generator.getAnnotationsProcessor().getTypeMappingInfoToAdapterClasses()));
            this.boundTypes = boundTypes;
            if (properties != null) {
                this.properties = new HashMap(properties);
            }
        }

        private Map<TypeMappingInfo, RootLevelXmlAdapter> createAdaptersForAdapterClasses(Map<TypeMappingInfo, Class> typeMappingInfoToAdapterClasses) {
            HashMap<TypeMappingInfo, RootLevelXmlAdapter> typeMappingInfoToAdapters = new HashMap<TypeMappingInfo, RootLevelXmlAdapter>();
            for (Map.Entry<TypeMappingInfo, Class> entry : typeMappingInfoToAdapterClasses.entrySet()) {
                Class adapterClass = entry.getValue();
                if (adapterClass == null) continue;
                try {
                    XmlAdapter adapter = (XmlAdapter)adapterClass.newInstance();
                    Class boundType = this.getBoundTypeForXmlAdapterClass(adapterClass);
                    RootLevelXmlAdapter rootLevelXmlAdapter = new RootLevelXmlAdapter(adapter, boundType);
                    typeMappingInfoToAdapters.put(entry.getKey(), rootLevelXmlAdapter);
                }
                catch (Exception exception) {}
            }
            return typeMappingInfoToAdapters;
        }

        private Class getBoundTypeForXmlAdapterClass(Class adapterClass) {
            Class boundType = Object.class;
            Method[] methodArray = PrivilegedAccessHelper.getDeclaredMethods((Class)adapterClass);
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class returnType;
                Method method = methodArray[n2];
                if (method.getName().equals("marshal") && !(returnType = PrivilegedAccessHelper.getMethodReturnType((Method)method)).getName().equals(boundType.getName())) {
                    boundType = returnType;
                    break;
                }
                ++n2;
            }
            return boundType;
        }

        private void updateNamespaces() {
            Collection descriptors = ((DatabaseSession)this.xmlContext.getSession()).getDescriptors().values();
            for (Descriptor desc : descriptors) {
                this.processXMLDescriptor(new ArrayList<Descriptor>(), desc, desc.getNonNullNamespaceResolver());
            }
        }

        private void processRefClasses(List processed, Set refClasses, org.eclipse.persistence.internal.oxm.NamespaceResolver nr) {
            if (refClasses != null) {
                for (Class nextClass : refClasses) {
                    Descriptor desc = (Descriptor)((DatabaseSession)this.xmlContext.getSession()).getProject().getDescriptor(nextClass);
                    this.processXMLDescriptor(processed, desc, nr);
                }
            }
        }

        private void processXMLDescriptor(List<Descriptor> processed, Descriptor desc, org.eclipse.persistence.internal.oxm.NamespaceResolver nr) {
            if (desc == null || processed.contains(desc)) {
                return;
            }
            processed.add(desc);
            Vector mappings = desc.getMappings();
            int i = 0;
            while (i < mappings.size()) {
                Set refClasses;
                DatabaseMapping nextMapping = (DatabaseMapping)mappings.get(i);
                Vector fields = nextMapping.getFields();
                this.updateResolverForFields(fields, nr);
                Descriptor refDesc = (Descriptor)nextMapping.getReferenceDescriptor();
                if (refDesc != null && !processed.contains(refDesc)) {
                    this.processXMLDescriptor(processed, refDesc, nr);
                }
                if (nextMapping instanceof ChoiceObjectMapping) {
                    refClasses = ((ChoiceObjectMapping)nextMapping).getClassToFieldMappings().keySet();
                    this.processRefClasses(processed, refClasses, nr);
                } else if (nextMapping instanceof ChoiceCollectionMapping) {
                    refClasses = ((ChoiceCollectionMapping)nextMapping).getClassToFieldMappings().keySet();
                    this.processRefClasses(processed, refClasses, nr);
                }
                ++i;
            }
        }

        private void updateResolverForFields(Collection fields, org.eclipse.persistence.internal.oxm.NamespaceResolver nr) {
            for (XMLField field : fields) {
                XPathFragment currentFragment = field.getXPathFragment();
                while (currentFragment != null) {
                    String uri = currentFragment.getNamespaceURI();
                    if (uri != null && nr.resolveNamespaceURI(uri) == null && !uri.equals(nr.getDefaultNamespaceURI())) {
                        String prefix = currentFragment.getPrefix();
                        if (prefix == null) {
                            prefix = nr.generatePrefix();
                        }
                        nr.put(prefix, uri);
                    }
                    currentFragment = currentFragment.getNextFragment();
                }
            }
        }

        private HashMap<String, Class> getClassToGeneratedClasses() {
            return this.classToGeneratedClasses;
        }

        private Generator getGenerator() {
            return this.generator;
        }

        private XMLContext getXMLContext() {
            return this.xmlContext;
        }

        private HashMap<Type, QName> getTypeToSchemaType() {
            if (this.typeToSchemaType == null) {
                this.initTypeToSchemaType();
            }
            return this.typeToSchemaType;
        }

        private Map<TypeMappingInfo, Class> getTypeMappingInfoToGeneratedType() {
            return this.typeMappingInfoToGeneratedType;
        }

        private Map<TypeMappingInfo, RootLevelXmlAdapter> getTypeMappingInfoToJavaTypeAdapters() {
            return this.typeMappingInfoToJavaTypeAdapters;
        }

        private Map<Type, TypeMappingInfo> getTypeToTypeMappingInfo() {
            return this.typeToTypeMappingInfo;
        }

        private Map<TypeMappingInfo, QName> getTypeMappingInfoToSchemaType() {
            if (this.typeToTypeMappingInfo != null && this.typeToTypeMappingInfo.size() > 0) {
                return new HashMap<TypeMappingInfo, QName>();
            }
            return this.generator.getAnnotationsProcessor().getTypeMappingInfoToSchemaType();
        }

        private HashMap<QName, Class> getQNamesToDeclaredClasses() {
            return this.qNamesToDeclaredClasses;
        }

        private QName getSchemaTypeForTypeMappingInfo(Type type) {
            QName name = null;
            if (type instanceof Class && (name = this.generator.getAnnotationsProcessor().getUserDefinedSchemaTypes().get(((Class)type).getName())) == null) {
                Class theClass = (Class)type;
                name = type == CoreClassConstants.ABYTE || type == CoreClassConstants.APBYTE || type == Image.class || type == Source.class || theClass.getCanonicalName().equals("javax.activation.DataHandler") ? Constants.BASE_64_BINARY_QNAME : (type == CoreClassConstants.OBJECT ? Constants.ANY_TYPE_QNAME : (type == CoreClassConstants.XML_GREGORIAN_CALENDAR ? Constants.ANY_SIMPLE_TYPE_QNAME : (QName)XMLConversionManager.getDefaultJavaTypes().get(type)));
            }
            return name;
        }

        private Map<QName, Class> getQNameToGeneratedClasses() {
            return this.qNameToGeneratedClasses;
        }

        private void initTypeToSchemaType() {
            this.typeToSchemaType = new HashMap();
            if (this.typeToTypeMappingInfo == null || this.typeToTypeMappingInfo.size() == 0) {
                return;
            }
            for (Object next : ((DatabaseSession)this.xmlContext.getSession()).getProject().getOrderedDescriptors()) {
                Class javaClass = next.getJavaClass();
                if (next.getSchemaReference() == null) continue;
                QName schemaType = next.getSchemaReference().getSchemaContextAsQName(next.getNamespaceResolver());
                Type type = null;
                if (this.generator != null) {
                    type = this.generator.getAnnotationsProcessor().getGeneratedClassesToCollectionClasses().get(javaClass);
                    if (type == null) {
                        JavaClass arrayClass = this.generator.getAnnotationsProcessor().getGeneratedClassesToArrayClasses().get(javaClass);
                        if (arrayClass != null) {
                            String arrayClassName = arrayClass.getName();
                            try {
                                type = PrivilegedAccessHelper.getClassForName((String)arrayClassName);
                            }
                            catch (Exception exception) {}
                        }
                        if (type == null && this.getTypeMappingInfoToGeneratedType() != null) {
                            for (Map.Entry<TypeMappingInfo, Class> entry : this.getTypeMappingInfoToGeneratedType().entrySet()) {
                                if (!entry.getValue().equals(javaClass)) continue;
                                type = entry.getKey().getType();
                                break;
                            }
                        }
                    }
                    if (type == null) {
                        type = javaClass;
                    }
                } else {
                    type = javaClass;
                }
                this.typeToSchemaType.put(type, schemaType);
            }
            if (this.boundTypes != null) {
                TypeMappingInfo[] typeMappingInfoArray = this.boundTypes;
                int n = this.boundTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Type nextType;
                    QName name;
                    Object next;
                    next = typeMappingInfoArray[n2];
                    if (this.typeToSchemaType.get(next) == null && (name = this.getSchemaTypeForTypeMappingInfo(nextType = ((TypeMappingInfo)next).getType())) != null) {
                        this.typeToSchemaType.put(nextType, name);
                    }
                    ++n2;
                }
            }
        }

        private void setClassToGeneratedClasses(HashMap<String, Class> classToClass) {
            this.classToGeneratedClasses = classToClass;
        }

        private void setTypeToTypeMappingInfo(Map<Type, TypeMappingInfo> typeToMappingInfo) {
            this.typeToTypeMappingInfo = typeToMappingInfo;
            if (this.generator != null) {
                this.generator.setTypeToTypeMappingInfo(typeToMappingInfo);
            }
        }

        private void setTypeMappingInfoToJavaTypeAdapaters(Map<TypeMappingInfo, RootLevelXmlAdapter> typeMappingInfoToAdapters) {
            this.typeMappingInfoToJavaTypeAdapters = typeMappingInfoToAdapters;
        }

        private void setQNamesToDeclaredClasses(HashMap<QName, Class> nameToDeclaredClasses) {
            this.qNamesToDeclaredClasses = nameToDeclaredClasses;
        }

        private void setQNameToGeneratedClasses(Map<QName, Class> qNameToClass) {
            this.qNameToGeneratedClasses = qNameToClass;
        }

        public void setXMLContext(XMLContext xmlContext) {
            this.xmlContext = xmlContext;
        }

        public JAXBMarshaller createMarshaller(JAXBContext jaxbContext) throws javax.xml.bind.JAXBException {
            JAXBMarshaller marshaller = new JAXBMarshaller(this.xmlContext.createMarshaller(), new JAXBIntrospector(this.xmlContext));
            marshaller.setJaxbContext(jaxbContext);
            if (this.generator != null && this.generator.hasMarshalCallbacks()) {
                Iterator callIt = this.generator.getMarshalCallbacks().keySet().iterator();
                while (callIt.hasNext()) {
                    MarshalCallback cb = (MarshalCallback)this.generator.getMarshalCallbacks().get(callIt.next());
                    cb.initialize(this.generator.getClass().getClassLoader());
                }
                marshaller.setMarshalCallbacks(this.generator.getMarshalCallbacks());
            }
            if (this.properties != null) {
                this.setPropertyOnMarshaller("eclipselink.media-type", marshaller);
                this.setPropertyOnMarshaller("eclipselink.json.attribute-prefix", marshaller);
                this.setPropertyOnMarshaller("eclipselink.namespace-prefix-mapper", marshaller);
                this.setPropertyOnMarshaller("eclipselink.json.include-root", marshaller);
                this.setPropertyOnMarshaller("eclipselink.json.value-wrapper", marshaller);
                this.setPropertyOnMarshaller("eclipselink.json.namespace-separator", marshaller);
                this.setPropertyOnMarshaller("eclipselink.object-graph", marshaller);
                this.setPropertyOnMarshaller("eclipselink.json.wrapper-as-array-name", marshaller);
            }
            return marshaller;
        }

        public JAXBUnmarshaller createUnmarshaller(JAXBContext jaxbContext) throws javax.xml.bind.JAXBException {
            JAXBUnmarshaller unmarshaller = new JAXBUnmarshaller(this.xmlContext.createUnmarshaller(PARSER_FEATURES));
            if (this.generator != null && this.generator.hasUnmarshalCallbacks()) {
                Iterator callIt = this.generator.getUnmarshalCallbacks().keySet().iterator();
                while (callIt.hasNext()) {
                    UnmarshalCallback cb = (UnmarshalCallback)this.generator.getUnmarshalCallbacks().get(callIt.next());
                    cb.initialize(this.generator.getClass().getClassLoader());
                }
                unmarshaller.setUnmarshalCallbacks(this.generator.getUnmarshalCallbacks());
            }
            unmarshaller.setJaxbContext(jaxbContext);
            if (this.properties != null) {
                this.setPropertyOnUnmarshaller("eclipselink.media-type", unmarshaller);
                this.setPropertyOnUnmarshaller("eclipselink.json.attribute-prefix", unmarshaller);
                this.setPropertyOnUnmarshaller("eclipselink.namespace-prefix-mapper", unmarshaller);
                this.setPropertyOnUnmarshaller("eclipselink.json.include-root", unmarshaller);
                this.setPropertyOnUnmarshaller("eclipselink.json.value-wrapper", unmarshaller);
                this.setPropertyOnUnmarshaller("eclipselink.json.namespace-separator", unmarshaller);
                this.setPropertyOnUnmarshaller("eclipselink.object-graph", unmarshaller);
                this.setPropertyOnUnmarshaller("eclipselink.json.wrapper-as-array-name", unmarshaller);
            }
            return unmarshaller;
        }

        private void setPropertyOnMarshaller(String propertyName, JAXBMarshaller marshaller) throws PropertyException {
            Object propertyValue = this.properties.get(propertyName);
            if (propertyValue != null) {
                marshaller.setProperty(propertyName, propertyValue);
            }
        }

        private void setPropertyOnUnmarshaller(String propertyName, JAXBUnmarshaller unmarshaller) throws PropertyException {
            Object propertyValue = this.properties.get(propertyName);
            if (propertyValue != null) {
                unmarshaller.setProperty(propertyName, propertyValue);
            }
        }
    }

    static class RootLevelXmlAdapter {
        private XmlAdapter xmlAdapter;
        private Class boundType;

        public RootLevelXmlAdapter(XmlAdapter adapter, Class boundType) {
            this.xmlAdapter = adapter;
            this.boundType = boundType;
        }

        public XmlAdapter getXmlAdapter() {
            return this.xmlAdapter;
        }

        public Class getBoundType() {
            return this.boundType;
        }

        public void setXmlAdapter(XmlAdapter xmlAdapter) {
            this.xmlAdapter = xmlAdapter;
        }

        public void setBoundType(Class boundType) {
            this.boundType = boundType;
        }
    }

    static class TypeMappingInfoInput
    extends JAXBContextInput {
        private TypeMappingInfo[] typeMappingInfo;

        TypeMappingInfoInput(TypeMappingInfo[] typeMappingInfo, Map properties, ClassLoader classLoader) {
            super(properties, classLoader);
            this.typeMappingInfo = typeMappingInfo;
        }

        @Override
        protected JAXBContextState createContextState() throws javax.xml.bind.JAXBException {
            Map<String, XmlBindings> xmlBindings = JAXBContextFactory.getXmlBindingsFromProperties(this.properties, this.classLoader);
            String defaultTargetNamespace = null;
            AnnotationHelper annotationHelper = null;
            boolean enableXmlAccessorFactory = false;
            if (this.properties != null) {
                defaultTargetNamespace = (String)this.properties.get("eclipselink.default-target-namespace");
                if (defaultTargetNamespace == null) {
                    defaultTargetNamespace = (String)this.properties.get("defaultTargetNamespace");
                }
                if ((annotationHelper = (AnnotationHelper)this.properties.get("eclipselink.annotation-helper")) == null) {
                    annotationHelper = (AnnotationHelper)this.properties.get("annotationHelper");
                }
                Boolean xmlAccessorFactorySupport = (Boolean)this.properties.get("eclipselink.xml-accessor-factory.support");
                Boolean xmlAccessorFactorySupportRI = (Boolean)this.properties.get(JAXBContext.RI_XML_ACCESSOR_FACTORY_SUPPORT);
                if (Boolean.TRUE.equals(xmlAccessorFactorySupport) || Boolean.TRUE.equals(xmlAccessorFactorySupportRI)) {
                    enableXmlAccessorFactory = true;
                }
            }
            TypeMappingInfo[] typesToBeBound = this.typeMappingInfo;
            for (Map.Entry<String, XmlBindings> entry : xmlBindings.entrySet()) {
                typesToBeBound = TypeMappingInfoInput.getXmlBindingsClasses(entry.getValue(), this.classLoader, typesToBeBound);
            }
            JaxbClassLoader loader = new JaxbClassLoader(this.classLoader, typesToBeBound);
            JavaModelImpl jModel = annotationHelper != null ? new JavaModelImpl(loader, annotationHelper) : new JavaModelImpl(loader);
            HashMap<String, Boolean> metadataComplete = new HashMap<String, Boolean>();
            for (String packageName : xmlBindings.keySet()) {
                if (!xmlBindings.get(packageName).isXmlMappingMetadataComplete()) continue;
                metadataComplete.put(packageName, true);
            }
            if (metadataComplete.size() > 0) {
                jModel.setMetadataCompletePackageMap(metadataComplete);
            }
            JavaModelInputImpl inputImpl = new JavaModelInputImpl(typesToBeBound, (JavaModel)jModel);
            try {
                Generator generator = new Generator(inputImpl, typesToBeBound, inputImpl.getJavaClasses(), null, xmlBindings, this.classLoader, defaultTargetNamespace, enableXmlAccessorFactory);
                JAXBContextState contextState = this.createContextState(generator, loader, typesToBeBound, this.properties);
                return contextState;
            }
            catch (Exception ex) {
                throw new javax.xml.bind.JAXBException(ex.getMessage(), (Throwable)ex);
            }
        }

        private JAXBContextState createContextState(Generator generator, JaxbClassLoader loader, TypeMappingInfo[] typesToBeBound, Map properties) throws Exception {
            CoreProject proj = generator.generateProject();
            ConversionManager conversionManager = null;
            if (this.classLoader != null) {
                conversionManager = new ConversionManager();
                conversionManager.setLoader((ClassLoader)loader);
            } else {
                conversionManager = ConversionManager.getDefaultManager();
            }
            proj.convertClassNamesToClasses(conversionManager.getLoader());
            for (ClassDescriptor descriptor : proj.getOrderedDescriptors()) {
                if (descriptor.getJavaClass() != null) continue;
                descriptor.setJavaClass(conversionManager.convertClassNameToClass(descriptor.getJavaClassName()));
            }
            SAXPlatform platform = new SAXPlatform();
            platform.getConversionManager().setLoader((ClassLoader)loader);
            XMLContext xmlContext = new XMLContext((Project)proj, (ClassLoader)loader, this.sessionEventListeners());
            ((XMLLogin)((DatabaseSession)xmlContext.getSession()).getDatasourceLogin()).setEqualNamespaceResolvers(true);
            JAXBContextState contextState = new JAXBContextState(xmlContext, generator, typesToBeBound, properties);
            TypeMappingInfo[] typeMappingInfoArray = typesToBeBound;
            int n = typesToBeBound.length;
            int n2 = 0;
            while (n2 < n) {
                Class generatedClass;
                TypeMappingInfo typeMappingInfo = typeMappingInfoArray[n2];
                Type classToLookup = typeMappingInfo.getType();
                if (contextState.getTypeMappingInfoToGeneratedType() != null && contextState.getTypeMappingInfoToGeneratedType().size() > 0 && (generatedClass = (Class)contextState.getTypeMappingInfoToGeneratedType().get(typeMappingInfo)) != null) {
                    classToLookup = generatedClass;
                }
                if (classToLookup != null && classToLookup.getClass() == Class.class) {
                    Descriptor xmlDescriptor = (Descriptor)proj.getDescriptor((Class)classToLookup);
                    typeMappingInfo.setXmlDescriptor(xmlDescriptor);
                }
                ++n2;
            }
            return contextState;
        }

        private static TypeMappingInfo[] getXmlBindingsClasses(XmlBindings xmlBindings, ClassLoader classLoader, TypeMappingInfo[] existingTypes) {
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                ArrayList existingClasses = new ArrayList(existingTypes.length);
                TypeMappingInfo[] typeMappingInfoArray = existingTypes;
                int n = existingTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeMappingInfo typeMappingInfo = typeMappingInfoArray[n2];
                    Type type = typeMappingInfo.getType();
                    if (type == null) {
                        throw JAXBException.nullTypeOnTypeMappingInfo((QName)typeMappingInfo.getXmlTagName());
                    }
                    if (type instanceof Class) {
                        Class cls = (Class)type;
                        existingClasses.add(cls);
                    }
                    ++n2;
                }
                ArrayList<TypeMappingInfo> additionalTypeMappingInfos = new ArrayList<TypeMappingInfo>(jTypes.getJavaType().size());
                for (JavaType javaType : jTypes.getJavaType()) {
                    try {
                        Class<?> nextClass = classLoader.loadClass(Helper.getQualifiedJavaTypeName(javaType.getName(), xmlBindings.getPackageName()));
                        if (existingClasses.contains(nextClass)) continue;
                        TypeMappingInfo typeMappingInfo = new TypeMappingInfo();
                        typeMappingInfo.setType(nextClass);
                        additionalTypeMappingInfos.add(typeMappingInfo);
                        existingClasses.add(nextClass);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw JAXBException.couldNotLoadClassFromMetadata((String)javaType.getName());
                    }
                }
                TypeMappingInfo[] allTypeMappingInfos = new TypeMappingInfo[existingTypes.length + additionalTypeMappingInfos.size()];
                System.arraycopy(existingTypes, 0, allTypeMappingInfos, 0, existingTypes.length);
                Object[] additionalTypes = additionalTypeMappingInfos.toArray();
                System.arraycopy(additionalTypes, 0, allTypeMappingInfos, existingTypes.length, additionalTypes.length);
                return allTypeMappingInfos;
            }
            return existingTypes;
        }
    }
}

